/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.normalize;

import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;

class NormalizeRealTypeComputer<T extends RealType<T>>
extends AbstractUnaryComputerOp<T, T>
implements Converter<T, T> {
    private double targetMin;
    private double targetMax;
    private double sourceMin;
    private double factor;

    public NormalizeRealTypeComputer() {
    }

    public NormalizeRealTypeComputer(double sourceMin, double sourceMax, double targetMin, double targetMax) {
        this.setup(sourceMin, sourceMax, targetMin, targetMax);
    }

    public void setup(double sourceMin, double sourceMax, double targetMin, double targetMax) {
        this.sourceMin = sourceMin;
        double tmp = sourceMax;
        this.targetMin = targetMin;
        this.targetMax = targetMax;
        this.factor = 1.0 / (tmp - this.sourceMin) * (this.targetMax - this.targetMin);
    }

    @Override
    public void compute(T input, T output) {
        double res = (input.getRealDouble() - this.sourceMin) * this.factor + this.targetMin;
        if (res > this.targetMax) {
            output.setReal(this.targetMax);
        } else if (res < this.targetMin) {
            output.setReal(this.targetMin);
        } else {
            output.setReal(res);
        }
    }

    public void convert(T input, T output) {
        this.compute(input, output);
    }
}

