/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.watershed;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.create.imgLabeling.CreateImgLabelingFromInterval;
import net.imagej.ops.image.watershed.Watershed;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.Watershed.class)
public class WatershedBinary<T extends BooleanType<T>, B extends BooleanType<B>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, ImgLabeling<Integer, IntType>>
implements Ops.Image.Watershed,
Contingent {
    private UnaryFunctionOp<Interval, ImgLabeling> createOp;
    @Parameter(required=true)
    private boolean useEightConnectivity;
    @Parameter(required=true)
    private boolean drawWatersheds;
    @Parameter(required=true)
    private double[] sigma;
    @Parameter(required=false)
    private RandomAccessibleInterval<B> mask;

    @Override
    public void compute(RandomAccessibleInterval<T> in, ImgLabeling<Integer, IntType> out) {
        RandomAccessibleInterval distMap = this.ops().image().distancetransform(in);
        Img<FloatType> invertedDT = this.ops().create().img((Dimensions)in, new FloatType());
        this.ops().image().invert(Views.iterable(invertedDT), Views.iterable(distMap));
        RandomAccessibleInterval gauss = this.ops().filter().gauss(invertedDT, this.sigma);
        this.ops().run(Watershed.class, out, gauss, this.useEightConnectivity, this.drawWatersheds, this.mask);
    }

    @Override
    public boolean conforms() {
        boolean conformed = this.sigma.length >= ((RandomAccessibleInterval)this.in()).numDimensions();
        for (int i = 0; i < this.sigma.length; ++i) {
            conformed &= this.sigma[i] >= 0.0;
        }
        if (this.mask != null) {
            conformed &= Intervals.equalDimensions(this.mask, (Interval)((Interval)this.in()));
        }
        return conformed;
    }

    @Override
    public ImgLabeling<Integer, IntType> createOutput(RandomAccessibleInterval<T> in) {
        return this.createOp.calculate((Interval)in);
    }

    @Override
    public void initialize() {
        this.createOp = Functions.unary(this.ops(), CreateImgLabelingFromInterval.class, ImgLabeling.class, this.in(), new Object[0]);
    }
}

