/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv;

import java.awt.Component;
import javax.swing.JTree;
import org.janelia.saalfeldlab.n5.metadata.N5ViewerMultichannelMetadata;
import org.janelia.saalfeldlab.n5.ui.N5DatasetTreeCellRenderer;
import org.janelia.saalfeldlab.n5.ui.N5SwingTreeNode;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMultichannelMetadata;

public class N5ViewerTreeCellRenderer
extends N5DatasetTreeCellRenderer {
    private static final long serialVersionUID = -4245251506197982653L;

    public N5ViewerTreeCellRenderer(boolean showConversionWarning) {
        super(showConversionWarning);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, exp, leaf, row, hasFocus);
        if (value instanceof N5SwingTreeNode) {
            N5SwingTreeNode node = (N5SwingTreeNode)value;
            N5Metadata meta = node.getMetadata();
            if (meta != null) {
                String memStr = this.memString((N5TreeNode)node);
                String memSizeString = memStr.isEmpty() ? "" : " (" + memStr + ")";
                String name = node.getParent() == null ? this.rootName : node.getNodeName();
                String multiscaleString = meta instanceof MultiscaleMetadata ? "multiscale" : "";
                String multiChannelString = meta instanceof N5ViewerMultichannelMetadata || meta instanceof CanonicalMultichannelMetadata ? "multichannel" : "";
                this.setText(String.join((CharSequence)"", "<html>", String.format("<b>%s</b>", name), " (", this.getParameterString((N5TreeNode)node), multiChannelString, multiscaleString, ")", memSizeString, "</html>"));
            } else {
                this.setText(node.getParent() == null ? this.rootName : node.getNodeName());
            }
        }
        return this;
    }
}

