/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.tool.Tool;
import org.scijava.tool.ToolService;
import org.scijava.ui.ToolBar;
import org.scijava.ui.UIService;

public class AWTToolBar
extends Panel
implements ToolBar {
    private final Map<String, Button> toolButtons;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ToolService toolService;
    @Parameter
    private UIService uiService;
    @Parameter
    private LogService log;

    public AWTToolBar(Context context) {
        context.inject((Object)this);
        this.toolButtons = new HashMap<String, Button>();
        this.setLayout(new FlowLayout());
        this.populateToolBar();
    }

    private void populateToolBar() {
        Tool lastTool = null;
        for (Tool tool : this.toolService.getTools()) {
            try {
                Button button = this.createButton(tool);
                this.toolButtons.put(tool.getInfo().getName(), button);
                this.add(button);
                if (this.toolService.isSeparatorNeeded(tool, lastTool)) {
                    this.add(new Label(" "));
                }
                lastTool = tool;
            }
            catch (InstantiableException e) {
                this.log.warn((Object)("Invalid tool: " + tool.getInfo()), (Throwable)e);
            }
        }
    }

    private Button createButton(final Tool tool) throws InstantiableException {
        PluginInfo info = tool.getInfo();
        String name = info.getName();
        String label = info.getLabel();
        URL iconURL = info.getIconURL();
        final Image iconImage = this.loadImage(iconURL);
        boolean enabled = info.isEnabled();
        boolean visible = info.isVisible();
        Button button = new Button(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (iconImage == null) {
                    return;
                }
                int buttonWidth = this.getWidth();
                int buttonHeight = this.getHeight();
                int iconWidth = iconImage.getWidth(this);
                int iconHeight = iconImage.getHeight(this);
                g.drawImage(iconImage, (buttonWidth - iconWidth) / 2, (buttonHeight - iconHeight) / 2, this);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(32, 32);
            }
        };
        if (iconURL == null) {
            if (label != null && !label.isEmpty()) {
                button.setLabel(label);
            } else {
                button.setLabel(name);
            }
            this.log.warn((Object)("Invalid icon for tool: " + tool));
        }
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AWTToolBar.this.statusService.showStatus(tool.getDescription());
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AWTToolBar.this.statusService.clearStatus();
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 0) {
                    return;
                }
                if (evt.getButton() == 1) {
                    return;
                }
                tool.configure();
            }
        });
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AWTToolBar.this.toolService.setActiveTool(tool);
            }
        });
        button.setEnabled(enabled);
        button.setVisible(visible);
        return button;
    }

    private Image loadImage(URL iconURL) {
        return Toolkit.getDefaultToolkit().createImage(iconURL);
    }
}

