/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.SuperEllipsoid;
import net.imglib2.roi.geom.real.WritableSuperEllipsoid;
import net.imglib2.roi.util.AbstractRealMaskPoint;
import net.imglib2.roi.util.RealLocalizableRealPositionable;

public abstract class AbstractWritableSuperEllipsoid
extends AbstractEuclideanSpace
implements WritableSuperEllipsoid {
    protected double exponent;
    protected final double[] center;
    protected final double[] semiAxisLengths;

    public AbstractWritableSuperEllipsoid(double[] center, double[] semiAxisLengths, double exponent) {
        super(Math.min(center.length, semiAxisLengths.length));
        if (exponent <= 0.0) {
            throw new IllegalArgumentException("exponent must be positve and non-zero");
        }
        this.exponent = exponent;
        this.semiAxisLengths = new double[this.n];
        this.center = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            double val = semiAxisLengths[i];
            if (val <= 0.0) {
                throw new IllegalArgumentException("Semi-axis lengths must be positive and non-zero");
            }
            this.semiAxisLengths[i] = val;
            this.center[i] = center[i];
        }
    }

    public double realMin(int d) {
        return this.center[d] - this.semiAxisLengths[d];
    }

    public double realMax(int d) {
        return this.center[d] + this.semiAxisLengths[d];
    }

    @Override
    public double exponent() {
        return this.exponent;
    }

    @Override
    public double semiAxisLength(int d) {
        return this.semiAxisLengths[d];
    }

    @Override
    public RealLocalizableRealPositionable center() {
        return new SuperEllipsoidCenter(this.center);
    }

    @Override
    public void setExponent(double exponent) {
        if (exponent <= 0.0) {
            throw new IllegalArgumentException("exponent must be positve and non-zero");
        }
        this.exponent = exponent;
    }

    @Override
    public void setSemiAxisLength(int d, double length) {
        if (length <= 0.0) {
            throw new IllegalArgumentException("Semi-axis length must be positive and non-zero");
        }
        this.semiAxisLengths[d] = length;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SuperEllipsoid && SuperEllipsoid.equals(this, (SuperEllipsoid)obj);
    }

    public int hashCode() {
        return SuperEllipsoid.hashCode(this);
    }

    protected double distancePowered(RealLocalizable l) {
        assert (l.numDimensions() >= this.n) : "l must have no less than " + this.n + " dimensions";
        double distancePowered = 0.0;
        for (int d = 0; d < this.n; ++d) {
            distancePowered += Math.pow(Math.abs((l.getDoublePosition(d) - this.center[d]) / this.semiAxisLengths[d]), this.exponent);
        }
        return distancePowered;
    }

    private class SuperEllipsoidCenter
    extends AbstractRealMaskPoint {
        public SuperEllipsoidCenter(double[] pos) {
            super(pos);
        }

        @Override
        public void updateBounds() {
        }
    }
}

