/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collection;
import java.util.List;
import net.imglib2.AbstractRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.GeomMaths;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.roi.geom.real.Polyshape;
import net.imglib2.roi.geom.real.WritablePolygon2D;
import net.imglib2.roi.util.AbstractRealMaskPoint;
import net.imglib2.roi.util.RealLocalizableRealPositionable;

public class DefaultWritablePolygon2D
extends AbstractRealInterval
implements WritablePolygon2D {
    protected final VertexList x;
    protected final VertexList y;

    public DefaultWritablePolygon2D(List<? extends RealLocalizable> vertices) {
        super(2);
        this.x = new VertexList(vertices.size());
        this.y = new VertexList(vertices.size());
        this.populateXY(vertices);
    }

    public DefaultWritablePolygon2D(double[] x, double[] y) {
        super(GeomMaths.getBoundsReal(x, y));
        if (x.length == y.length) {
            this.x = new VertexList(x);
            this.y = new VertexList(y);
        } else {
            int l = x.length < y.length ? x.length : y.length;
            this.x = new VertexList(l);
            this.x.add(x, 0, l);
            this.y = new VertexList(l);
            this.y.add(y, 0, l);
        }
    }

    @Override
    public boolean test(RealLocalizable localizable) {
        return GeomMaths.pnpoly(this.x, this.y, localizable);
    }

    @Override
    public RealLocalizableRealPositionable vertex(int pos) {
        return new Polygon2DVertex(pos);
    }

    @Override
    public int numVertices() {
        return this.x.size();
    }

    @Override
    public void addVertex(int index, RealLocalizable vertex) {
        double px = vertex.getDoublePosition(0);
        double py = vertex.getDoublePosition(1);
        this.x.insert(index, px);
        this.y.insert(index, py);
        this.expandMinMax(px, py, px, py);
    }

    @Override
    public void removeVertex(int index) {
        this.x.removeAt(index);
        this.y.removeAt(index);
        this.updateMinMax();
    }

    @Override
    public void addVertices(int index, Collection<RealLocalizable> vertices) {
        this.x.makeRoom(index, vertices.size());
        this.y.makeRoom(index, vertices.size());
        int offset = index;
        for (RealLocalizable vertex : vertices) {
            this.x.setQuick(offset, vertex.getDoublePosition(0));
            this.y.setQuick(offset, vertex.getDoublePosition(1));
            ++offset;
        }
        RealInterval bounds = GeomMaths.getBoundsReal(vertices);
        this.expandMinMax(bounds.realMin(0), bounds.realMin(1), bounds.realMax(0), bounds.realMax(1));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Polygon2D && Polyshape.equals(this, (Polygon2D)obj);
    }

    public int hashCode() {
        return Polygon2D.hashCode(this);
    }

    private void populateXY(List<? extends RealLocalizable> vertices) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vertices.size(); ++i) {
            double xi = vertices.get(i).getDoublePosition(0);
            double yi = vertices.get(i).getDoublePosition(1);
            this.x.add(xi);
            this.y.add(yi);
            if (xi > maxX) {
                maxX = xi;
            }
            if (xi < minX) {
                minX = xi;
            }
            if (yi > maxY) {
                maxY = yi;
            }
            if (!(yi < minY)) continue;
            minY = yi;
        }
        this.max[0] = maxX;
        this.max[1] = maxY;
        this.min[0] = minX;
        this.min[1] = minY;
    }

    private void updateMinMax() {
        this.min[1] = Double.POSITIVE_INFINITY;
        this.min[0] = Double.POSITIVE_INFINITY;
        this.max[1] = Double.NEGATIVE_INFINITY;
        this.max[0] = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numVertices(); ++i) {
            double px = this.x.get(i);
            double py = this.y.get(i);
            this.expandMinMax(px, py, px, py);
        }
    }

    private void expandMinMax(double xMin, double yMin, double xMax, double yMax) {
        if (xMax > this.max[0]) {
            this.max[0] = xMax;
        }
        if (yMax > this.max[1]) {
            this.max[1] = yMax;
        }
        if (xMin < this.min[0]) {
            this.min[0] = xMin;
        }
        if (yMin < this.min[1]) {
            this.min[1] = yMin;
        }
    }

    protected class VertexList
    extends TDoubleArrayList {
        public VertexList(int size) {
            super(size);
        }

        public VertexList(double[] x) {
            super(x);
        }

        protected void makeRoom(int offset, int count) {
            this.ensureCapacity(this.size() + count);
            System.arraycopy(this._data, offset, this._data, offset + count, this.size() - offset);
            this._pos += count;
        }
    }

    private class Polygon2DVertex
    extends AbstractRealMaskPoint {
        private final int pos;

        public Polygon2DVertex(int pos) {
            super(new double[]{DefaultWritablePolygon2D.this.x.get(pos), DefaultWritablePolygon2D.this.y.get(pos)});
            this.pos = pos;
        }

        @Override
        public void updateBounds() {
            DefaultWritablePolygon2D.this.x.set(this.pos, this.position[0]);
            DefaultWritablePolygon2D.this.y.set(this.pos, this.position[1]);
            DefaultWritablePolygon2D.this.updateMinMax();
        }
    }
}

