/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingLeafRetained;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.CachedTargets;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.GroupRetained;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.J3dDebug;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LinkRetained;
import org.scijava.java3d.MasterControl;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.SharedGroupRetained;
import org.scijava.java3d.SwitchState;
import org.scijava.java3d.Targets;
import org.scijava.java3d.TargetsInterface;
import org.scijava.java3d.UnorderList;
import org.scijava.java3d.UpdateTargets;
import org.scijava.java3d.ViewPlatformRetained;
import org.scijava.java3d.VirtualUniverse;

class SwitchRetained
extends GroupRetained
implements TargetsInterface {
    static final int GEO_NODES = 1;
    static final int ENV_NODES = 2;
    static final int BEHAVIOR_NODES = 4;
    static final int SOUND_NODES = 8;
    static final int BOUNDINGLEAF_NODES = 16;
    int whichChild = -1;
    BitSet childMask = new BitSet();
    BitSet renderChildMask = new BitSet();
    boolean isDirty = true;
    ArrayList<Integer> switchLevels = new ArrayList(1);
    HashKey switchKey = new HashKey();
    int switchIndexCount = 0;
    UpdateTargets updateTargets = null;
    ArrayList<ArrayList<SwitchState>> childrenSwitchStates = null;

    SwitchRetained() {
        this.nodeType = 18;
    }

    synchronized void setWhichChild(int whichChild, boolean updateAlways) {
        this.whichChild = whichChild;
        this.isDirty = true;
        if (this.source != null && this.source.isLive()) {
            this.updateTargets = new UpdateTargets();
            ArrayList<SwitchState> updateList = new ArrayList<SwitchState>(1);
            int nchildren = this.children.size();
            switch (whichChild) {
                case -2: {
                    for (int i = 0; i < nchildren; ++i) {
                        if (this.renderChildMask.get(i) && !updateAlways) continue;
                        this.renderChildMask.set(i);
                        this.updateSwitchChild(i, true, updateList);
                    }
                    break;
                }
                case -1: {
                    for (int i = 0; i < nchildren; ++i) {
                        if (!this.renderChildMask.get(i) && !updateAlways) continue;
                        this.renderChildMask.clear(i);
                        this.updateSwitchChild(i, false, updateList);
                    }
                    break;
                }
                case -3: {
                    for (int i = 0; i < nchildren; ++i) {
                        if (this.childMask.get(i)) {
                            if (this.renderChildMask.get(i) && !updateAlways) continue;
                            this.renderChildMask.set(i);
                            this.updateSwitchChild(i, true, updateList);
                            continue;
                        }
                        if (!this.renderChildMask.get(i) && !updateAlways) continue;
                        this.renderChildMask.clear(i);
                        this.updateSwitchChild(i, false, updateList);
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < nchildren; ++i) {
                        if (i == whichChild) {
                            if (this.renderChildMask.get(i) && !updateAlways) continue;
                            this.renderChildMask.set(i);
                            this.updateSwitchChild(i, true, updateList);
                            continue;
                        }
                        if (!this.renderChildMask.get(i) && !updateAlways) continue;
                        this.renderChildMask.clear(i);
                        this.updateSwitchChild(i, false, updateList);
                    }
                }
            }
            this.sendMessage(updateList);
        }
        this.dirtyBoundsCache();
    }

    int getWhichChild() {
        return this.whichChild;
    }

    final synchronized void setChildMask(BitSet childMask) {
        int i;
        int nbits = childMask.size() > this.childMask.size() ? childMask.size() : this.childMask.size();
        for (i = 0; i < nbits; ++i) {
            if (childMask.get(i)) {
                this.childMask.set(i);
                continue;
            }
            this.childMask.clear(i);
        }
        this.isDirty = true;
        if (this.source != null && this.source.isLive() && this.whichChild == -3) {
            this.updateTargets = new UpdateTargets();
            ArrayList<SwitchState> updateList = new ArrayList<SwitchState>(1);
            int nchildren = this.children.size();
            for (i = 0; i < nchildren; ++i) {
                if (childMask.get(i)) {
                    if (this.renderChildMask.get(i)) continue;
                    this.renderChildMask.set(i);
                    this.updateSwitchChild(i, true, updateList);
                    continue;
                }
                if (!this.renderChildMask.get(i)) continue;
                this.renderChildMask.clear(i);
                this.updateSwitchChild(i, false, updateList);
            }
            this.sendMessage(updateList);
        }
        this.dirtyBoundsCache();
    }

    void sendMessage(ArrayList<SwitchState> updateList) {
        UnorderList vpList;
        int i;
        Object[] nodes;
        int j;
        Object[] nodesArr;
        int size;
        int threads = this.updateTargets.computeSwitchThreads();
        if (threads > 0) {
            J3dMessage m = new J3dMessage();
            m.type = 27;
            m.universe = this.universe;
            m.threads = threads;
            m.args[0] = this.updateTargets;
            m.args[2] = updateList;
            UnorderList blnList = this.updateTargets.targetList[5];
            if (blnList != null) {
                size = blnList.size();
                Object[] boundingLeafUsersArr = new Object[size];
                nodesArr = blnList.toArray(false);
                for (j = 0; j < size; ++j) {
                    Object[] boundingLeafUsers;
                    nodes = (Object[])nodesArr[j];
                    boundingLeafUsersArr[j] = boundingLeafUsers = new Object[nodes.length];
                    for (i = 0; i < nodes.length; ++i) {
                        BoundingLeafRetained mbleaf = (BoundingLeafRetained)nodes[i];
                        boundingLeafUsers[i] = mbleaf.users.toArray();
                    }
                }
                m.args[1] = boundingLeafUsersArr;
            }
            VirtualUniverse.mc.processMessage(m);
        }
        if ((vpList = this.updateTargets.targetList[4]) != null) {
            size = vpList.size();
            nodesArr = vpList.toArray(false);
            for (j = 0; j < size; ++j) {
                nodes = (Object[])nodesArr[j];
                for (i = 0; i < nodes.length; ++i) {
                    ViewPlatformRetained vp = (ViewPlatformRetained)nodes[i];
                    vp.processSwitchChanged();
                }
            }
        }
    }

    final BitSet getChildMask() {
        return (BitSet)this.childMask.clone();
    }

    Node currentChild() {
        if (this.whichChild < 0 || this.whichChild >= this.children.size()) {
            return null;
        }
        return this.getChild(this.whichChild);
    }

    void updateSwitchChild(int child, boolean switchOn, ArrayList<SwitchState> updateList) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                int switchLevel = this.switchLevels.get(i);
                this.traverseSwitchChild(child, this.localToVworldKeys[i], i, this, false, false, switchOn, switchLevel, updateList);
            }
        } else {
            int switchLevel = this.switchLevels.get(0);
            this.traverseSwitchChild(child, null, 0, this, false, false, switchOn, switchLevel, updateList);
        }
    }

    @Override
    void setAuxData(SetLiveState s, int index, int hkIndex) {
        super.setAuxData(s, index, hkIndex);
        this.switchLevels.add(new Integer(s.switchLevels[index]));
        int nchildren = this.children.size();
        for (int i = 0; i < nchildren; ++i) {
            ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(i);
            switchStates.add(hkIndex, new SwitchState(true));
        }
    }

    @Override
    void setNodeData(SetLiveState s) {
        super.setNodeData(s);
        if (!(s.childSwitchLinks == null || this.inSharedGroup && s.childSwitchLinks.contains(this))) {
            s.childSwitchLinks.add(this);
        }
        s.parentSwitchLink = this;
        if (!this.inSharedGroup) {
            this.setAuxData(s, 0, 0);
        } else {
            s.hashkeyIndex = new int[s.keys.length];
            for (int j = 0; j < s.keys.length; ++j) {
                int hkIndex = s.keys[j].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex >= 0) {
                    this.setAuxData(s, j, hkIndex);
                } else {
                    MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
                }
                s.hashkeyIndex[j] = hkIndex;
            }
        }
    }

    @Override
    void setLive(SetLiveState s) {
        boolean switchOn;
        int size;
        SwitchRetained switchRoot;
        int i;
        Targets[] savedSwitchTargets = s.switchTargets;
        ArrayList<SwitchState> savedSwitchStates = s.switchStates;
        SwitchRetained[] savedClosestSwitchParents = s.closestSwitchParents;
        int[] savedClosestSwitchIndices = s.closestSwitchIndices;
        ArrayList<NodeRetained> savedChildSwitchLinks = s.childSwitchLinks;
        GroupRetained savedParentSwitchLink = s.parentSwitchLink;
        int[] savedHashkeyIndex = s.hashkeyIndex;
        s.closestSwitchParents = (SwitchRetained[])savedClosestSwitchParents.clone();
        s.closestSwitchIndices = Arrays.copyOf(savedClosestSwitchIndices, savedClosestSwitchIndices.length);
        for (i = 0; i < s.switchLevels.length; ++i) {
            int n = i;
            s.switchLevels[n] = s.switchLevels[n] + 1;
            s.closestSwitchParents[i] = this;
        }
        super.doSetLive(s);
        this.initRenderChildMask();
        if (this.inSharedGroup) {
            for (i = 0; i < s.keys.length; ++i) {
                int j = s.hashkeyIndex[i];
                if (j >= this.localToVworldKeys.length) continue;
                switchRoot = s.switchLevels[i] == 0 ? this : null;
                size = this.children.size();
                for (int k = 0; k < size; ++k) {
                    switchOn = this.renderChildMask.get(k);
                    this.traverseSwitchChild(k, s.keys[i], j, switchRoot, true, false, switchOn, s.switchLevels[i], null);
                }
            }
        } else {
            switchRoot = s.switchLevels[0] == 0 ? this : null;
            size = this.children.size();
            for (i = 0; i < size; ++i) {
                switchOn = this.renderChildMask.get(i);
                this.traverseSwitchChild(i, null, 0, switchRoot, true, false, switchOn, s.switchLevels[0], null);
            }
        }
        s.switchTargets = savedSwitchTargets;
        s.switchStates = savedSwitchStates;
        s.closestSwitchParents = savedClosestSwitchParents;
        s.closestSwitchIndices = savedClosestSwitchIndices;
        i = 0;
        while (i < s.switchLevels.length) {
            int n = i++;
            s.switchLevels[n] = s.switchLevels[n] - 1;
        }
        s.childSwitchLinks = savedChildSwitchLinks;
        s.parentSwitchLink = savedParentSwitchLink;
        s.hashkeyIndex = savedHashkeyIndex;
        super.markAsLive();
    }

    @Override
    void removeNodeData(SetLiveState s) {
        int numChildren = this.children.size();
        if (this.refCount <= 0) {
            if (this.parentSwitchLink != null) {
                for (int i = 0; i < this.parentSwitchLink.childrenSwitchLinks.size(); ++i) {
                    ArrayList<NodeRetained> switchLinks = this.parentSwitchLink.childrenSwitchLinks.get(i);
                    if (!switchLinks.contains(this)) continue;
                    switchLinks.remove(this);
                    break;
                }
            }
            for (int j = 0; j < numChildren; ++j) {
                ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(j);
                switchStates.clear();
            }
            this.switchLevels.remove(0);
        } else {
            for (int i = s.keys.length - 1; i >= 0; --i) {
                int hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex < 0) continue;
                for (int j = 0; j < numChildren; ++j) {
                    ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(j);
                    switchStates.remove(hkIndex);
                }
                this.switchLevels.remove(hkIndex);
            }
        }
        super.removeNodeData(s);
    }

    @Override
    synchronized void clearLive(SetLiveState s) {
        Targets[] savedSwitchTargets = s.switchTargets;
        s.switchTargets = null;
        super.clearLive(s);
        s.switchTargets = savedSwitchTargets;
    }

    void initRenderChildMask() {
        int nchildren = this.children.size();
        switch (this.whichChild) {
            case -2: {
                for (int i = 0; i < nchildren; ++i) {
                    this.renderChildMask.set(i);
                }
                break;
            }
            case -1: {
                for (int i = 0; i < nchildren; ++i) {
                    this.renderChildMask.clear(i);
                }
                break;
            }
            case -3: {
                for (int i = 0; i < nchildren; ++i) {
                    if (this.childMask.get(i)) {
                        this.renderChildMask.set(i);
                        continue;
                    }
                    this.renderChildMask.clear(i);
                }
                break;
            }
            default: {
                for (int i = 0; i < nchildren; ++i) {
                    if (i == this.whichChild) {
                        this.renderChildMask.set(i);
                        continue;
                    }
                    this.renderChildMask.clear(i);
                }
            }
        }
    }

    void traverseSwitchChild(int child, HashKey key, int index, SwitchRetained switchRoot, boolean init, boolean swChanged, boolean switchOn, int switchLevel, ArrayList<SwitchState> updateList) {
        boolean newSwChanged = false;
        ArrayList<SwitchState> childSwitchStates = this.childrenSwitchStates.get(child);
        SwitchState switchState = childSwitchStates.get(index);
        switchState.updateCompositeSwitchMask(switchLevel, switchOn);
        if (switchRoot != null) {
            if (init) {
                if (!switchState.initialized) {
                    switchState.initSwitchOn();
                }
            } else {
                boolean compositeSwitchOn = switchState.evalCompositeSwitchOn();
                if (switchState.cachedSwitchOn != compositeSwitchOn) {
                    switchState.updateCachedSwitchOn();
                    switchRoot.updateTargets.addCachedTargets(switchState.cachedTargets);
                    newSwChanged = true;
                    updateList.add(switchState);
                }
            }
        }
        ArrayList childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(child);
        int cslSize = childSwitchLinks.size();
        for (int i = 0; i < cslSize; ++i) {
            int j;
            Object obj = childSwitchLinks.get(i);
            if (obj instanceof SwitchRetained) {
                SwitchRetained sw = (SwitchRetained)obj;
                int swSize = sw.children.size();
                for (j = 0; j < swSize; ++j) {
                    sw.traverseSwitchChild(j, key, index, switchRoot, init, newSwChanged, switchOn, switchLevel, updateList);
                }
                continue;
            }
            LinkRetained ln = (LinkRetained)obj;
            if (key == null) {
                this.switchKey.reset();
                this.switchKey.append(this.locale.nodeId);
            } else {
                this.switchKey.set(key);
            }
            this.switchKey.append(LinkRetained.plus).append(ln.nodeId);
            if (ln.sharedGroup == null || ln.sharedGroup.localToVworldKeys == null) continue;
            j = this.switchKey.equals(ln.sharedGroup.localToVworldKeys, 0, ln.sharedGroup.localToVworldKeys.length);
            if (j < 0) {
                System.err.println("SwitchRetained : Can't find hashKey");
            }
            if (j >= ln.sharedGroup.localToVworldKeys.length) continue;
            int lscSize = ln.sharedGroup.children.size();
            for (int k = 0; k < lscSize; ++k) {
                ln.sharedGroup.traverseSwitchChild(k, ln.sharedGroup.localToVworldKeys[j], j, switchRoot, init, newSwChanged, switchOn, switchLevel, updateList);
            }
        }
    }

    void traverseSwitchParent() {
        if (this.inSharedGroup) {
            for (int j = 0; j < this.localToVworldKeys.length; ++j) {
                int switchLevel = this.switchLevels.get(j);
                SwitchRetained switchRoot = switchLevel == 0 ? this : null;
                int size = this.children.size();
                for (int i = 0; i < size; ++i) {
                    boolean switchOn = this.renderChildMask.get(i);
                    this.traverseSwitchChild(i, this.localToVworldKeys[j], j, switchRoot, true, false, switchOn, switchLevel, null);
                }
            }
        } else {
            int switchLevel = this.switchLevels.get(0);
            SwitchRetained switchRoot = switchLevel == 0 ? this : null;
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                boolean switchOn = this.renderChildMask.get(i);
                this.traverseSwitchChild(i, null, 0, switchRoot, true, false, switchOn, switchLevel, null);
            }
        }
        if (this.parentSwitchLink != null) {
            if (this.parentSwitchLink instanceof SwitchRetained) {
                ((SwitchRetained)this.parentSwitchLink).traverseSwitchParent();
            } else if (this.parentSwitchLink instanceof SharedGroupRetained) {
                ((SharedGroupRetained)this.parentSwitchLink).traverseSwitchParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        block16: {
            block13: {
                block14: {
                    NodeRetained child;
                    block17: {
                        block15: {
                            if (!this.boundsAutoCompute) break block13;
                            if (VirtualUniverse.mc.cacheAutoComputedBounds) break block14;
                            if (this.whichChild != -2) break block15;
                            for (int i = 0; i < this.children.size(); ++i) {
                                NodeRetained child2 = (NodeRetained)this.children.get(i);
                                if (child2 == null) continue;
                                child2.computeCombineBounds(bounds);
                            }
                            break block16;
                        }
                        if (this.whichChild != -3) break block17;
                        for (int i = 0; i < this.children.size(); ++i) {
                            NodeRetained child3;
                            if (!this.childMask.get(i) || (child3 = (NodeRetained)this.children.get(i)) == null) continue;
                            child3.computeCombineBounds(bounds);
                        }
                        break block16;
                    }
                    if (this.whichChild == -1 || this.whichChild >= this.children.size() || (child = (NodeRetained)this.children.get(this.whichChild)) == null) break block16;
                    child.computeCombineBounds(bounds);
                    break block16;
                }
                if (!this.validCachedBounds) {
                    NodeRetained child;
                    this.validCachedBounds = true;
                    this.cachedBounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
                    if (this.whichChild == -2) {
                        for (int i = 0; i < this.children.size(); ++i) {
                            NodeRetained child4 = (NodeRetained)this.children.get(i);
                            if (child4 == null) continue;
                            child4.computeCombineBounds(this.cachedBounds);
                        }
                    } else if (this.whichChild == -3) {
                        for (int i = 0; i < this.children.size(); ++i) {
                            NodeRetained child5;
                            if (!this.childMask.get(i) || (child5 = (NodeRetained)this.children.get(i)) == null) continue;
                            child5.computeCombineBounds(this.cachedBounds);
                        }
                    } else if (this.whichChild != -1 && this.whichChild < this.children.size() && (child = (NodeRetained)this.children.get(this.whichChild)) != null) {
                        child.computeCombineBounds(this.cachedBounds);
                    }
                }
                bounds.combine(this.cachedBounds);
                break block16;
            }
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            NodeRetained child;
            if (this.validCachedBounds) {
                return (Bounds)this.cachedBounds.clone();
            }
            Bounds boundingObject = null;
            boundingObject = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
            if (this.whichChild == -2) {
                for (int i = 0; i < this.children.size(); ++i) {
                    NodeRetained child2 = (NodeRetained)this.children.get(i);
                    if (child2 == null) continue;
                    child2.computeCombineBounds(boundingObject);
                }
            } else if (this.whichChild == -3) {
                for (int i = 0; i < this.children.size(); ++i) {
                    NodeRetained child3;
                    if (!this.childMask.get(i) || (child3 = (NodeRetained)this.children.get(i)) == null) continue;
                    child3.computeCombineBounds(boundingObject);
                }
            } else if (this.whichChild != -1 && this.whichChild >= 0 && this.whichChild < this.children.size() && (child = (NodeRetained)this.children.get(this.whichChild)) != null) {
                child.computeCombineBounds(boundingObject);
            }
            return boundingObject;
        }
        return super.getBounds();
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        this.mergeFlag = 0;
        if (J3dDebug.debug) {
            ++compState.numSwitches;
        }
    }

    @Override
    void insertChildrenData(int index) {
        if (this.childrenSwitchStates == null) {
            this.childrenSwitchStates = new ArrayList(1);
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(index, new ArrayList(1));
        ArrayList<SwitchState> switchStates = new ArrayList<SwitchState>(1);
        this.childrenSwitchStates.add(index, switchStates);
        if (this.source != null && this.source.isLive()) {
            for (int i = 0; i < this.localToVworld.length; ++i) {
                switchStates.add(new SwitchState(true));
            }
        }
    }

    @Override
    void appendChildrenData() {
        if (this.childrenSwitchStates == null) {
            this.childrenSwitchStates = new ArrayList(1);
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(new ArrayList(1));
        ArrayList<SwitchState> switchStates = new ArrayList<SwitchState>(1);
        this.childrenSwitchStates.add(switchStates);
        if (this.source != null && this.source.isLive()) {
            for (int i = 0; i < this.localToVworld.length; ++i) {
                switchStates.add(new SwitchState(true));
            }
        }
    }

    @Override
    void removeChildrenData(int index) {
        ArrayList<SwitchState> oldSwitchStates = this.childrenSwitchStates.get(index);
        oldSwitchStates.clear();
        this.childrenSwitchStates.remove(index);
        ArrayList oldSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(index);
        oldSwitchLinks.clear();
        this.childrenSwitchLinks.remove(index);
    }

    @Override
    void childDoSetLive(NodeRetained child, int childIndex, SetLiveState s) {
        int numPaths = this.inSharedGroup ? s.keys.length : 1;
        s.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(childIndex);
        for (int j = 0; j < numPaths; ++j) {
            s.closestSwitchIndices[j] = this.switchIndexCount;
            s.closestSwitchParents[j] = this;
        }
        ++this.switchIndexCount;
        Targets[] newTargets = new Targets[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            newTargets[i] = new Targets();
        }
        s.switchTargets = newTargets;
        s.switchStates = this.childrenSwitchStates.get(childIndex);
        if (child != null) {
            child.setLive(s);
        }
        if (!this.inSharedGroup) {
            CachedTargets cachedTargets = s.switchTargets[0].snapShotInit();
            SwitchState switchState = s.switchStates.get(0);
            switchState.cachedTargets = cachedTargets;
        } else {
            for (int i = 0; i < numPaths; ++i) {
                CachedTargets cachedTargets = s.switchTargets[i].snapShotInit();
                SwitchState switchState = s.switchStates.get(s.hashkeyIndex[i]);
                switchState.cachedTargets = cachedTargets;
            }
        }
    }

    @Override
    TargetsInterface getClosestTargetsInterface(int type) {
        return type == 1 ? this : (TargetsInterface)((Object)this.parentTransformLink);
    }

    @Override
    public CachedTargets getCachedTargets(int type, int index, int child) {
        if (type == 1) {
            ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(child);
            if (index < switchStates.size()) {
                SwitchState switchState = switchStates.get(index);
                return switchState.cachedTargets;
            }
            return null;
        }
        System.err.println("getCachedTargets: wrong arguments");
        return null;
    }

    @Override
    public void resetCachedTargets(int type, CachedTargets[] newCtArr, int child) {
        if (type == 1) {
            ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(child);
            if (newCtArr.length != switchStates.size()) {
                System.err.println("resetCachedTargets: unmatched length!" + newCtArr.length + " " + switchStates.size());
                System.err.println("  resetCachedTargets: " + this);
            }
            for (int i = 0; i < newCtArr.length; ++i) {
                SwitchState switchState = switchStates.get(i);
                switchState.cachedTargets = newCtArr[i];
            }
        } else {
            System.err.println("resetCachedTargets: wrong arguments");
        }
    }

    @Override
    public ArrayList<SwitchState> getTargetsData(int type, int child) {
        if (type == 1) {
            return this.childrenSwitchStates.get(child);
        }
        System.err.println("getTargetsData: wrong arguments");
        return null;
    }

    @Override
    public int getTargetThreads(int type) {
        System.err.println("getTargetsThreads: wrong arguments");
        return -1;
    }

    @Override
    public void updateCachedTargets(int type, CachedTargets[] newCt) {
        System.err.println("updateCachedTarget: wrong arguments");
    }

    @Override
    public void computeTargetThreads(int type, CachedTargets[] newCt) {
        System.err.println("computeTargetThreads: wrong arguments");
    }

    @Override
    public void updateTargetThreads(int type, CachedTargets[] newCt) {
        System.err.println("updateTargetThreads: wrong arguments");
    }

    @Override
    public void propagateTargetThreads(int type, int newTargetThreads) {
        System.err.println("propagateTargetThreads: wrong arguments");
    }

    @Override
    public void copyCachedTargets(int type, CachedTargets[] newCt) {
        System.err.println("copyCachedTarget: wrong arguments");
    }
}

