/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.compute;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.ProcessManager;
import edu.utexas.clm.archipelago.compute.Scheduler;
import edu.utexas.clm.archipelago.network.node.ClusterNode;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ArchipelagoFuture<T>
implements Future<T> {
    private T t;
    private final long id = FijiArchipelago.getUniqueID();
    private final Scheduler scheduler;
    private final AtomicBoolean wasCancelled;
    private final AtomicBoolean done;
    private final AtomicBoolean finished;
    private final Vector<Thread> waitingThreads;
    private final ReentrantLock threadLock;
    private Throwable e;
    private ClusterNode ranOnNode = null;

    public ArchipelagoFuture(Scheduler scheduler) {
        this(scheduler, null);
    }

    public ArchipelagoFuture(Scheduler s, T inData) {
        this.t = inData;
        this.scheduler = s;
        this.waitingThreads = new Vector();
        this.wasCancelled = new AtomicBoolean(false);
        this.done = new AtomicBoolean(false);
        this.finished = new AtomicBoolean(false);
        this.threadLock = new ReentrantLock();
    }

    public long getID() {
        return this.id;
    }

    public boolean finish(Throwable exception) {
        this.threadLock.lock();
        if (!this.finished.getAndSet(true)) {
            this.e = exception;
            this.done.set(true);
            this.smoochThreads();
            this.threadLock.unlock();
            return true;
        }
        this.threadLock.unlock();
        return false;
    }

    public boolean finish(ProcessManager<?> pm) throws ClassCastException {
        this.threadLock.lock();
        if (!this.finished.getAndSet(true)) {
            FijiArchipelago.debug("Future " + this.id + ": finishing future ");
            if (pm != null) {
                Object o = pm.getOutput();
                Object result = o;
                if (result != null) {
                    this.t = result;
                }
                this.ranOnNode = this.scheduler.getNode(pm);
                this.e = pm.getRemoteException();
                this.done.set(true);
                FijiArchipelago.debug("Future " + this.id + ": finished ok. smooching threads");
                this.smoochThreads();
            } else {
                FijiArchipelago.debug("Future " + this.id + ": given null pm");
                this.t = null;
            }
            this.threadLock.unlock();
            return true;
        }
        FijiArchipelago.debug("Future " + this.id + ": already finished");
        this.threadLock.unlock();
        return false;
    }

    private synchronized void smoochThreads() {
        assert (this.threadLock.isLocked());
        for (Thread t : this.waitingThreads) {
            t.interrupt();
        }
    }

    @Override
    public synchronized boolean cancel(boolean b) {
        this.threadLock.lock();
        if (this.done.get()) {
            FijiArchipelago.debug("Job " + this.getID() + ": Cancel called, but job is already done");
            this.threadLock.unlock();
            return false;
        }
        FijiArchipelago.debug("Job " + this.getID() + ": Cancel called.");
        boolean cancelled = this.scheduler.cancelJob(this.id, b);
        this.done.set(cancelled);
        if (cancelled) {
            FijiArchipelago.debug("Job " + this.getID() + " cancel SUCCESS");
            this.finished.set(true);
            this.smoochThreads();
        } else {
            FijiArchipelago.debug("Job " + this.getID() + " was NOT CANCELLED");
        }
        this.wasCancelled.set(cancelled);
        this.threadLock.unlock();
        return cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.wasCancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new ExecutionException(te);
        }
    }

    private void removeWaitingThread(Thread t) {
        this.threadLock.lock();
        this.waitingThreads.remove(t);
        this.threadLock.unlock();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        FijiArchipelago.debug("Future: " + this.getID() + " get() called, acquiring lock...");
        this.threadLock.lock();
        if (!this.done.get()) {
            Thread currThread = Thread.currentThread();
            FijiArchipelago.debug("Future: " + this.getID() + " not done, adding Thread to queue");
            this.waitingThreads.add(currThread);
            this.threadLock.unlock();
            try {
                FijiArchipelago.debug("Future: " + this.getID() + " sleeping...");
                Thread.sleep(timeUnit.convert(l, TimeUnit.MILLISECONDS));
                FijiArchipelago.debug("Future: " + this.getID() + " timed out");
                this.removeWaitingThread(currThread);
                throw new TimeoutException();
            }
            catch (InterruptedException ie) {
                FijiArchipelago.debug("Future: " + this.getID() + " woken up");
                this.removeWaitingThread(currThread);
                if (!this.done.get()) {
                    throw ie;
                }
            }
        } else {
            this.threadLock.unlock();
        }
        if (this.e != null) {
            throw new ExecutionException("On host " + (this.ranOnNode == null ? "null" : this.ranOnNode.getHost()), this.e);
        }
        return this.t;
    }
}

