/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sc.fiji.kappa.curve.BezierGroup;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.Chart;
import sc.fiji.kappa.gui.KappaFrame;
import sc.fiji.kappa.gui.Panel;
import sc.fiji.kappa.gui.PanelGroup;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_OFFSET_RADIUS = 10;
    private int offsetRadius = 10;
    static final String[] DEFAULT_TITLES = new String[]{"Selected Curve: ", "Avg. Curvature: ", "Curve Length (~): ", "Curvature \u03c3\u00b2", "Point Curvature: "};
    static final String[] DEFAULT_VALUES = new String[]{"NO CURVES SELECTED", "", "", "", "", ""};
    static final String[] MULT_SELECTED_TITLES = new String[]{"Selected Curves: ", "Avg. Mean Curvature: ", "Avg. Curve Length (~)", "\u03c3\u00b2 of Avg. Curvatures: ", "Avg. Point Curvature: "};
    static final int NO_STATS = DEFAULT_TITLES.length;
    private JLabel pointLabel;
    private JLabel[] statLabels;
    private JLabel[] valueLabels;
    private JLabel[] unitLabels;
    static final int[] TITLE_X = new int[]{10, 10, 10, 10, 10};
    static final int[] TITLE_Y = new int[]{25, 59, 76, 93, 110};
    static final int[] VALUE_X = new int[]{10, 135, 135, 135, 135};
    static final int[] VALUE_Y = new int[]{42, 59, 76, 93, 110};
    static final String[] UNIT_LABELS = new String[]{"", "\u00b5m\u207b\u00b9", "\u00b5m", "\u00b5m\u207b\u00b9", "\u00b5m\u207b\u00b9"};
    static final Rectangle POINT_SLIDER_BOUNDS = new Rectangle(8, 153, 209, 25);
    static final Rectangle POINT_LABEL_BOUNDS = new Rectangle(10, 133, 205, 25);
    static final Rectangle CONVERSION_FIELD_BOUNDS = new Rectangle(110, 180, 105, 20);
    static final Rectangle CONVERSION_LABEL_BOUNDS = new Rectangle(10, 177, 100, 25);
    static final Rectangle INPUT_OPTION_LABEL_BOUNDS = new Rectangle(10, 25, 200, 25);
    static final Rectangle CURVE_COMBO_BOX_BOUNDS = new Rectangle(122, 27, 100, 20);
    static final Rectangle BSPLINE_OPTION_LABEL_BOUNDS = new Rectangle(10, 47, 200, 25);
    static final Rectangle BSPLINE_COMBO_BOX_BOUNDS = new Rectangle(122, 50, 100, 20);
    static final Rectangle STROKE_THICKNESS_LABEL_BOUNDS = new Rectangle(10, 69, 200, 25);
    static final Rectangle STROKE_THICKNESS_SPINNER_BOUNDS = new Rectangle(122, 72, 100, 20);
    static final Rectangle THRESHOLD_CHANNEL_LABEL_BOUNDS = new Rectangle(10, 25, 200, 25);
    static final Rectangle THRESHOLD_CHANNEL_COMBO_BOX_BOUNDS = new Rectangle(10, 50, 200, 20);
    static final Rectangle THRESHOLD_SLIDER_BOUNDS = new Rectangle(8, 93, 209, 25);
    static final Rectangle THRESHOLD_LABEL_BOUNDS = new Rectangle(10, 70, 200, 25);
    static final Rectangle AVERAGING_SPINNER_BOUNDS = new Rectangle(174, 118, 36, 17);
    static final Rectangle AVERAGING_LABEL_BOUNDS = new Rectangle(10, 115, 200, 25);
    static final Rectangle SHOW_THRESHOLDING_BOUNDS = new Rectangle(10, 133, 200, 25);
    static final Rectangle BG_CHECKBOX_BOUNDS = new Rectangle(192, 133, 25, 25);
    static final Rectangle APPLY_BUTTON_BOUNDS = new Rectangle(10, 162, 120, 20);
    static final Rectangle REVERT_BUTTON_BOUNDS = new Rectangle(140, 162, 70, 20);
    static final Rectangle FITTING_CHANNEL_LABEL_BOUNDS = new Rectangle(10, 25, 200, 25);
    static final Rectangle FITTING_LABEL_BOUNDS = new Rectangle(10, 70, 200, 25);
    static final Rectangle DATA_RADIUS_LABEL_BOUNDS = new Rectangle(10, 165, 200, 25);
    static final Rectangle SHOW_DATA_THRESHOLD_LABEL_BOUNDS = new Rectangle(10, 183, 200, 25);
    static final Rectangle SHOW_DATA_POINTS_LABEL_BOUNDS = new Rectangle(10, 201, 200, 25);
    static final Rectangle THRESHOLD_RADIUS_SPINNER_BOUNDS = new Rectangle(169, 165, 45, 23);
    static final Rectangle SHOW_RADIUS_CHECKBOX_BOUNDS = new Rectangle(192, 185, 25, 25);
    static final Rectangle SHOW_DATAPOINTS_CHECKBOX_BOUNDS = new Rectangle(192, 202, 25, 25);
    static final Rectangle GLOBAL_ERROR_LABEL_BOUNDS = new Rectangle(10, 225, 145, 25);
    static final Rectangle GLOBAL_ERROR_SPINNER_BOUNDS = new Rectangle(155, 225, 50, 25);
    static final Rectangle LOCAL_ERROR_LABEL_BOUNDS = new Rectangle(10, 253, 145, 25);
    static final Rectangle LOCAL_ERROR_SPINNER_BOUNDS = new Rectangle(155, 253, 50, 25);
    public static final String[] FITTING_CHANNELS = new String[]{"The Red Channel", "The Green Channel", "The Blue Channel", "All Channels"};
    public static final String[] DATA_RANGE_OPTIONS = new String[]{"Brighter", "Darker"};
    static final Rectangle FITTING_CHANNEL_COMBO_BOX_BOUNDS = new Rectangle(10, 50, 200, 20);
    static final Rectangle FITTING_COMBO_BOX_BOUNDS = new Rectangle(10, 95, 200, 20);
    public static final Rectangle DATA_RANGE_COMBO_BOX_BOUNDS = new Rectangle(96, 121, 80, 18);
    public static final Rectangle CHOOSE_RANGE_BOUNDS_1 = new Rectangle(10, 121, 100, 20);
    public static final Rectangle CHOOSE_RANGE_BOUNDS_2 = new Rectangle(183, 121, 50, 20);
    public static final Rectangle DATA_THRESHOLD_SLIDER_BOUNDS = new Rectangle(7, 143, 150, 25);
    public static final Rectangle DATA_THRESHOLD_LABEL_BOUNDS = new Rectangle(160, 142, 60, 25);
    public static final int DEFAULT_DATA_THRESHOLD = 128;
    private PanelGroup panels;
    private Chart curvatureChart;
    private Chart debugCurvatureChart;
    private Chart intensityChartRed;
    private Chart intensityChartGreen;
    private Chart intensityChartBlue;
    private Panel curvaturePanel;
    private Panel intensityPanel;
    private JList<String> list;
    private Vector<String> listData;
    private JTextField nameField;
    private JScrollPane curvesList;
    private JTextField conversionField;
    private JComboBox<String> dataRangeComboBox;
    private JComboBox<String> fittingChannelsComboBox;
    private JCheckBox bgCheckBox;
    private JComboBox<String> curveComboBox;
    private JComboBox<String> bsplineComboBox;
    private JComboBox<String> fittingComboBox;
    private JComboBox<String> thresholdChannelsComboBox;
    private JCheckBox showRadiusCheckBox;
    private JCheckBox showDatapointsCheckBox;
    private JSpinner rangeAveragingSpinner;
    private JSpinner thresholdRadiusSpinner;
    private JButton apply;
    private JButton revert;
    private JLabel bgThresholdLabel;
    private JLabel bsplineOptionLabel;
    private JLabel dataThresholdLabel;
    private JSlider dataThresholdSlider;
    private JSlider pointSlider;
    private JSlider thresholdSlider;
    private KappaFrame frame;

    public InfoPanel(final KappaFrame frame) {
        this.frame = frame;
        this.panels = new PanelGroup();
        this.addMouseListener(new MouseHandler());
        this.setLayout(null);
        this.setBackground(KappaFrame.PANEL_COLOR);
        this.setPreferredSize(new Dimension(225, 0));
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setListData(new Vector<String>());
        this.setList(new JList<String>(this.getListData()));
        this.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getSource() == InfoPanel.this.getList() && !event.getValueIsAdjusting()) {
                    int[] selectedIndices = InfoPanel.this.getList().getSelectedIndices();
                    if (selectedIndices.length == 0) {
                        frame.getCurves().setAllUnselected();
                        InfoPanel.this.updateHistograms();
                        frame.getKappaMenubar().getDelete().setEnabled(false);
                        InfoPanel.this.panels.hide("Curvature Distribution (absolute values)");
                        InfoPanel.this.panels.hide("Intensity Distribution");
                    } else {
                        frame.getCurves().setSelected(selectedIndices);
                        frame.getKappaMenubar().getDelete().setEnabled(true);
                        if (selectedIndices.length == 1) {
                            InfoPanel.this.updateHistograms();
                            InfoPanel.this.panels.show("Curvature Distribution (absolute values)");
                            InfoPanel.this.panels.show("Intensity Distribution");
                        }
                    }
                    frame.drawImageOverlay();
                    InfoPanel.this.getPointSlider().setEnabled(frame.getCurves().isCurveSelected());
                    if (!frame.getCurves().isCurveSelected()) {
                        InfoPanel.this.getPointSlider().setValue(1);
                    }
                    InfoPanel.this.repaint();
                    frame.getControlPanel().repaint();
                }
            }
        });
        this.setCurvesList(new JScrollPane(this.getList()));
        this.getCurvesList().setBounds(0, 22, 223, 75);
        this.getCurvesList().setVerticalScrollBarPolicy(22);
        this.add(this.getCurvesList());
        Panel curvesListPanel = new Panel(0, 0, 95, "CURVES");
        curvesListPanel.setExpanded(false);
        this.panels.addPanel(curvesListPanel);
        curvesListPanel.addComponent(this.getCurvesList());
        this.setPointSlider(new JSlider(0, 0, frame.getNumberOfPointsPerCurve(), 0));
        this.getPointSlider().addChangeListener(new PointChanger());
        this.getPointSlider().setBounds(POINT_SLIDER_BOUNDS);
        this.getPointSlider().setEnabled(false);
        this.pointLabel = new JLabel("Point " + frame.formatNumber(this.getPointSlider().getValue(), 4) + " / " + frame.getNumberOfPointsPerCurve());
        this.pointLabel.setFont(this.pointLabel.getFont().deriveFont(0));
        this.pointLabel.setForeground(Color.GRAY);
        this.pointLabel.setPreferredSize(new Dimension(65, Short.MAX_VALUE));
        this.pointLabel.setAlignmentX(0.0f);
        this.pointLabel.setBounds(POINT_LABEL_BOUNDS);
        this.setConversionField(new JTextField(5));
        this.getConversionField().setText(Double.toString(0.16));
        this.getConversionField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if ((c < '0' || c > '9') && c != '.' && c != '\n' && c != '\b') {
                    e.consume();
                }
                if (c == '\n') {
                    InfoPanel.this.updateConversionField(InfoPanel.this.getConversionField().getText());
                }
            }
        });
        this.getConversionField().setBounds(CONVERSION_FIELD_BOUNDS);
        Panel inputOptionsPanel = new Panel(100, "CURVE INPUT OPTIONS");
        this.panels.addPanel(inputOptionsPanel);
        this.addLabelComponent("Curve Input Type: ", inputOptionsPanel, INPUT_OPTION_LABEL_BOUNDS);
        this.setCurveComboBox(new JComboBox<String>(KappaFrame.CURVE_TYPES));
        this.getCurveComboBox().setSelectedIndex(1);
        frame.setInputType(this.getCurveComboBox().getSelectedIndex());
        this.getCurveComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setInputType(InfoPanel.this.getCurveComboBox().getSelectedIndex());
                InfoPanel.this.getBsplineComboBox().setEnabled(frame.getInputType() == 1);
                InfoPanel.this.getBsplineOptionLabel().setEnabled(frame.getInputType() == 1);
                if (frame.getCurrCtrlPt() == 3) {
                    frame.getKappaMenubar().getEnter().setEnabled(frame.getInputType() == 0);
                }
                frame.getScrollPane().requestFocusInWindow();
            }
        });
        this.getCurveComboBox().setBounds(CURVE_COMBO_BOX_BOUNDS);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.getCurveComboBox().setSize(this.getCurveComboBox().getWidth(), 22);
        }
        this.add(this.getCurveComboBox());
        inputOptionsPanel.addComponent(this.getCurveComboBox());
        this.setBsplineOptionLabel(new JLabel("B-Spline Type: "));
        this.getBsplineOptionLabel().setBounds(BSPLINE_OPTION_LABEL_BOUNDS);
        this.getBsplineOptionLabel().setFont(this.getBsplineOptionLabel().getFont().deriveFont(0));
        this.getBsplineOptionLabel().setEnabled(frame.getInputType() == 1);
        this.add(this.getBsplineOptionLabel());
        inputOptionsPanel.addComponent(this.getBsplineOptionLabel());
        this.setBsplineComboBox(new JComboBox<String>(KappaFrame.BSPLINE_TYPES));
        this.getBsplineComboBox().setSelectedIndex(0);
        this.getBsplineComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setBsplineType(InfoPanel.this.getBsplineComboBox().getSelectedIndex());
                frame.getScrollPane().requestFocusInWindow();
                frame.drawImageOverlay();
            }
        });
        this.getBsplineComboBox().setEnabled(frame.getInputType() == 1);
        this.getBsplineComboBox().setBounds(BSPLINE_COMBO_BOX_BOUNDS);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.getBsplineComboBox().setSize(this.getBsplineComboBox().getWidth(), 22);
        }
        this.add(this.getBsplineComboBox());
        inputOptionsPanel.addComponent(this.getBsplineComboBox());
        this.addLabelComponent("Stroke Thickness: ", inputOptionsPanel, STROKE_THICKNESS_LABEL_BOUNDS);
        final JSpinner strokeThicknessSpinner = new JSpinner(new SpinnerNumberModel(frame.getBaseStrokeThickness(), 0.1, 10.0, 1.0));
        strokeThicknessSpinner.setBounds(STROKE_THICKNESS_SPINNER_BOUNDS);
        strokeThicknessSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent c) {
                frame.setBaseStrokeThickness((Double)strokeThicknessSpinner.getValue());
                frame.drawImageOverlay();
            }
        });
        this.add(strokeThicknessSpinner);
        inputOptionsPanel.addComponent(strokeThicknessSpinner);
        Panel statisticsPanel = new Panel(210, "DATA AND STATISTICS");
        this.panels.addPanel(statisticsPanel);
        this.addLabelComponent("Scale (\u03bcm/pixel):", statisticsPanel, CONVERSION_LABEL_BOUNDS);
        this.add(this.pointLabel);
        this.add(this.getPointSlider());
        this.add(this.getConversionField());
        statisticsPanel.addComponent(this.getPointSlider());
        statisticsPanel.addComponent(this.pointLabel);
        statisticsPanel.addComponent(this.getConversionField());
        this.statLabels = new JLabel[NO_STATS];
        this.valueLabels = new JLabel[NO_STATS];
        this.unitLabels = new JLabel[NO_STATS];
        for (int i = 0; i < NO_STATS; ++i) {
            this.statLabels[i] = new JLabel(DEFAULT_TITLES[i]);
            this.statLabels[i].setBounds(TITLE_X[i], TITLE_Y[i], 200, 25);
            this.statLabels[i].setFont(this.statLabels[i].getFont().deriveFont(0));
            this.add(this.statLabels[i]);
            statisticsPanel.addComponent(this.statLabels[i]);
            this.valueLabels[i] = new JLabel(DEFAULT_VALUES[i]);
            this.valueLabels[i].setBounds(VALUE_X[i], VALUE_Y[i], 200, 25);
            this.valueLabels[i].setFont(this.valueLabels[i].getFont().deriveFont(0));
            this.valueLabels[i].setForeground(Color.GRAY);
            this.add(this.valueLabels[i]);
            statisticsPanel.addComponent(this.valueLabels[i]);
            this.unitLabels[i] = new JLabel(UNIT_LABELS[i]);
            this.unitLabels[i].setBounds(VALUE_X[i] + 57, VALUE_Y[i], 50, 25);
            this.unitLabels[i].setFont(new Font("Sans Serif", 0, 11));
            this.unitLabels[i].setForeground(Color.LIGHT_GRAY);
            this.add(this.unitLabels[i]);
            statisticsPanel.addComponent(this.unitLabels[i]);
        }
        Panel curveFittingPanel = new Panel(280, "CURVE FITTING OPTIONS");
        this.panels.addPanel(curveFittingPanel);
        this.addLabelComponent("Fit Points Using: ", curveFittingPanel, FITTING_CHANNEL_LABEL_BOUNDS);
        this.addLabelComponent("Data Fitting Algorithm: ", curveFittingPanel, FITTING_LABEL_BOUNDS);
        this.addLabelComponent("Data Threshold Radius: ", curveFittingPanel, DATA_RADIUS_LABEL_BOUNDS);
        this.addLabelComponent("Show Thresholded Region: ", curveFittingPanel, SHOW_DATA_THRESHOLD_LABEL_BOUNDS);
        this.addLabelComponent("Show Data Points: ", curveFittingPanel, SHOW_DATA_POINTS_LABEL_BOUNDS);
        this.addLabelComponent("Choose points", curveFittingPanel, CHOOSE_RANGE_BOUNDS_1);
        this.addLabelComponent("than:", curveFittingPanel, CHOOSE_RANGE_BOUNDS_2);
        this.addLabelComponent("Global Error Threshold: ", curveFittingPanel, GLOBAL_ERROR_LABEL_BOUNDS);
        this.addLabelComponent("Local Error Threshold: ", curveFittingPanel, LOCAL_ERROR_LABEL_BOUNDS);
        this.setDataThresholdSlider(new JSlider(0, 0, 256, 128));
        this.getDataThresholdSlider().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent c) {
                if (frame.isImageRGBColor()) {
                    InfoPanel.this.getDataThresholdLabel().setText(InfoPanel.this.getDataThresholdSlider().getValue() + " / 256");
                } else {
                    InfoPanel.this.getDataThresholdLabel().setText(InfoPanel.this.getDataThresholdSlider().getValue() + " / " + (int)Math.pow(2.0, frame.getDisplayedImageStack().getBitDepth()));
                }
                for (Curve curve : frame.getCurves()) {
                    curve.evaluateThresholdedPixels();
                }
                frame.drawImageOverlay();
            }
        });
        this.getDataThresholdSlider().setBounds(DATA_THRESHOLD_SLIDER_BOUNDS);
        this.add(this.getDataThresholdSlider());
        curveFittingPanel.addComponent(this.getDataThresholdSlider());
        this.setDataThresholdLabel(new JLabel("128 / 256"));
        this.getDataThresholdLabel().setBounds(DATA_THRESHOLD_LABEL_BOUNDS);
        this.getDataThresholdLabel().setForeground(Color.GRAY);
        this.getDataThresholdLabel().setFont(this.getDataThresholdLabel().getFont().deriveFont(0));
        this.add(this.getDataThresholdLabel());
        curveFittingPanel.addComponent(this.getDataThresholdLabel());
        this.setFittingChannelsComboBox(new JComboBox<String>(FITTING_CHANNELS));
        this.getFittingChannelsComboBox().setSelectedIndex(3);
        this.getFittingChannelsComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Curve c : frame.getCurves()) {
                    c.evaluateThresholdedPixels();
                }
                frame.drawImageOverlay();
            }
        });
        this.getFittingChannelsComboBox().setBounds(FITTING_CHANNEL_COMBO_BOX_BOUNDS);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.getFittingChannelsComboBox().setSize(this.getFittingChannelsComboBox().getWidth(), 22);
        }
        this.add(this.getFittingChannelsComboBox());
        curveFittingPanel.addComponent(this.getFittingChannelsComboBox());
        this.setFittingComboBox(new JComboBox<String>(KappaFrame.FITTING_ALGORITHMS));
        this.getFittingComboBox().setSelectedIndex(0);
        this.getFittingComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setFittingAlgorithm(KappaFrame.FITTING_ALGORITHMS[InfoPanel.this.getFittingComboBox().getSelectedIndex()]);
                frame.getScrollPane().requestFocusInWindow();
            }
        });
        this.getFittingComboBox().setBounds(FITTING_COMBO_BOX_BOUNDS);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.getFittingComboBox().setSize(this.getFittingComboBox().getWidth(), 22);
        }
        this.add(this.getFittingComboBox());
        curveFittingPanel.addComponent(this.getFittingComboBox());
        this.setDataRangeComboBox(new JComboBox<String>(DATA_RANGE_OPTIONS));
        this.getDataRangeComboBox().setSelectedIndex(0);
        this.getDataRangeComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Curve c : frame.getCurves()) {
                    c.evaluateThresholdedPixels();
                }
                frame.drawImageOverlay();
            }
        });
        this.getDataRangeComboBox().setBounds(DATA_RANGE_COMBO_BOX_BOUNDS);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.getDataRangeComboBox().setSize(this.getDataRangeComboBox().getWidth(), 22);
        }
        this.add(this.getDataRangeComboBox());
        curveFittingPanel.addComponent(this.getDataRangeComboBox());
        this.setThresholdRadiusSpinner(new JSpinner(new SpinnerNumberModel(5, 1, 200, 1)));
        this.getThresholdRadiusSpinner().setBounds(THRESHOLD_RADIUS_SPINNER_BOUNDS);
        this.getThresholdRadiusSpinner().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent c) {
                for (Curve curve : frame.getCurves()) {
                    curve.setDataRadius((Integer)InfoPanel.this.getThresholdRadiusSpinner().getValue());
                }
                frame.drawImageOverlay();
            }
        });
        this.add(this.getThresholdRadiusSpinner());
        curveFittingPanel.addComponent(this.getThresholdRadiusSpinner());
        final JSpinner globalErrorSpinner = new JSpinner(new SpinnerNumberModel(frame.getGlobalThreshold(), 0.0, 1.0, 0.01));
        globalErrorSpinner.setBounds(GLOBAL_ERROR_SPINNER_BOUNDS);
        globalErrorSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent c) {
                frame.setGlobalThreshold((Double)globalErrorSpinner.getValue());
            }
        });
        this.add(globalErrorSpinner);
        curveFittingPanel.addComponent(globalErrorSpinner);
        final JSpinner localErrorSpinner = new JSpinner(new SpinnerNumberModel(frame.getLocalThreshold(), 0.0, 1.0, 0.01));
        localErrorSpinner.setBounds(LOCAL_ERROR_SPINNER_BOUNDS);
        localErrorSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent c) {
                frame.setLocalThreshold((Double)localErrorSpinner.getValue());
            }
        });
        this.add(localErrorSpinner);
        curveFittingPanel.addComponent(localErrorSpinner);
        this.setShowRadiusCheckBox(new JCheckBox());
        this.getShowRadiusCheckBox().setBounds(SHOW_RADIUS_CHECKBOX_BOUNDS);
        this.getShowRadiusCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.drawImageOverlay();
            }
        });
        this.add(this.getShowRadiusCheckBox());
        curveFittingPanel.addComponent(this.getShowRadiusCheckBox());
        this.setShowDatapointsCheckBox(new JCheckBox());
        this.getShowDatapointsCheckBox().setBounds(SHOW_DATAPOINTS_CHECKBOX_BOUNDS);
        this.getShowDatapointsCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.drawImageOverlay();
            }
        });
        this.add(this.getShowDatapointsCheckBox());
        curveFittingPanel.addComponent(this.getShowDatapointsCheckBox());
        Panel thresholdingPanel = new Panel(190, "BACKGROUND PARAMETERS");
        thresholdingPanel.setExpanded(false);
        this.panels.addPanel(thresholdingPanel);
        this.addLabelComponent("Evaluate Background Pixels Using: ", thresholdingPanel, THRESHOLD_CHANNEL_LABEL_BOUNDS);
        this.setThresholdChannelsComboBox(new JComboBox<String>(FITTING_CHANNELS));
        this.getThresholdChannelsComboBox().setSelectedIndex(0);
        this.getThresholdChannelsComboBox().setBounds(THRESHOLD_CHANNEL_COMBO_BOX_BOUNDS);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.getThresholdChannelsComboBox().setSize(this.getThresholdChannelsComboBox().getWidth(), 22);
        }
        this.add(this.getThresholdChannelsComboBox());
        thresholdingPanel.addComponent(this.getThresholdChannelsComboBox());
        this.setBgThresholdLabel(new JLabel("Background Threshold: 36 / 256"));
        this.getBgThresholdLabel().setBounds(THRESHOLD_LABEL_BOUNDS);
        this.getBgThresholdLabel().setFont(this.getBgThresholdLabel().getFont().deriveFont(0));
        this.add(this.getBgThresholdLabel());
        thresholdingPanel.addComponent(this.getBgThresholdLabel());
        this.setThresholdSlider(new JSlider(0, 0, 256, 36));
        this.getThresholdSlider().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent c) {
                InfoPanel.this.getBgThresholdLabel().setText("Background Threshold: " + InfoPanel.this.getThresholdSlider().getValue() + "/256");
            }
        });
        this.getThresholdSlider().setBounds(THRESHOLD_SLIDER_BOUNDS);
        this.add(this.getThresholdSlider());
        thresholdingPanel.addComponent(this.getThresholdSlider());
        this.addLabelComponent("Pixel Range for Averaging:", thresholdingPanel, AVERAGING_LABEL_BOUNDS);
        this.addLabelComponent("Show Thresholded Region:", thresholdingPanel, SHOW_THRESHOLDING_BOUNDS);
        this.setRangeAveragingSpinner(new JSpinner(new SpinnerNumberModel(3, 0, 6, 1)));
        this.getRangeAveragingSpinner().setBounds(AVERAGING_SPINNER_BOUNDS);
        this.add(this.getRangeAveragingSpinner());
        thresholdingPanel.addComponent(this.getRangeAveragingSpinner());
        this.setBgCheckBox(new JCheckBox());
        this.getBgCheckBox().setBounds(BG_CHECKBOX_BOUNDS);
        this.add(this.getBgCheckBox());
        thresholdingPanel.addComponent(this.getBgCheckBox());
        this.setApply(new JButton("Apply Changes"));
        this.getApply().setFont(this.getApply().getFont().deriveFont(0));
        this.setRevert(new JButton("Reset"));
        this.getRevert().setFont(this.getRevert().getFont().deriveFont(0));
        this.getApply().setBounds(APPLY_BUTTON_BOUNDS);
        this.getRevert().setBounds(REVERT_BUTTON_BOUNDS);
        this.getThresholdChannelsComboBox().setEnabled(false);
        this.getThresholdSlider().setEnabled(false);
        this.getRangeAveragingSpinner().setEnabled(false);
        this.getBgCheckBox().setEnabled(false);
        this.getApply().setEnabled(false);
        this.getRevert().setEnabled(false);
        this.add(this.getApply());
        this.add(this.getRevert());
        thresholdingPanel.addComponent(this.getApply());
        thresholdingPanel.addComponent(this.getRevert());
        this.getApply().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.updateThresholded();
            }
        });
        this.getRevert().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoPanel.this.getThresholdSlider().setValue(36);
                InfoPanel.this.getBgCheckBox().setSelected(false);
                InfoPanel.this.getRangeAveragingSpinner().setValue(3);
                frame.setScaledImage((double)frame.getControlPanel().getScaleSlider().getValue() / 100.0);
                frame.drawImageOverlay();
            }
        });
        this.curvaturePanel = new Panel(110, "Curvature Distribution (absolute values)");
        this.curvatureChart = new Chart(new ArrayList<Point2D>());
        this.curvaturePanel.addComponent(this.curvatureChart);
        this.panels.addPanel(this.curvaturePanel);
        this.intensityChartRed = new Chart(new ArrayList<Point2D>());
        this.intensityChartGreen = new Chart(new ArrayList<Point2D>());
        this.intensityChartBlue = new Chart(new ArrayList<Point2D>());
        this.intensityChartRed.setMaxY(256.0);
        this.intensityChartGreen.setMaxY(256.0);
        this.intensityChartBlue.setMaxY(256.0);
        this.intensityPanel = new Panel(110, "Intensity Distribution");
        this.intensityPanel.addComponent(this.intensityChartRed);
        this.intensityPanel.addComponent(this.intensityChartGreen);
        this.intensityPanel.addComponent(this.intensityChartBlue);
        this.panels.addPanel(this.intensityPanel);
        this.panels.hide("Curvature Distribution (absolute values)");
        this.panels.hide("Intensity Distribution");
    }

    public void updateHistograms() {
        if (this.frame.getCurves().getNoSelected() == 0) {
            return;
        }
        Curve currEditedCurve = this.frame.getCurves().getSelected()[0];
        currEditedCurve.updateIntensities();
        List<Point2D> redIntensities = currEditedCurve.getIntensityDataRed();
        List<Point2D> greenIntensities = currEditedCurve.getIntensityDataGreen();
        List<Point2D> blueIntensities = currEditedCurve.getIntensityDataBlue();
        double maxRedValue = redIntensities.stream().map(u -> u.getY()).max(Double::compareTo).get();
        double maxGreenValue = greenIntensities.stream().map(u -> u.getY()).max(Double::compareTo).get();
        double maxBlueValue = blueIntensities.stream().map(u -> u.getY()).max(Double::compareTo).get();
        double maxValue = Math.max(maxRedValue, maxGreenValue);
        maxValue = Math.max(maxValue, maxBlueValue);
        this.intensityChartRed.setMaxY(maxValue);
        this.intensityChartGreen.setMaxY(maxValue);
        this.intensityChartBlue.setMaxY(maxValue);
        this.curvatureChart.setData(currEditedCurve.getCurveData());
        this.intensityChartRed.setData(redIntensities);
        this.intensityChartGreen.setData(greenIntensities);
        this.intensityChartBlue.setData(blueIntensities);
        this.frame.getInfoPanel().repaint();
    }

    protected void setHistogramVisibility(boolean showRed, boolean showGreen, boolean showBlue) {
        if (!this.intensityPanel.isExpanded()) {
            return;
        }
        this.intensityChartRed.setVisible(showRed);
        this.intensityChartGreen.setVisible(showGreen);
        this.intensityChartBlue.setVisible(showBlue);
        this.updateHistograms();
    }

    private void addLabelComponent(String labelText, Panel panel, Rectangle bounds) {
        JLabel label = new JLabel(labelText);
        label.setBounds(bounds);
        label.setFont(label.getFont().deriveFont(0));
        this.add(label);
        panel.addComponent(label);
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        BezierGroup curves = this.frame.getCurves();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.panels.draw(g);
        g.setColor(Color.BLACK);
        if (curves.getNoSelected() <= 1) {
            for (i = 0; i < NO_STATS; ++i) {
                this.statLabels[i].setText(DEFAULT_TITLES[i]);
            }
        } else {
            for (i = 0; i < NO_STATS; ++i) {
                this.statLabels[i].setText(MULT_SELECTED_TITLES[i]);
            }
        }
        g.setColor(Color.GRAY);
        if (!curves.isCurveSelected()) {
            for (i = 0; i < NO_STATS; ++i) {
                this.valueLabels[i].setText(DEFAULT_VALUES[i]);
            }
        } else if (curves.getNoSelected() == 1) {
            Curve currentCurve = curves.getSelected()[0];
            String[] values = new String[]{currentCurve.getName(), String.format("%8f", currentCurve.getAverageCurvature()), String.format("%5.4f", currentCurve.getApproxCurveLength()), String.format("%8f", currentCurve.getCurvatureStdDev()), String.format("%8f", currentCurve.getPointCurvature(this.getPointSlider().getValue()))};
            for (int i2 = 0; i2 < NO_STATS; ++i2) {
                this.valueLabels[i2].setText(values[i2]);
            }
        } else {
            String[] values = new String[]{curves.getNoSelected() + " CURVES SELECTED", String.format("%8f", curves.getAvgAverageCurvature(true)), String.format("%5.4f", curves.getAvgApproxCurveLength(true)), String.format("%8f", curves.getStdDevOfAvgCurvature(true)), String.format("%8f", curves.getAvgPointCurvature(this.getPointSlider().getValue(), true))};
            for (int i3 = 0; i3 < NO_STATS; ++i3) {
                this.valueLabels[i3].setText(values[i3]);
            }
        }
        if (this.curvatureChart.isVisible()) {
            this.curvatureChart.draw(this.curvaturePanel.getX(), this.curvaturePanel.getY() + 21, 225, this.curvaturePanel.getH(), g, Color.BLUE);
        }
        this.intensityChartRed.draw(this.intensityPanel.getX(), this.intensityPanel.getY() + 21, 225, this.intensityPanel.getH(), g, Color.RED);
        this.intensityChartGreen.draw(this.intensityPanel.getX(), this.intensityPanel.getY() + 21, 225, this.intensityPanel.getH(), g, Color.GREEN);
        this.intensityChartBlue.draw(this.intensityPanel.getX(), this.intensityPanel.getY() + 21, 225, this.intensityPanel.getH(), g, Color.BLUE);
    }

    public JList<String> getList() {
        return this.list;
    }

    public void setList(JList<String> list) {
        this.list = list;
    }

    public Vector<String> getListData() {
        return this.listData;
    }

    public void setListData(Vector<String> listData) {
        this.listData = listData;
    }

    public JTextField getNameField() {
        return this.nameField;
    }

    public void setNameField(JTextField nameField) {
        this.nameField = nameField;
    }

    public JScrollPane getCurvesList() {
        return this.curvesList;
    }

    public void setCurvesList(JScrollPane curvesList) {
        this.curvesList = curvesList;
    }

    public JTextField getConversionField() {
        return this.conversionField;
    }

    public void setConversionField(JTextField conversionField) {
        this.conversionField = conversionField;
    }

    public JComboBox<String> getDataRangeComboBox() {
        return this.dataRangeComboBox;
    }

    public void setDataRangeComboBox(JComboBox<String> dataRangeComboBox) {
        this.dataRangeComboBox = dataRangeComboBox;
    }

    public JComboBox<String> getFittingChannelsComboBox() {
        return this.fittingChannelsComboBox;
    }

    public void setFittingChannelsComboBox(JComboBox<String> fittingChannelsComboBox) {
        this.fittingChannelsComboBox = fittingChannelsComboBox;
    }

    public JCheckBox getBgCheckBox() {
        return this.bgCheckBox;
    }

    public void setBgCheckBox(JCheckBox bgCheckBox) {
        this.bgCheckBox = bgCheckBox;
    }

    public JComboBox<String> getCurveComboBox() {
        return this.curveComboBox;
    }

    public void setCurveComboBox(JComboBox<String> curveComboBox) {
        this.curveComboBox = curveComboBox;
    }

    public JComboBox<String> getBsplineComboBox() {
        return this.bsplineComboBox;
    }

    public void setBsplineComboBox(JComboBox<String> bsplineComboBox) {
        this.bsplineComboBox = bsplineComboBox;
    }

    public JComboBox<String> getFittingComboBox() {
        return this.fittingComboBox;
    }

    public void setFittingComboBox(JComboBox<String> fittingComboBox) {
        this.fittingComboBox = fittingComboBox;
    }

    public JComboBox<String> getThresholdChannelsComboBox() {
        return this.thresholdChannelsComboBox;
    }

    public void setThresholdChannelsComboBox(JComboBox<String> thresholdChannelsComboBox) {
        this.thresholdChannelsComboBox = thresholdChannelsComboBox;
    }

    public JCheckBox getShowRadiusCheckBox() {
        return this.showRadiusCheckBox;
    }

    public void setShowRadiusCheckBox(JCheckBox showRadiusCheckBox) {
        this.showRadiusCheckBox = showRadiusCheckBox;
    }

    public JCheckBox getShowDatapointsCheckBox() {
        return this.showDatapointsCheckBox;
    }

    public void setShowDatapointsCheckBox(JCheckBox showDatapointsCheckBox) {
        this.showDatapointsCheckBox = showDatapointsCheckBox;
    }

    public JSpinner getRangeAveragingSpinner() {
        return this.rangeAveragingSpinner;
    }

    public void setRangeAveragingSpinner(JSpinner rangeAveragingSpinner) {
        this.rangeAveragingSpinner = rangeAveragingSpinner;
    }

    public JSpinner getThresholdRadiusSpinner() {
        return this.thresholdRadiusSpinner;
    }

    public void setThresholdRadiusSpinner(JSpinner thresholdRadiusSpinner) {
        this.thresholdRadiusSpinner = thresholdRadiusSpinner;
    }

    public JButton getApply() {
        return this.apply;
    }

    public void setApply(JButton apply) {
        this.apply = apply;
    }

    public JButton getRevert() {
        return this.revert;
    }

    public void setRevert(JButton revert) {
        this.revert = revert;
    }

    public JLabel getBgThresholdLabel() {
        return this.bgThresholdLabel;
    }

    public void setBgThresholdLabel(JLabel bgThresholdLabel) {
        this.bgThresholdLabel = bgThresholdLabel;
    }

    public JLabel getBsplineOptionLabel() {
        return this.bsplineOptionLabel;
    }

    public void setBsplineOptionLabel(JLabel bsplineOptionLabel) {
        this.bsplineOptionLabel = bsplineOptionLabel;
    }

    public JLabel getDataThresholdLabel() {
        return this.dataThresholdLabel;
    }

    public void setDataThresholdLabel(JLabel dataThresholdLabel) {
        this.dataThresholdLabel = dataThresholdLabel;
    }

    public JSlider getDataThresholdSlider() {
        return this.dataThresholdSlider;
    }

    public void setDataThresholdSlider(JSlider dataThresholdSlider) {
        this.dataThresholdSlider = dataThresholdSlider;
    }

    public JSlider getPointSlider() {
        return this.pointSlider;
    }

    public void setPointSlider(JSlider pointSlider) {
        this.pointSlider = pointSlider;
    }

    public JSlider getThresholdSlider() {
        return this.thresholdSlider;
    }

    public void setThresholdSlider(JSlider thresholdSlider) {
        this.thresholdSlider = thresholdSlider;
    }

    protected int getOffsetRadius() {
        return this.offsetRadius;
    }

    protected void setOffsetRadius(int offsetRadius) {
        this.offsetRadius = offsetRadius;
    }

    public void updateConversionField(String newValue) {
        Double oldScaleFactor = Curve.getMicronPixelFactor();
        try {
            double newScaleFactor = Double.parseDouble(newValue);
            Curve.setMicronPixelFactor(newScaleFactor);
            this.frame.getCurves().recalculateCurvature(this.frame.getControlPanel().getCurrentLayerSlider().getValue());
        }
        catch (Exception err) {
            Curve.setMicronPixelFactor(oldScaleFactor);
        }
        this.repaint();
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            InfoPanel.this.panels.toggleVisibility(event.getPoint());
            InfoPanel.this.repaint();
        }
    }

    private class PointChanger
    implements ChangeListener {
        private PointChanger() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            InfoPanel.this.pointLabel.setText("Point " + InfoPanel.this.frame.formatNumber(InfoPanel.this.getPointSlider().getValue(), 4) + " / " + InfoPanel.this.frame.getNumberOfPointsPerCurve());
            InfoPanel.this.frame.drawImageOverlay();
            InfoPanel.this.repaint();
        }
    }
}

