/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jpedal.PdfDecoder;

public class PDF_Viewer
extends ImagePlus
implements PlugIn {
    int scaling = 1;
    int page = 0;

    public void run(String arg) {
        ImagePlus imp;
        String path = PDF_Viewer.getPath(arg);
        if (null == path) {
            return;
        }
        int scale = 1;
        int page = 0;
        if (null == arg || 0 == arg.trim().length()) {
            GenericDialog gd = new GenericDialog("Options");
            String[] scales = new String[]{"100", "200", "300", "400", "500", "600", "700", "800", "900", "1000"};
            gd.addChoice("Scale: ", scales, scales[0]);
            gd.addNumericField("Page (0 for all): ", 0.0, 0);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            scale = gd.getNextChoiceIndex() + 1;
            page = (int)gd.getNextNumber();
            if (page < 0) {
                page = 0;
            }
        }
        if (null == (imp = PDF_Viewer.open(path, page, scale))) {
            return;
        }
        if (null != imp.getStack()) {
            this.setStack(imp.getTitle(), imp.getStack());
        } else {
            this.setTitle(imp.getTitle());
        }
        Object obinfo = imp.getProperty("Info");
        if (null != obinfo) {
            this.setProperty("Info", obinfo);
        }
        this.setFileInfo(imp.getOriginalFileInfo());
        if (null == arg || 0 == arg.trim().length()) {
            this.show();
        }
    }

    static String getPath(String arg) {
        if (null != arg && (0 == arg.indexOf("http://") || new File(arg).exists())) {
            return arg;
        }
        OpenDialog od = new OpenDialog("Choose a PDF file", null);
        String dir = od.getDirectory();
        if (null == dir) {
            return null;
        }
        String filename = od.getFileName();
        if (!filename.toLowerCase().endsWith(".pdf")) {
            IJ.log((String)("Not a PDF file: " + arg));
            return null;
        }
        if (!(dir = dir.replace('\\', '/')).endsWith("/")) {
            dir = dir + "/";
        }
        return dir + filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImagePlus open(String path, int page, int scale) {
        if (page < 0) {
            IJ.log((String)("Can't open negative page number " + page));
            return null;
        }
        if (scale < 1) {
            IJ.log((String)"Can't use a scale smaller than 1 (100%).");
            return null;
        }
        PdfDecoder decoder = null;
        try {
            int n_pages;
            decoder = new PdfDecoder();
            decoder.setDefaultDisplayFont("SansSerif");
            if (path.startsWith("http://")) {
                decoder.openPdfFileFromURL(path);
            } else {
                decoder.openPdfFile(path);
            }
            decoder.setPageParameters((float)scale, 1);
            String msg = decoder.getPageFailureMessage();
            if (null != msg && !msg.equals("")) {
                IJ.log((String)msg);
            }
            if (0 == (n_pages = decoder.getPageCount())) {
                IJ.log((String)"PDF file has zero pages.");
                ImagePlus imagePlus = null;
                return imagePlus;
            }
            if (page > n_pages) {
                IJ.log((String)("Can't open page " + page + ": There are only " + n_pages));
                ImagePlus imagePlus = null;
                return imagePlus;
            }
            if (0 == page) {
                BufferedImage bi_first = decoder.getPageAsImage(1);
                int width = bi_first.getWidth();
                int height = bi_first.getHeight();
                msg = decoder.getPageFailureMessage();
                if (null != msg && !msg.equals("")) {
                    IJ.log((String)msg);
                }
                if (null == bi_first) {
                    IJ.log((String)"PDF Viewer: Can't read first page.");
                    ImagePlus imagePlus = null;
                    return imagePlus;
                }
                ImageStack stack = new ImageStack(width, height);
                stack.addSlice("1", (ImageProcessor)new ColorProcessor((Image)bi_first));
                bi_first.flush();
                for (int i = 2; i <= n_pages; ++i) {
                    BufferedImage bi = decoder.getPageAsImage(i);
                    ColorProcessor cp = null;
                    if (bi.getWidth() == width && bi.getHeight() == height) {
                        cp = new ColorProcessor((Image)bi);
                    } else {
                        ColorProcessor cp2 = new ColorProcessor((Image)bi);
                        cp2 = (ColorProcessor)cp2.resize(width, cp2.getHeight() * width / cp2.getWidth());
                        cp = new ColorProcessor(width, height);
                        cp.insert((ImageProcessor)cp2, 0, 0);
                    }
                    stack.addSlice(Integer.toString(i + 1), (ImageProcessor)cp);
                    bi.flush();
                }
                ImagePlus imagePlus = new ImagePlus(new File(path).getName(), stack);
                return imagePlus;
            }
            BufferedImage bi = decoder.getPageAsImage(page);
            ImagePlus imagePlus = new ImagePlus(new File(path).getName(), (Image)bi);
            return imagePlus;
        }
        catch (Exception e) {
            IJ.log((String)("Error: " + e));
            e.printStackTrace();
        }
        finally {
            if (null != decoder) {
                decoder.flushObjectValues(true);
                decoder.closePdfFile();
            }
        }
        return null;
    }
}

