/*
 * Decompiled with CFR 0.152.
 */
package io.scif.cli.info;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.Metadata;
import io.scif.cli.AbstractSCIFIOToolCommand;
import io.scif.cli.SCIFIOToolCommand;
import io.scif.config.SCIFIOConfig;
import io.scif.services.InitializeService;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.imagej.axis.CalibratedAxis;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=SCIFIOToolCommand.class)
public class Info
extends AbstractSCIFIOToolCommand {
    @Parameter
    private InitializeService initializeService;
    @Argument(metaVar="file", index=0, usage="image dataset to parse")
    private String file;
    @Argument(index=1, multiValued=true)
    private final List<String> arguments = new ArrayList<String>();

    @Override
    protected void run() throws CmdLineException {
        try {
            Metadata meta = this.initializeService.parseMetadata(this.location(this.file), new SCIFIOConfig().checkerSetOpen(true));
            this.printDatasetMetadata(meta);
            this.printImageMetadata(meta);
        }
        catch (FormatException | IOException e) {
            throw new CmdLineException(null, e.getMessage());
        }
    }

    @Override
    protected String description() {
        return "command line tool for printing metadata from a dataset.";
    }

    @Override
    protected String getName() {
        return "info";
    }

    @Override
    protected List<String> getExtraArguments() {
        return this.arguments;
    }

    @Override
    protected void validateParams() throws CmdLineException {
        if (this.file == null) {
            throw new CmdLineException(null, "Argument \"file\" is required");
        }
    }

    @Override
    public String commandName() {
        return "info";
    }

    private void printImageMetadata(Metadata meta) {
        this.info("");
        this.info("Reading image metadata");
        for (int i = 0; i < meta.getImageCount(); ++i) {
            this.info("Image: " + (i + 1));
            ImageMetadata iMeta = meta.get(i);
            this.printTable(iMeta.getTable());
            this.print(iMeta);
        }
    }

    private void print(ImageMetadata iMeta) {
        this.info("Image size: " + iMeta.getSize());
        this.info("Plane size: " + iMeta.getPlaneSize());
        this.info("Plane count: " + iMeta.getPlaneCount());
        this.info("Planar axes: " + this.getAxisLabels(iMeta.getAxesPlanar()));
        this.info("Planar lengths: " + this.getAxisLengths(iMeta.getAxesLengthsPlanar()));
        this.info("Non-planar axes: " + this.getAxisLabels(iMeta.getAxesNonPlanar()));
        this.info("Non-planar lengths: " + this.getAxisLengths(iMeta.getAxesLengthsNonPlanar()));
        this.info("Axis calibration: " + this.getAxisCalibrations(iMeta));
        this.info("Pixel type: " + FormatTools.getPixelTypeString((int)iMeta.getPixelType()));
        this.info("Bits per pixel: " + iMeta.getBitsPerPixel());
        this.info("Interleaved axes: " + iMeta.getInterleavedAxisCount());
        this.info("Thumbnail width: " + iMeta.getThumbSizeX());
        this.info("Thumbnail height: " + iMeta.getThumbSizeY());
        this.info("False color: " + iMeta.isFalseColor());
        this.info("Indexed: " + iMeta.isIndexed());
        this.info("Little endian: " + iMeta.isLittleEndian());
        this.info("Metadata complete: " + iMeta.isMetadataComplete());
        this.info("Order certain: " + iMeta.isOrderCertain());
        this.info("Thumbnail: " + iMeta.isThumbnail());
    }

    private String getAxisLengths(long[] axesLengths) {
        StringBuilder sb = new StringBuilder();
        for (long l : axesLengths) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(l);
        }
        return sb.toString();
    }

    private String getAxisCalibrations(ImageMetadata iMeta) {
        StringBuilder sb = new StringBuilder();
        for (CalibratedAxis axis : iMeta.getAxes()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(axis.particularEquation() + " " + axis.unit());
        }
        return sb.toString();
    }

    private String getAxisLabels(List<CalibratedAxis> axes) {
        StringBuilder sb = new StringBuilder();
        for (CalibratedAxis axis : axes) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(axis.type().getLabel());
        }
        return sb.toString();
    }

    private void printDatasetMetadata(Metadata meta) {
        this.info("");
        this.info("Dataset: " + meta.getDatasetName());
        this.info("Dataset size: " + meta.getDatasetSize());
        this.info("Image count: " + meta.getImageCount());
        this.info("Reading dataset metadata");
        this.printTable(meta.getTable());
    }

    private void printTable(MetaTable table) {
        for (String key : table.keySet()) {
            Object val = table.get((Object)key);
            if (val instanceof Collection) {
                this.info(key + ":");
                for (Object listVal : (Collection)val) {
                    this.info("\t" + listVal);
                }
                continue;
            }
            this.info(key + ": " + val);
        }
    }
}

