/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Light;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;
import org.jogamp.vecmath.Color3f;

public abstract class LightState
extends LeafState {
    private int boundingLeaf = 0;
    private int[] scope;

    public LightState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.scope = new int[((Light)this.node).numScopes()];
        for (int i = 0; i < ((Light)this.node).numScopes(); ++i) {
            this.scope[i] = this.control.getSymbolTable().addReference(((Light)this.node).getScope(i));
        }
        this.boundingLeaf = this.control.getSymbolTable().addReference(((Light)this.node).getInfluencingBoundingLeaf());
        Color3f color = new Color3f();
        ((Light)this.node).getColor(color);
        this.control.writeColor3f(out, color);
        out.writeBoolean(((Light)this.node).getEnable());
        out.writeInt(this.boundingLeaf);
        this.control.writeBounds(out, ((Light)this.node).getInfluencingBounds());
        out.writeInt(this.scope.length);
        for (int i = 0; i < this.scope.length; ++i) {
            out.writeInt(this.scope[i]);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Light)this.node).setColor(this.control.readColor3f(in));
        ((Light)this.node).setEnable(in.readBoolean());
        this.boundingLeaf = in.readInt();
        ((Light)this.node).setInfluencingBounds(this.control.readBounds(in));
        this.scope = new int[in.readInt()];
        for (int i = 0; i < this.scope.length; ++i) {
            this.scope[i] = in.readInt();
        }
    }

    @Override
    public void buildGraph() {
        ((Light)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        for (int i = 0; i < this.scope.length; ++i) {
            ((Light)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scope[i]));
        }
        super.buildGraph();
    }
}

