/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.generate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JNIGenerator {
    private static final Pattern namePattern = Pattern.compile("JNIEXPORT.+?\\(");
    private static final Set<String> NEED_CBLAS_ORDERING = new HashSet<String>(Arrays.asList("cblas_sgemv", "cblas_sgbmv", "cblas_strmv", "cblas_stbmv", "cblas_stpmv", "cblas_strsv", "cblas_stbsv", "cblas_stpsv", "cblas_dgemv", "cblas_dgbmv", "cblas_dtrmv", "cblas_dtbmv", "cblas_dtpmv", "cblas_dtrsv", "cblas_dtbsv", "cblas_dtpsv", "cblas_cgemv", "cblas_cgbmv", "cblas_ctrmv", "cblas_ctbmv", "cblas_ctpmv", "cblas_ctrsv", "cblas_ctbsv", "cblas_ctpsv", "cblas_zgemv", "cblas_zgbmv", "cblas_ztrmv", "cblas_ztbmv", "cblas_ztpmv", "cblas_ztrsv", "cblas_ztbsv", "cblas_ztpsv", "cblas_ssymv", "cblas_ssbmv", "cblas_sspmv", "cblas_sger", "cblas_ssyr", "cblas_sspr", "cblas_ssyr2", "cblas_sspr2", "cblas_dsymv", "cblas_dsbmv", "cblas_dspmv", "cblas_dger", "cblas_dsyr", "cblas_dspr", "cblas_dsyr2", "cblas_dspr2", "cblas_chemv", "cblas_chbmv", "cblas_chpmv", "cblas_cgeru", "cblas_cgerc", "cblas_cher", "cblas_chpr", "cblas_cher2", "cblas_chpr2", "cblas_zhemv", "cblas_zhbmv", "cblas_zhpmv", "cblas_zgeru", "cblas_zgerc", "cblas_zher", "cblas_zhpr", "cblas_zher2", "cblas_zhpr2", "cblas_sgemm", "cblas_ssymm", "cblas_ssyrk", "cblas_ssyr2k", "cblas_strmm", "cblas_strsm", "cblas_dgemm", "cblas_dsymm", "cblas_dsyrk", "cblas_dsyr2k", "cblas_dtrmm", "cblas_dtrsm", "cblas_cgemm", "cblas_csymm", "cblas_csyrk", "cblas_csyr2k", "cblas_ctrmm", "cblas_ctrsm", "cblas_zgemm", "cblas_zsymm", "cblas_zsyrk", "cblas_zsyr2k", "cblas_ztrmm", "cblas_ztrsm", "cblas_chemm", "cblas_cherk", "cblas_cher2k", "cblas_zhemm", "cblas_zherk", "cblas_zher2k"));
    private static final Pattern sigPattern = Pattern.compile("Signature: \\((.+?)\\)");
    private static final Map<String, String> types = new HashMap<String, String>();
    private static final boolean USE_CRITICAL_ARRAYS = true;
    private final boolean blasHack;
    private final StringBuilder cleanup = new StringBuilder();
    private final List<String> cNames = new ArrayList<String>();
    private final StringBuilder init = new StringBuilder();
    private final String name;
    private final List<String> names = new ArrayList<String>();
    private final String post;
    private final StringBuilder postInit = new StringBuilder();
    private final String pre;
    private final List<String> signatures = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        String line;
        if (args.length < 1) {
            throw new IllegalArgumentException("Must pass a filename");
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            throw new IllegalArgumentException(args[0] + " was not a valid filename");
        }
        String pre = "";
        String post = "";
        if (args.length > 1) {
            pre = args[1];
            if (args.length > 2) {
                post = args[2];
            }
        }
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader streamReader = new InputStreamReader((InputStream)stream, "UTF-8");
        BufferedReader reader = new BufferedReader(streamReader);
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        Matcher matcher = Pattern.compile("/\\*[^#]+?JNIEXPORT.+?\\);", 8).matcher(builder.toString());
        System.out.println("#include <jni.h>\n\n");
        while (matcher.find()) {
            JNIGenerator generator = new JNIGenerator(matcher.group(), pre, post, false);
            System.out.println(generator.getTemplate());
        }
    }

    public JNIGenerator(String method, String pre, String post, boolean blasHack) {
        assert (method != null && pre != null && post != null);
        this.pre = pre;
        this.post = post;
        this.blasHack = blasHack;
        Matcher sigMatcher = sigPattern.matcher(method);
        sigMatcher.find();
        String signature = sigMatcher.group(1);
        int offset = 0;
        while (offset < signature.length()) {
            if (signature.startsWith(";", offset)) {
                ++offset;
                continue;
            }
            boolean matched = false;
            for (String sig : types.keySet()) {
                if (!signature.startsWith(sig, offset)) continue;
                String type = types.get(sig);
                this.signatures.add(type);
                offset += sig.length();
                matched = true;
                break;
            }
            if (matched) continue;
            throw new RuntimeException("Type " + signature.substring(offset) + " not implemented yet, sorry!");
        }
        Matcher nameMatcher = namePattern.matcher(method);
        nameMatcher.find();
        this.name = nameMatcher.group();
        for (int i = 0; i < this.signatures.size(); ++i) {
            this.names.add("arg" + (i + 1));
        }
    }

    public JNIGenerator(String pre, String post, String methodName, List<String> types, List<String> names, String returnType, boolean blasHack) {
        this.pre = pre;
        this.post = post;
        this.blasHack = blasHack;
        if (!returnType.equals("void")) {
            returnType = "j" + returnType;
        }
        this.name = "JNIEXPORT " + returnType + " JNICALL Java_" + methodName.replace(".", "_") + " (";
        this.names.addAll(names);
        for (String type : types) {
            String sig = JNIGenerator.types.get(type);
            assert (sig != null) : type + " not supported yet";
            this.signatures.add(sig);
        }
    }

    public String getTemplate() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append("JNIEnv * env, jobject calling_obj");
        if (this.signatures.size() > 0) {
            builder.append(", ");
        }
        for (i = 0; i < this.signatures.size(); ++i) {
            String sig = this.signatures.get(i);
            if ("intW".equals(sig) || "doubleW".equals(sig) || "floatW".equals(sig) || "booleanW".equals(sig) || "StringW".equals(sig)) {
                sig = "jobject";
            }
            builder.append(sig + " " + this.names.get(i));
            if (i == this.signatures.size() - 1) continue;
            builder.append(", ");
        }
        builder.append("){\n");
        for (i = 0; i < this.signatures.size(); ++i) {
            this.initArgs(i, this.signatures.get(i));
            this.cleanupArgs(i, this.signatures.get(i));
        }
        builder.append((CharSequence)this.init);
        String returnType = this.name.replaceAll("JNIEXPORT ", "").replaceAll(" JNICALL.*", "");
        if (!"void".equals(returnType)) {
            builder.append("\t" + returnType + " returnValue;\n");
        }
        builder.append((CharSequence)this.postInit);
        builder.append("\n\t");
        String cName = this.guessCFunctionName();
        if (!"void".equals(returnType)) {
            builder.append("returnValue = ");
        }
        builder.append(cName + "(");
        if (NEED_CBLAS_ORDERING.contains(cName)) {
            builder.append("F2J_JNI_ORDER, ");
        }
        for (int i2 = 0; i2 < this.signatures.size(); ++i2) {
            builder.append(this.parameterise(i2));
            if (i2 == this.signatures.size() - 1) continue;
            builder.append(", ");
        }
        if (this.guessCFunctionName().equals("ilaenv_")) {
            builder.append(", (*env)->GetStringLength(env, " + this.names.get(1) + ")");
            builder.append(", (*env)->GetStringLength(env, " + this.names.get(2) + ")");
        }
        builder.append(");");
        builder.append("\n\n");
        builder.append((CharSequence)this.cleanup);
        if (!"void".equals(returnType)) {
            builder.append("\n\treturn returnValue;\n");
        }
        builder.append("}\n");
        return builder.toString().replaceAll("Get\\w+?ArrayElements", "GetPrimitiveArrayCritical").replaceAll("Release\\w+?ArrayElements", "ReleasePrimitiveArrayCritical");
    }

    private void cleanupArgs(int arg, String type) {
        String jName = this.names.get(arg);
        String cName = this.cNames.get(arg);
        if (type.equals("jstring")) {
            this.cleanup.append("\t(*env)->ReleaseStringUTFChars(env, " + jName + ", " + cName + ");\n");
        } else if (type.equals("jintArray")) {
            this.cleanup.append("\t(*env)->ReleaseIntArrayElements(env, " + jName + ", " + cName + ", 0);\n");
        } else if (type.equals("jdoubleArray")) {
            this.cleanup.append("\t(*env)->ReleaseDoubleArrayElements(env, " + jName + ", " + cName + ", 0);\n");
        } else if (type.equals("jfloatArray")) {
            this.cleanup.append("\t(*env)->ReleaseFloatArrayElements(env, " + jName + ", " + cName + ", 0);\n");
        } else if (type.equals("jbooleanArray")) {
            this.cleanup.append("\tfor (" + cName + "i = 0 ; " + cName + "i < " + cName + "Size ; " + cName + "i++){\n");
            this.cleanup.append("\t\tif (" + cName + "[" + cName + "i] == 0){\n");
            this.cleanup.append("\t\t\t" + cName + "Tmp[" + cName + "i] = JNI_FALSE;\n");
            this.cleanup.append("\t\t} else {\n");
            this.cleanup.append("\t\t\t" + cName + "Tmp[" + cName + "i] = JNI_TRUE;\n");
            this.cleanup.append("\t\t}\n\t}\n");
            this.cleanup.append("\t(*env)->ReleaseBooleanArrayElements(env, " + jName + ", " + cName + "Tmp, 0);\n");
        } else if (type.equals("intW")) {
            this.cleanup.append("\t(*env)->SetIntField(env, " + jName + ", " + cName + "Id, " + cName + ");\n");
        } else if (type.equals("doubleW")) {
            this.cleanup.append("\t(*env)->SetDoubleField(env, " + jName + ", " + cName + "Id, " + cName + ");\n");
        } else if (type.equals("floatW")) {
            this.cleanup.append("\t(*env)->SetFloatField(env, " + jName + ", " + cName + "Id, " + cName + ");\n");
        } else if (type.equals("StringW")) {
            this.cleanup.append("\tjstring " + cName + "StringNew = (*env)->NewStringUTF(env, " + cName + ");\n");
            this.cleanup.append("\t(*env)->SetObjectField(env, " + jName + ", " + cName + "Id, " + cName + "StringNew);\n");
        } else if (type.equals("booleanW")) {
            this.cleanup.append("\t(*env)->SetBooleanField(env, " + jName + ", " + cName + "Id, (jboolean)" + cName + ");\n");
        }
    }

    private String guessCFunctionName() {
        String guess = this.name.replaceAll(".*_", "").replaceAll("\\W.*", "");
        return this.pre + guess + this.post;
    }

    private void initArgs(int arg, String type) {
        String jName = this.names.get(arg);
        String cName = "jni_" + jName;
        if (type.equals("jboolean")) {
            this.init.append("\tlogical " + cName + " = (logical)" + jName + ";\n");
            this.cNames.add(cName);
        } else if (type.equals("jbyte")) {
            this.cNames.add(jName);
        } else if (type.equals("jchar")) {
            this.cNames.add(jName);
        } else if (type.equals("jshort")) {
            this.cNames.add(jName);
        } else if (type.equals("jint")) {
            this.cNames.add(jName);
        } else if (type.equals("jlong")) {
            this.cNames.add(jName);
        } else if (type.equals("jfloat")) {
            this.cNames.add(jName);
        } else if (type.equals("jdouble")) {
            this.cNames.add(jName);
        } else if (type.equals("jstring")) {
            this.init.append("\tchar * " + cName + " = (char *)(*env)->GetStringUTFChars(env, " + jName + ", JNI_FALSE);\n");
            this.cNames.add(cName);
        } else if (type.equals("jintArray")) {
            this.init.append("\tjint * " + cName + " = (*env)->GetIntArrayElements(env, " + jName + ", JNI_FALSE);\n\tcheck_memory(env, " + cName + ");\n");
            this.cNames.add(cName);
        } else if (type.equals("jdoubleArray")) {
            this.init.append("\tjdouble * " + cName + " = (*env)->GetDoubleArrayElements(env, " + jName + ", JNI_FALSE);\n\tcheck_memory(env, " + cName + ");\n");
            this.cNames.add(cName);
        } else if (type.equals("jfloatArray")) {
            this.init.append("\tjfloat * " + cName + " = (*env)->GetFloatArrayElements(env, " + jName + ", JNI_FALSE);\n\tcheck_memory(env, " + cName + ");\n");
            this.cNames.add(cName);
        } else if (type.equals("jbooleanArray")) {
            this.init.append("\tjboolean * " + cName + "Tmp = (*env)->GetBooleanArrayElements(env, " + jName + ", JNI_FALSE);\n");
            this.init.append("\tjint " + cName + "Size = (*env)->GetArrayLength(env, " + jName + ");\n");
            this.init.append("\tlogical " + cName + "[" + cName + "Size];\n");
            this.init.append("\tint " + cName + "i;\n");
            this.postInit.append("\tfor (" + cName + "i = 0 ; " + cName + "i < " + cName + "Size ; " + cName + "i++){\n" + "\t\tif (" + cName + "Tmp[" + cName + "i] == JNI_FALSE){\n" + "\t\t\t" + cName + "[" + cName + "i] = 0;\n" + "\t\t} else {\n" + "\t\t\t" + cName + "[" + cName + "i] = 1;" + "\n\t\t}\n\t}\n");
            this.cNames.add(cName);
        } else if (type.equals("intW")) {
            this.init.append("\tjclass " + cName + "Class = (*env)->GetObjectClass(env, " + jName + ");\n");
            this.init.append("\tjfieldID " + cName + "Id = (*env)->GetFieldID(env, " + cName + "Class, \"val\", \"I\");\n");
            this.init.append("\tjint " + cName + " = (*env)->GetIntField(env, " + jName + ", " + cName + "Id);\n");
            this.cNames.add(cName);
        } else if (type.equals("doubleW")) {
            this.init.append("\tjclass " + cName + "Class = (*env)->GetObjectClass(env, " + jName + ");\n");
            this.init.append("\tjfieldID " + cName + "Id = (*env)->GetFieldID(env, " + cName + "Class, \"val\", \"D\");\n");
            this.init.append("\tjdouble " + cName + " = (*env)->GetDoubleField(env, " + jName + ", " + cName + "Id);\n");
            this.cNames.add(cName);
        } else if (type.equals("floatW")) {
            this.init.append("\tjclass " + cName + "Class = (*env)->GetObjectClass(env, " + jName + ");\n");
            this.init.append("\tjfieldID " + cName + "Id = (*env)->GetFieldID(env, " + cName + "Class, \"val\", \"D\");\n");
            this.init.append("\tjfloat " + cName + " = (*env)->GetFloatField(env, " + jName + ", " + cName + "Id);\n");
            this.cNames.add(cName);
        } else if (type.equals("StringW")) {
            this.init.append("\tjclass " + cName + "Class = (*env)->GetObjectClass(env, " + jName + ");\n");
            this.init.append("\tjfieldID " + cName + "Id = (*env)->GetFieldID(env, " + cName + "Class, \"val\", \"Ljava/lang/String;\");\n");
            this.init.append("\tjstring " + cName + "String = (jstring)((*env)->GetObjectField(env, " + jName + ", " + cName + "Id));\n");
            this.init.append("\tchar * " + cName + " = (char *)(*env)->GetStringUTFChars(env, " + cName + "String, JNI_FALSE);\n");
            this.cNames.add(cName);
        } else if (type.equals("booleanW")) {
            this.init.append("\tjclass " + cName + "Class = (*env)->GetObjectClass(env, " + jName + ");\n");
            this.init.append("\tjfieldID " + cName + "Id = (*env)->GetFieldID(env, " + cName + "Class, \"val\", \"I\");\n");
            this.init.append("\tjboolean " + cName + "Boolean = (*env)->GetBooleanField(env, " + jName + ", " + cName + "Id);\n");
            this.init.append("\tlogical " + cName + " = (logical)" + cName + "Boolean;\n");
            this.cNames.add(cName);
        } else {
            throw new RuntimeException("unknown type " + type);
        }
        assert (this.cNames.size() == arg + 1);
    }

    private String parameterise(int i) {
        String type;
        if (("".equals(this.pre) && "_".equals(this.post) || this.blasHack && (this.guessCFunctionName().equals("cblas_drotg") || this.guessCFunctionName().equals("cblas_srotg") || i != 3 && this.guessCFunctionName().equals("cblas_srotmg") || i != 3 && this.guessCFunctionName().equals("cblas_drotmg"))) && ("jint".equals(type = this.signatures.get(i)) || "jdouble".equals(type) || "jfloat".equals(type) || "jboolean".equals(type) || "intW".equals(type) || "doubleW".equals(type) || "booleanW".equals(type) || "floatW".equals(type))) {
            return "&" + this.cNames.get(i);
        }
        if (this.blasHack) {
            if (this.cNames.get(i).startsWith("jni_trans")) {
                return "getTrans(" + this.cNames.get(i) + ")";
            }
            if (this.cNames.get(i).startsWith("jni_uplo")) {
                return "getUpLo(" + this.cNames.get(i) + ")";
            }
            if (this.cNames.get(i).startsWith("jni_diag")) {
                return "getDiag(" + this.cNames.get(i) + ")";
            }
            if (this.cNames.get(i).startsWith("jni_side")) {
                return "getSide(" + this.cNames.get(i) + ")";
            }
        }
        return this.cNames.get(i);
    }

    static {
        types.put("Z", "jboolean");
        types.put("B", "jbyte");
        types.put("C", "jchar");
        types.put("S", "jshort");
        types.put("I", "jint");
        types.put("J", "jlong");
        types.put("F", "jfloat");
        types.put("D", "jdouble");
        types.put("Ljava/lang/String", "jstring");
        types.put("[I", "jintArray");
        types.put("[D", "jdoubleArray");
        types.put("[Z", "jbooleanArray");
        types.put("Lorg/netlib/util/intW", "intW");
        types.put("Lorg/netlib/util/doubleW", "doubleW");
        types.put("boolean", "jboolean");
        types.put("byte", "jbyte");
        types.put("char", "jchar");
        types.put("short", "jshort");
        types.put("int", "jint");
        types.put("long", "jlong");
        types.put("float", "jfloat");
        types.put("double", "jdouble");
        types.put("String", "jstring");
        types.put("int[]", "jintArray");
        types.put("double[]", "jdoubleArray");
        types.put("float[]", "jfloatArray");
        types.put("boolean[]", "jbooleanArray");
        types.put("intW", "intW");
        types.put("doubleW", "doubleW");
        types.put("floatW", "floatW");
        types.put("StringW", "StringW");
        types.put("booleanW", "booleanW");
    }
}

