/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import fiji.tool.AbstractTrackingTool;
import fiji.tool.ToolWithOptions;
import fiji.util.IntArray;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import sc.fiji.timelapse.DummyCanvas;
import sc.fiji.timelapse.Extrema;
import sc.fiji.timelapse.PlotUtils;
import sc.fiji.timelapse.ProfileStack;

public class Peak_Counter_Tool
extends AbstractTrackingTool
implements KeyListener,
ToolWithOptions {
    protected ImagePlus peakCountPlot;
    protected double[] peakCountPlotLimits;
    protected ProfileStack image;
    protected int slice;
    protected IntArray peaks;
    protected IntArray[] allPeaks;
    protected Map<ProfileStack, IntArray[]> allPeaksMap = new WeakHashMap<ProfileStack, IntArray[]>();
    protected int maxSpeed = 10;
    protected int handle;
    protected Map<ProfileStack, Integer> firstAdjustedSlice;

    public Peak_Counter_Tool() {
        this.clearToolsIfNecessary = true;
        this.firstAdjustedSlice = new WeakHashMap<ProfileStack, Integer>();
    }

    public String getToolIcon() {
        return "C111L7494D65Da5D56Da6D07D57Db7C00fL1838C111D48Db8Df8C00fL0919L3949C111Db9De9C00fD0aC111D2aC00fD4aC111DbaDeaC00fL0b1bL3b4bLbbdbL1c3cLacbcC111DccC00fLdcecDadC111DcdC00fDedLaebeLdeeeLbfdf";
    }

    protected boolean getImage(MouseEvent e) {
        return this.getImage(this.getImagePlus(e));
    }

    protected boolean getImage(ImagePlus image) {
        if (image instanceof ProfileStack) {
            if (this.image != image) {
                this.image = (ProfileStack)image;
                if (this.allPeaksMap.get(image) == null) {
                    this.allPeaksMap.put(this.image, new IntArray[image.getStackSize()]);
                }
                this.allPeaks = this.allPeaksMap.get(image);
                for (int i = 1; i <= image.getStackSize(); ++i) {
                    this.initializePeaks(i);
                }
                this.updatePeakCountPlot();
            }
            this.updateSlice();
            return true;
        }
        this.image = null;
        this.allPeaks = null;
        this.slice = -1;
        this.peaks = null;
        return false;
    }

    protected void updateSlice() {
        if (this.image == null) {
            return;
        }
        this.slice = this.image.getSlice();
        this.peaks = this.getPeaks(this.slice);
    }

    protected IntArray getPeaks(int slice) {
        if (this.allPeaks[slice - 1] == null) {
            this.allPeaks[slice - 1] = new IntArray();
        }
        return this.allPeaks[slice - 1];
    }

    protected synchronized void updatePeakCountPlot() {
        String title = this.image.getTitle();
        if (title.startsWith("Profiles of ")) {
            title = title.substring(12);
        }
        title = "Peak counts of " + title;
        double[] counts = new double[this.allPeaks.length];
        double[] regularized = new double[counts.length];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.allPeaks[i] != null ? (double)this.allPeaks[i].size() : 0.0;
            regularized[i] = i == 0 ? counts[0] : Math.max(regularized[i - 1], counts[i]);
        }
        double[] range = PlotUtils.range(1.0, counts.length);
        Plot plot = new Plot(title, "frame", "peak count", range, counts);
        this.peakCountPlotLimits = PlotUtils.setLimits(plot, range, counts);
        plot.draw();
        plot.setColor(Color.BLUE);
        plot.addPoints(range, regularized, 2);
        if (this.peakCountPlot == null || !this.peakCountPlot.isVisible()) {
            this.peakCountPlot = plot.show().getImagePlus();
            final ImageCanvas canvas = this.peakCountPlot.getCanvas();
            canvas.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (Peak_Counter_Tool.this.image == null) {
                        return;
                    }
                    int x = canvas.offScreenX(e.getX());
                    int frame = 1 + (int)((Peak_Counter_Tool.this.peakCountPlotLimits[1] - Peak_Counter_Tool.this.peakCountPlotLimits[0]) * (double)(x - 65) / (double)(Peak_Counter_Tool.this.peakCountPlot.getWidth() - 65 - 18));
                    if (frame >= 1 && frame <= Peak_Counter_Tool.this.image.getStackSize()) {
                        Peak_Counter_Tool.this.image.setSlice(frame);
                    }
                }
            });
        } else {
            ((PlotWindow)this.peakCountPlot.getWindow()).drawPlot(plot);
        }
    }

    protected int peakPosition(int x) {
        if (this.peaks.size() == 0) {
            return -1;
        }
        if (x <= this.peaks.get(0)) {
            return x == this.peaks.get(0) ? 0 : -1;
        }
        int len = this.peaks.size();
        if (x >= this.peaks.get(len - 1)) {
            return x == this.peaks.get(len - 1) ? len - 1 : -1 - len;
        }
        int left = 0;
        int right = len - 1;
        while (left + 1 < right) {
            int middle = (left + right) / 2;
            int value = this.peaks.get(middle);
            if (x == value) {
                return middle;
            }
            if (x < value) {
                right = middle;
                continue;
            }
            left = middle;
        }
        return -1 - right;
    }

    public void initializePeaks(int slice) {
        this.initializePeaks(slice, this.maxSpeed, (this.image.yMax - this.image.yMin) / (this.image.xMax - this.image.xMin));
    }

    public void initializePeaks(int slice, int window, double minimalSlope) {
        IntArray peaks = this.getPeaks(slice);
        peaks.clear();
        Extrema extrema = new Extrema(PlotUtils.toDouble(this.image.profiles[slice - 1]), window, minimalSlope, false);
        for (double extremum : extrema.getX()) {
            peaks.add((int)extremum);
        }
        if (this.slice == slice) {
            this.image.setRoi((Roi)this.toROI());
        }
    }

    protected int snapAndAddPeak(int x) {
        return this.addPeak(this.snapPeak(this.slice, x));
    }

    protected int snapPeak(int slice, int x) {
        int i;
        int center = x;
        for (i = 0; i < this.maxSpeed && center - i >= 0; ++i) {
            if (!(this.image.get(slice, x) > this.image.get(slice, center - i))) continue;
            x = center - i;
        }
        for (i = 0; i < this.maxSpeed && center + i < this.image.profiles[slice - 1].length; ++i) {
            if (!(this.image.get(slice, x) > this.image.get(slice, center + i))) continue;
            x = center + i;
        }
        return x;
    }

    protected int addPeak(int x) {
        if (x < 0 || x >= this.image.profiles[this.slice - 1].length) {
            return -1;
        }
        int index = this.peakPosition(x);
        if (index >= 0) {
            return index;
        }
        index = this.peaks.insert(-1 - index, x);
        return index;
    }

    protected int movePeak(int index, int x) {
        while (index > 0 && this.peaks.get(index - 1) > x) {
            this.peaks.set(index, this.peaks.get(index - 1));
            --index;
        }
        while (index + 1 < this.peaks.size() && this.peaks.get(index + 1) < x) {
            this.peaks.set(index, this.peaks.get(index + 1));
            ++index;
        }
        this.peaks.set(index, x);
        return index;
    }

    protected int closeToPeak(int x, int y) {
        return this.closeToPeak(x, y, 10.0 / this.image.getCanvas().getMagnification());
    }

    protected int closeToPeak(int x, int y, double tolerance) {
        double best = 3.4028234663852886E38;
        int bestIndex = -1;
        for (int i = 0; i < this.peaks.size(); ++i) {
            int distance = this.peaks.get(i);
            int x1 = this.image.distance2x(distance);
            double current = Math.abs(x - x1);
            if (!(best > current)) continue;
            best = current;
            bestIndex = i;
        }
        return best < tolerance ? bestIndex : -1;
    }

    protected PointRoi toROI() {
        float[] profile = this.image.profiles[this.slice - 1];
        int[] x = (int[])this.peaks.buildArray();
        int[] xValues = new int[x.length];
        int[] yValues = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            xValues[i] = this.image.distance2x(x[i]);
            yValues[i] = this.image.intensity2y(this.image.get(this.slice, x[i]));
        }
        return new PointRoi(xValues, yValues, x.length);
    }

    public Roi optimizeRoi(Roi roi, ImageProcessor ip) {
        return null;
    }

    protected void snapPeaks(int adjustedSlice) {
        if (this.firstAdjustedSlice.get((Object)this.image) == null || this.firstAdjustedSlice.get((Object)this.image) > adjustedSlice) {
            this.firstAdjustedSlice.put(this.image, adjustedSlice);
        }
        this.snapPeaks();
    }

    protected void snapPeaks() {
        Integer first = this.firstAdjustedSlice.get((Object)this.image);
        if (first == null || first < 2) {
            return;
        }
        for (int slice = first - 1; slice > 0; --slice) {
            this.snapPeaks(slice, this.allPeaks[slice + 1 - 1]);
        }
    }

    protected void snapPeaks(int slice, IntArray initialPeaks) {
        IntArray peaks = this.getPeaks(slice);
        peaks.clear();
        Iterator iterator = initialPeaks.iterator();
        while (iterator.hasNext()) {
            int peak = (Integer)iterator.next();
            if ((peak = this.snapPeak(slice, peak)) < 0 || peak >= this.image.profiles[slice - 1].length) continue;
            peaks.add(peak);
        }
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.getImage(e)) {
            if (this.handle < 0) {
                this.handle = this.snapAndAddPeak(this.image.x2distance(this.getOffscreenX(e)));
            } else {
                this.peaks.remove(this.handle);
                this.handle = -1;
            }
            this.image.setRoi((Roi)this.toROI());
            this.snapPeaks(this.slice);
            this.updatePeakCountPlot();
        }
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.getImageCanvas(e).setCursor(DummyCanvas.getDefaultCursor());
        e.consume();
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        e.consume();
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.getImage(this.getImagePlus(e))) {
            return;
        }
        int keyCode = e.getKeyCode();
        if (keyCode != 80 || (e.getModifiersEx() & 0x40) == 0) {
            return;
        }
        this.initializePeaks();
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected OvalRoi mark(int distance) {
        return this.mark(distance, null);
    }

    protected OvalRoi mark(int distance, Color color) {
        float intensity = this.image.get(this.slice, distance);
        int x = this.image.distance2x(distance);
        int y = this.image.intensity2y(intensity);
        OvalRoi roi = new OvalRoi(x - 10, y - 10, 20, 20);
        if (color != null) {
            roi.setStrokeColor(color);
        }
        return roi;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getImage(e)) {
            int offscreenX = this.getOffscreenX(e);
            int offscreenY = this.getOffscreenY(e);
            int distance = this.image.x2distance(offscreenX);
            float intensity = this.image.get(this.slice, distance);
            IJ.showStatus((String)("distance: " + distance + ", intensity: " + intensity));
            Overlay overlay = new Overlay((Roi)this.mark(distance));
            this.handle = this.closeToPeak(offscreenX, offscreenY);
            if (this.handle >= 0) {
                overlay.add((Roi)this.mark(this.peaks.get(this.handle), Color.RED));
                this.getImageCanvas(e).setCursor(DummyCanvas.getHandCursor());
            } else {
                this.getImageCanvas(e).setCursor(DummyCanvas.getDefaultCursor());
            }
            this.image.setOverlay(overlay);
            this.image.mark(this.slice, distance);
            e.consume();
        } else {
            super.mouseMoved(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.getImage(e)) {
            super.mouseDragged(e);
            return;
        }
        this.image.setOverlay(null);
        if (this.handle >= 0) {
            this.movePeak(this.handle, this.image.x2distance(this.getOffscreenX(e)));
            this.snapPeaks(this.slice);
            this.image.setRoi((Roi)this.toROI());
            this.getImageCanvas(e).setCursor(DummyCanvas.getMoveCursor());
        }
        e.consume();
    }

    public void sliceChanged(ImagePlus image) {
        if (this.image == image) {
            image.setOverlay(null);
        }
        super.sliceChanged(image);
        if (this.getImage(image)) {
            Peak_Counter_Tool.setRoi((ImagePlus)image, (Roi)this.toROI());
        }
    }

    protected void initializePeaks() {
        GenericDialogPlus gd = new GenericDialogPlus("Peak Finder");
        gd.addNumericField("Window", (double)this.maxSpeed, 0);
        gd.addNumericField("Minimal_Slope", (double)((this.image.yMax - this.image.yMin) / (this.image.xMax - this.image.xMin)), 2);
        gd.addNumericField("From_slice", 1.0, 0);
        gd.addNumericField("To_slice", (double)this.allPeaks.length, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int window = (int)gd.getNextNumber();
        double slope = gd.getNextNumber();
        int from = Math.max(1, (int)gd.getNextNumber());
        int to = Math.min(this.allPeaks.length, (int)gd.getNextNumber());
        for (int slice = from; slice <= to; ++slice) {
            this.initializePeaks(slice, window, slope);
        }
        this.image.setRoi((Roi)this.toROI());
        this.updatePeakCountPlot();
    }

    public void showOptionDialog() {
        if (!this.getImage(WindowManager.getCurrentImage())) {
            return;
        }
        final GenericDialogPlus gd = new GenericDialogPlus(this.getToolName() + " Options");
        gd.addButton("Determine peaks [P]", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gd.dispose();
                Peak_Counter_Tool.this.initializePeaks();
            }
        });
        gd.showDialog();
    }
}

