/*
 * Decompiled with CFR 0.152.
 */
package spimopener;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;

public class Rename
implements PlugIn {
    public void run(String arg) {
        GenericDialogPlus gd = new GenericDialogPlus("Rename");
        gd.addDirectoryField("Directory", "");
        gd.addStringField("File name", "");
        gd.addStringField("Replacement", "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String dir = gd.getNextString();
        String name = gd.getNextString();
        String repl = gd.getNextString();
        final ArrayList<File> src = new ArrayList<File>();
        final ArrayList<File> dst = new ArrayList<File>();
        this.collect(new File(dir), name, repl, src, dst);
        this.print(src, dst);
        final GenericDialog gd2 = new GenericDialog("Rename");
        gd2.addMessage("Rename all files");
        gd2.setModal(false);
        gd2.showDialog();
        gd2.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.out.println("Closing");
                if (gd2.wasOKed()) {
                    Rename.this.rename(src, dst);
                    IJ.showMessage((String)"Done");
                }
            }
        });
    }

    public void collect(File folder, String filename, String replacement, ArrayList<File> src, ArrayList<File> dst) {
        File[] children;
        IJ.showStatus((String)folder.getAbsolutePath());
        if (folder.getName().equals(filename)) {
            src.add(folder);
            dst.add(new File(folder.getParentFile(), replacement));
        }
        if ((children = folder.listFiles()) == null || children.length == 0) {
            return;
        }
        for (File child : children) {
            this.collect(child, filename, replacement, src, dst);
        }
    }

    public void print(ArrayList<File> src, ArrayList<File> dst) {
        int N = src.size();
        for (int i = 0; i < N; ++i) {
            IJ.log((String)(src.get(i).getAbsolutePath() + " -> " + dst.get(i).getAbsolutePath()));
            IJ.showProgress((int)(i + 1), (int)N);
        }
    }

    public void rename(ArrayList<File> src, ArrayList<File> dst) {
        int N = src.size();
        for (int i = 0; i < N; ++i) {
            if (dst.get(i).exists()) {
                IJ.log((String)("Not renaming " + src.get(i).getAbsolutePath() + " because target file exists alreadz."));
                continue;
            }
            if (!src.get(i).renameTo(dst.get(i))) {
                IJ.log((String)("Cannot rename " + src.get(i).getAbsolutePath() + " -> " + dst.get(i).getAbsolutePath()));
            }
            IJ.showProgress((int)(i + 1), (int)N);
        }
    }
}

