/*
 * Decompiled with CFR 0.152.
 */
package io.scif.jj2000.j2k.entropy.encoder;

import io.scif.jj2000.j2k.entropy.encoder.ByteOutputBuffer;

class BitToByteOutput {
    private boolean isPredTerm = false;
    static final int PAD_SEQ = 42;
    boolean delFF = false;
    ByteOutputBuffer out;
    int bbuf;
    int bpos = 7;
    int nb = 0;

    BitToByteOutput(ByteOutputBuffer out) {
        this.out = out;
    }

    final void writeBits(int[] symbuf, int nsym) {
        int bbuf = this.bbuf;
        int bpos = this.bpos;
        for (int i = 0; i < nsym; ++i) {
            bbuf |= (symbuf[i] & 1) << bpos--;
            if (bpos >= 0) continue;
            if (bbuf != 255) {
                if (this.delFF) {
                    this.out.write(255);
                    this.delFF = false;
                    ++this.nb;
                }
                this.out.write(bbuf);
                ++this.nb;
                bpos = 7;
            } else {
                this.delFF = true;
                bpos = 6;
            }
            bbuf = 0;
        }
        this.bbuf = bbuf;
        this.bpos = bpos;
    }

    final void writeBit(int bit) {
        this.bbuf |= (bit & 1) << this.bpos--;
        if (this.bpos < 0) {
            if (this.bbuf != 255) {
                if (this.delFF) {
                    this.out.write(255);
                    this.delFF = false;
                    ++this.nb;
                }
                this.out.write(this.bbuf);
                ++this.nb;
                this.bpos = 7;
            } else {
                this.delFF = true;
                this.bpos = 6;
            }
            this.bbuf = 0;
        }
    }

    void flush() {
        if (this.delFF) {
            if (this.bpos != 6) {
                this.out.write(255);
                this.delFF = false;
                ++this.nb;
                this.bbuf |= 42 >>> 6 - this.bpos;
                this.out.write(this.bbuf);
                ++this.nb;
                this.bpos = 7;
                this.bbuf = 0;
            } else if (this.isPredTerm) {
                this.out.write(255);
                ++this.nb;
                this.out.write(42);
                ++this.nb;
                this.bpos = 7;
                this.bbuf = 0;
                this.delFF = false;
            }
        } else if (this.bpos != 7) {
            this.bbuf |= 42 >>> 6 - this.bpos;
            this.out.write(this.bbuf);
            ++this.nb;
            this.bpos = 7;
            this.bbuf = 0;
        }
    }

    public int terminate() {
        this.flush();
        int savedNb = this.nb;
        this.reset();
        return savedNb;
    }

    void reset() {
        this.delFF = false;
        this.bpos = 7;
        this.bbuf = 0;
        this.nb = 0;
    }

    int length() {
        if (this.delFF) {
            return this.nb + 2;
        }
        return this.nb + (this.bpos == 7 ? 0 : 1);
    }

    void setPredTerm(boolean isPredTerm) {
        this.isPredTerm = isPredTerm;
    }
}

