/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.MetaTable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.scijava.util.StringUtils;

public class DefaultMetaTable
extends HashMap<String, Object>
implements MetaTable {
    private boolean filtered;

    public DefaultMetaTable() {
        this(false);
    }

    public DefaultMetaTable(boolean filter) {
        this.filtered = filter;
    }

    public DefaultMetaTable(Map<String, Object> copy) {
        for (String k : copy.keySet()) {
            this.put(k, copy.get(k));
        }
    }

    @Override
    public void putList(String key, Object value) {
        Object list = this.get(key);
        if (list == null) {
            list = new Vector();
        }
        if (list instanceof Vector) {
            Vector valueList = (Vector)list;
            valueList.add(value);
        } else {
            Vector<Object> v = new Vector<Object>();
            v.add(list);
            v.add(value);
            list = v;
        }
        this.put(key, list);
    }

    @Override
    public Object put(String key, Object value) {
        String val;
        if (key == null || value == null) {
            return null;
        }
        key = key.trim();
        boolean string = value instanceof String || value instanceof Character;
        boolean simple = string || value instanceof Number || value instanceof Boolean;
        String string2 = val = string ? String.valueOf(value) : null;
        if (this.filtered) {
            String[] invalidSequences;
            if (!simple) {
                return null;
            }
            int maxLen = 8192;
            if (key.length() > 8192) {
                return null;
            }
            if (string && val.length() > 8192) {
                return null;
            }
            key = StringUtils.sanitize((String)key);
            if (string) {
                val = StringUtils.sanitize((String)val);
            }
            if (!key.matches(".*[a-zA-Z].*")) {
                return null;
            }
            for (String invalidSequence : invalidSequences = new String[]{"&lt;", "&gt;", "&amp;", "<", ">", "&"}) {
                key = key.replaceAll(invalidSequence, "");
                if (!string) continue;
                val = val.replaceAll(invalidSequence, "");
            }
            if (key.length() == 0) {
                return null;
            }
            if (string && val.trim().length() == 0) {
                return null;
            }
            if (string) {
                value = val;
            }
        }
        return super.put(key, val == null ? value : val);
    }
}

