/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.FormatException;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import java.io.IOException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Codec.class)
public class MSRLECodec
extends AbstractCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("MSRLE compression not supported.");
    }

    @Override
    public byte[] decompress(DataHandle<Location> in, CodecOptions options) throws FormatException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        int code = 0;
        short extra = 0;
        int stream = 0;
        int pixelPt = 0;
        int rowPt = (options.height - 1) * options.width;
        int frameSize = options.height * options.width;
        if (options.previousImage == null) {
            options.previousImage = new byte[frameSize];
        }
        while (rowPt >= 0 && in.offset() < in.length() && pixelPt < options.previousImage.length) {
            stream = in.read() & 0xFF;
            code = stream;
            if (code == 0) {
                stream = in.read() & 0xFF;
                if (stream == 0) {
                    rowPt -= options.width;
                    pixelPt = 0;
                    continue;
                }
                if (stream == 1) {
                    return options.previousImage;
                }
                if (stream == 2) {
                    stream = in.read() & 0xFF;
                    pixelPt += stream;
                    stream = in.read() & 0xFF;
                    rowPt -= stream * options.width;
                    continue;
                }
                if (rowPt + pixelPt + stream > frameSize || rowPt < 0) {
                    return options.previousImage;
                }
                code = stream;
                extra = (short)(stream & 1);
                if ((long)(stream + code + extra) > in.length()) {
                    return options.previousImage;
                }
                while (code-- > 0) {
                    stream = in.read();
                    options.previousImage[rowPt + pixelPt] = (byte)stream;
                    ++pixelPt;
                }
                if (extra == 0) continue;
                in.skipBytes(1);
                continue;
            }
            if (rowPt + pixelPt + stream > frameSize || rowPt < 0) {
                return options.previousImage;
            }
            stream = in.read();
            while (code-- > 0) {
                options.previousImage[rowPt + pixelPt] = (byte)stream;
                ++pixelPt;
            }
        }
        return options.previousImage;
    }
}

