/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractFilter;
import io.scif.filters.MetadataWrapper;
import java.io.IOException;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;

public abstract class AbstractReaderFilter
extends AbstractFilter<Reader>
implements Reader {
    private Metadata wrappedMeta = null;
    private final Class<? extends MetadataWrapper> metaClass;
    @Parameter
    private PluginService pluginService;

    public AbstractReaderFilter() {
        this((Class<? extends MetadataWrapper>)null);
    }

    public AbstractReaderFilter(Class<? extends MetadataWrapper> metaClass) {
        super(Reader.class);
        this.metaClass = metaClass;
    }

    protected void setSourceHelper(Location source, SCIFIOConfig config) throws IOException {
        Location filterSource;
        Location location = filterSource = this.getMetadata() == null ? null : this.getMetadata().getSourceLocation();
        if (filterSource == null || !filterSource.equals(source)) {
            Metadata meta = ((Reader)this.getParent()).getMetadata();
            if (this.wrappedMeta instanceof MetadataWrapper) {
                ((MetadataWrapper)this.wrappedMeta).wrap(meta);
            } else {
                this.wrappedMeta = meta;
            }
        }
    }

    protected void openPlaneHelper() {
    }

    protected void readPlaneHelper() {
    }

    protected Metadata getParentMeta() {
        return ((Reader)this.getParent()).getMetadata();
    }

    @Override
    public Class<?> target() {
        return Reader.class;
    }

    @Override
    public void setParent(Object parent) {
        super.setParent(parent);
        Reader r = (Reader)parent;
        if (this.metaClass != null) {
            MetadataWrapper wrapper = null;
            try {
                wrapper = this.metaClass.newInstance();
                this.wrappedMeta = wrapper;
                this.getContext().inject((Object)wrapper);
                wrapper.wrap(r.getMetadata());
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.log().error((Object)("Failed to create MetadataWrapper of type: " + this.metaClass), (Throwable)e);
            }
        } else {
            this.wrappedMeta = r.getMetadata();
        }
        try {
            this.setSourceHelper(r.getCurrentLocation(), new SCIFIOConfig(this.getContext()));
        }
        catch (IOException exc) {
            this.log().error((Object)("Failed to create MetadataWrapper of type: " + this.metaClass), (Throwable)exc);
        }
    }

    @Override
    public boolean isCompatible(Class<?> c) {
        return Reader.class.isAssignableFrom(c);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    @Override
    public int fileGroupOption(Location id) throws FormatException, IOException {
        return ((Reader)this.getParent()).fileGroupOption(id);
    }

    @Override
    public Location getCurrentLocation() {
        return ((Reader)this.getParent()).getCurrentLocation();
    }

    @Override
    public String[] getDomains() {
        return ((Reader)this.getParent()).getDomains();
    }

    @Override
    public DataHandle<Location> getHandle() {
        return ((Reader)this.getParent()).getHandle();
    }

    @Override
    public long getOptimalTileWidth(int imageIndex) {
        return ((Reader)this.getParent()).getOptimalTileWidth(imageIndex);
    }

    @Override
    public long getOptimalTileHeight(int imageIndex) {
        return ((Reader)this.getParent()).getOptimalTileHeight(imageIndex);
    }

    @Override
    public void setMetadata(Metadata meta) throws IOException {
        ((Reader)this.getParent()).setMetadata(meta);
        if (this.wrappedMeta instanceof MetadataWrapper) {
            ((MetadataWrapper)this.wrappedMeta).wrap(meta);
        } else {
            this.wrappedMeta = meta;
        }
    }

    @Override
    public Metadata getMetadata() {
        return this.wrappedMeta;
    }

    @Override
    public void setNormalized(boolean normalize) {
        ((Reader)this.getParent()).setNormalized(normalize);
    }

    @Override
    public boolean isNormalized() {
        return ((Reader)this.getParent()).isNormalized();
    }

    @Override
    public boolean hasCompanionFiles() {
        return ((Reader)this.getParent()).hasCompanionFiles();
    }

    @Override
    public void setSource(Location loc) throws IOException {
        ((Reader)this.getParent()).setSource(loc);
        this.setSourceHelper(loc, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public void setSource(DataHandle<Location> handle) throws IOException {
        ((Reader)this.getParent()).setSource(handle);
        this.setSourceHelper((Location)handle.get(), new SCIFIOConfig(this.getContext()));
    }

    @Override
    public void setSource(Location loc, SCIFIOConfig config) throws IOException {
        ((Reader)this.getParent()).setSource(loc, config);
        this.setSourceHelper(loc, config);
    }

    @Override
    public void setSource(DataHandle<Location> handle, SCIFIOConfig config) throws IOException {
        ((Reader)this.getParent()).setSource(handle, config);
        this.setSourceHelper((Location)handle.get(), config);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        ((Reader)this.getParent()).close(fileOnly);
        if (this.wrappedMeta != null) {
            this.wrappedMeta.close(fileOnly);
            this.wrappedMeta = null;
        }
        if (!fileOnly) {
            this.cleanUp();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    @Override
    public Plane readPlane(DataHandle<Location> s, int imageIndex, Interval bounds, Plane plane) throws IOException {
        this.readPlaneHelper();
        return ((Reader)this.getParent()).readPlane(s, imageIndex, bounds, plane);
    }

    @Override
    public Plane readPlane(DataHandle<Location> s, int imageIndex, Interval bounds, int scanlinePad, Plane plane) throws IOException {
        this.readPlaneHelper();
        return ((Reader)this.getParent()).readPlane(s, imageIndex, bounds, scanlinePad, plane);
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return ((Reader)this.getParent()).getPlaneCount(imageIndex);
    }

    @Override
    public int getImageCount() {
        return ((Reader)this.getParent()).getImageCount();
    }

    @Override
    public Plane createPlane(Interval bounds) {
        return ((Reader)this.getParent()).createPlane(bounds);
    }

    @Override
    public Plane createPlane(ImageMetadata meta, Interval bounds) {
        return ((Reader)this.getParent()).createPlane(meta, bounds);
    }

    @Override
    public <P extends Plane> P castToTypedPlane(Plane plane) {
        return ((Reader)this.getParent()).castToTypedPlane(plane);
    }

    @Override
    public boolean isSingleFile(Location id) throws FormatException, IOException {
        return ((Reader)this.getParent()).isSingleFile(id);
    }

    @Override
    public Format getFormat() {
        return ((Reader)this.getParent()).getFormat();
    }

    @Override
    public String getFormatName() {
        return ((Reader)this.getParent()).getFormatName();
    }

    public Context getContext() {
        return ((Reader)this.getParent()).getContext();
    }

    public void setContext(Context ctx) {
        ((Reader)this.getParent()).setContext(ctx);
    }

    protected boolean metaCheck() {
        Metadata meta = this.getMetadata();
        return this.metaClass.isAssignableFrom(meta.getClass());
    }

    protected void cleanUp() throws IOException {
    }

    protected Interval planarBounds(int imageIndex) {
        FinalInterval bounds = new FinalInterval(this.getMetadata().get(imageIndex).getAxesLengthsPlanar());
        return bounds;
    }
}

