/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.qt;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractTranslator;
import io.scif.AbstractWriter;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.CompressionType;
import io.scif.codec.JPEGCodec;
import io.scif.codec.MJPBCodec;
import io.scif.codec.MJPBCodecOptions;
import io.scif.codec.QTRLECodec;
import io.scif.codec.ZlibCodec;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.qt.LegacyQTFormat;
import io.scif.formats.qt.QTJavaService;
import io.scif.services.FormatService;
import io.scif.services.TranslatorService;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="QuickTime")
public class NativeQTFormat
extends AbstractFormat {
    private static final String[] CONTAINER_TYPES = new String[]{"moov", "trak", "udta", "tref", "imap", "mdia", "minf", "stbl", "edts", "mdra", "rmra", "imag", "vnrp", "dinf"};

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"mov"};
    }

    private static class NativeQTUtils {
        private NativeQTUtils() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void parse(DataHandle<Location> stream, Metadata meta, int depth, long offset, long length, LogService log) throws FormatException, IOException {
            DataHandleService dataHandleService = null;
            while (offset < length) {
                stream.seek(offset);
                long atomSize = (long)stream.readInt() & 0xFFFFFFFFL;
                String atomType = stream.readString(4);
                if (atomSize == 1L) {
                    atomSize = stream.readLong();
                }
                if (atomSize < 0L) {
                    log.warn((Object)("QTReader: invalid atom size: " + atomSize));
                }
                log.debug((Object)("Seeking to " + offset + "; atomType=" + atomType + "; atomSize=" + atomSize));
                if (NativeQTUtils.isContainer(atomType)) {
                    NativeQTUtils.parse(stream, meta, depth++, stream.offset(), offset + atomSize, log);
                } else {
                    int i;
                    int i2;
                    if (atomSize == 0L) {
                        atomSize = stream.length();
                    }
                    long oldpos = stream.offset();
                    if (atomType.equals("mdat")) {
                        meta.setPixelOffset(stream.offset());
                        meta.setPixelBytes(atomSize - 8L);
                        if (meta.getPixelBytes() > stream.length() - meta.getPixelOffset()) {
                            meta.setPixelBytes(stream.length() - meta.getPixelOffset());
                        }
                    } else if (atomType.equals("tkhd")) {
                        stream.skipBytes(38);
                        int[][] matrix = new int[3][3];
                        for (i2 = 0; i2 < matrix.length; ++i2) {
                            for (int j = 0; j < matrix[0].length; ++j) {
                                matrix[i2][j] = stream.readInt();
                            }
                        }
                        meta.setFlip(matrix[0][0] == 0 && matrix[1][0] != 0);
                        if (meta.get(0).getAxisIndex(Axes.X) == -1) {
                            meta.get(0).setAxisLength(Axes.X, (long)stream.readInt());
                        }
                        if (meta.get(0).getAxisIndex(Axes.Y) == -1) {
                            meta.get(0).setAxisLength(Axes.Y, (long)stream.readInt());
                        }
                    } else if (atomType.equals("cmov")) {
                        stream.skipBytes(8);
                        if (!"zlib".equals(stream.readString(4))) throw new UnsupportedCompressionException("Compressed header not supported.");
                        atomSize = stream.readInt();
                        stream.skipBytes(4);
                        stream.readInt();
                        byte[] b = new byte[(int)(atomSize - 12L)];
                        stream.read(b);
                        CodecService codecService = (CodecService)meta.context().service(CodecService.class);
                        ZlibCodec codec = codecService.getCodec(ZlibCodec.class);
                        byte[] output = codec.decompress(b, null);
                        if (dataHandleService == null) {
                            dataHandleService = (DataHandleService)meta.getContext().getService(DataHandleService.class);
                        }
                        try (DataHandle tmpStream = (DataHandle)dataHandleService.create((Object)new BytesLocation(output));){
                            NativeQTUtils.parse((DataHandle<Location>)tmpStream, meta, 0, 0L, output.length, log);
                        }
                    } else if (atomType.equals("stco")) {
                        if (meta.getOffsets().size() > 0) return;
                        meta.setSpork(false);
                        stream.skipBytes(4);
                        int planeCount = (int)meta.get(0).getAxisLength(Axes.TIME);
                        int numPlanes = stream.readInt();
                        if (numPlanes != planeCount) {
                            stream.seek(stream.offset() - 4L);
                            int off = stream.readInt();
                            meta.getOffsets().add(off);
                            for (int i3 = 1; i3 < planeCount; ++i3) {
                                if (meta.getChunkSizes().isEmpty() && i3 < meta.getChunkSizes().size()) {
                                    meta.setRawSize(meta.getChunkSizes().get(i3));
                                } else {
                                    i3 = planeCount;
                                }
                                meta.getOffsets().add(off += meta.getRawSize());
                            }
                        } else {
                            for (i = 0; i < numPlanes; ++i) {
                                meta.getOffsets().add(stream.readInt());
                            }
                        }
                    } else if (atomType.equals("stsd")) {
                        stream.skipBytes(4);
                        int numEntries = stream.readInt();
                        stream.skipBytes(4);
                        for (i2 = 0; i2 < numEntries; ++i2) {
                            if (i2 == 0) {
                                meta.setCodec(stream.readString(4));
                                if (!(meta.getCodec().equals("raw ") || meta.getCodec().equals("rle ") || meta.getCodec().equals("rpza") || meta.getCodec().equals("mjpb") || meta.getCodec().equals("jpeg"))) {
                                    throw new UnsupportedCompressionException("Unsupported codec: " + meta.getCodec());
                                }
                                stream.skipBytes(16);
                                if (stream.readShort() != 0) continue;
                                stream.skipBytes(56);
                                meta.setBitsPerPixel(stream.readShort());
                                if (meta.getCodec().equals("rpza")) {
                                    meta.setBitsPerPixel(8);
                                }
                                stream.skipBytes(10);
                                meta.setInterlaced(stream.read() == 2);
                                meta.getTable().put("Codec", meta.getCodec());
                                meta.getTable().put("Bits per pixel", meta.getBitsPerPixel());
                                stream.skipBytes(9);
                                continue;
                            }
                            meta.setAltCodec(stream.readString(4));
                            meta.getTable().put("Second codec", meta.getAltCodec());
                        }
                    } else if (atomType.equals("stsz")) {
                        stream.skipBytes(4);
                        meta.setRawSize(stream.readInt());
                        meta.get(0).setAxisLength(Axes.TIME, (long)stream.readInt());
                        if (meta.getRawSize() == 0) {
                            stream.seek(stream.offset() - 4L);
                            int b = 0;
                            while ((long)b < meta.get(0).getAxisLength(Axes.TIME)) {
                                meta.getChunkSizes().add(stream.readInt());
                                ++b;
                            }
                        }
                    } else if (atomType.equals("stsc")) {
                        stream.skipBytes(4);
                        int numChunks = stream.readInt();
                        if (meta.getAltCodec() != null) {
                            int prevChunk = 0;
                            for (i = 0; i < numChunks; ++i) {
                                int chunk = stream.readInt();
                                int planesPerChunk = stream.readInt();
                                int id = stream.readInt();
                                if (id == 2) {
                                    meta.setAltPlanes(meta.getAltPlanes() + planesPerChunk * (chunk - prevChunk));
                                }
                                prevChunk = chunk;
                            }
                        }
                    } else if (atomType.equals("stts")) {
                        stream.skipBytes(12);
                        int fps = stream.readInt();
                        meta.getTable().put("Frames per second", fps);
                    }
                    if (oldpos + atomSize >= stream.length()) return;
                    stream.seek(oldpos + atomSize);
                }
                offset = atomSize == 0L ? stream.length() : (offset += atomSize);
                if (atomType.equals("udta")) {
                    offset += 4L;
                }
                NativeQTUtils.print(depth, atomSize, atomType, log);
            }
        }

        private static boolean isContainer(String type) {
            for (String CONTAINER_TYPE : CONTAINER_TYPES) {
                if (!type.equals(CONTAINER_TYPE)) continue;
                return true;
            }
            return false;
        }

        private static void print(int depth, long size, String type, LogService log) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append(" ");
            }
            sb.append(type + " : [" + size + "]");
            log.debug((Object)sb.toString());
        }

        private static byte[] uncompress(byte[] pixs, String code, Metadata meta) throws FormatException {
            AbstractCodec codec;
            CodecService codecService = (CodecService)meta.context().service(CodecService.class);
            MJPBCodecOptions options = new MJPBCodecOptions();
            options.width = (int)meta.get(0).getAxisLength(Axes.X);
            options.height = (int)meta.get(0).getAxisLength(Axes.Y);
            options.bitsPerSample = meta.getBitsPerPixel();
            options.channels = meta.getBitsPerPixel() < 40 ? meta.getBitsPerPixel() / 8 : (meta.getBitsPerPixel() - 32) / 8;
            options.previousImage = meta.isCanUsePrevious() ? meta.getPrevPixels() : null;
            options.littleEndian = meta.get(0).isLittleEndian();
            options.interleaved = meta.get(0).isMultichannel();
            if (code.equals("raw ")) {
                return pixs;
            }
            if (code.equals("rle ")) {
                codec = codecService.getCodec(QTRLECodec.class);
            } else if (code.equals("rpza")) {
                codec = codecService.getCodec(QTRLECodec.class);
            } else if (code.equals("mjpb")) {
                options.interlaced = meta.isInterlaced();
                codec = codecService.getCodec(MJPBCodec.class);
            } else if (code.equals("jpeg")) {
                codec = codecService.getCodec(JPEGCodec.class);
            } else {
                throw new UnsupportedCompressionException("Unsupported codec : " + code);
            }
            return codec.decompress(pixs, (CodecOptions)options);
        }

        private static void stripHeader(DataHandle<Location> stream) throws IOException {
            stream.seek(0L);
            while (!stream.readString(4).equals("moov")) {
                stream.seek(stream.offset() - 2L);
            }
            stream.seek(stream.offset() - 8L);
        }
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class NativeQTTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        public void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            dest.createImageMetadata(1);
            dest.get(0).setAxisLength(Axes.X, source.get(0).getAxisLength(Axes.X));
            dest.get(0).setAxisLength(Axes.Y, source.get(0).getAxisLength(Axes.Y));
            dest.get(0).setAxisLength(Axes.TIME, source.get(0).getPlaneCount());
            int bpp = FormatTools.getBitsPerPixel(source.get(0).getPixelType()) == 8 ? 8 : 16;
            dest.setBitsPerPixel(source.get(0).isMultichannel() ? bpp : bpp * 5);
        }
    }

    public static class Writer
    extends AbstractWriter<Metadata> {
        public static final int CODEC_MOTION_JPEG_B = 1835692130;
        public static final int CODEC_CINEPAK = 1668704612;
        public static final int CODEC_ANIMATION = 1919706400;
        public static final int CODEC_H_263 = 1748121139;
        public static final int CODEC_SORENSON = 1398165809;
        public static final int CODEC_SORENSON_3 = 1398165811;
        public static final int CODEC_MPEG_4 = 1836070006;
        public static final int CODEC_RAW = 0;
        public static final int QUALITY_LOW = 256;
        public static final int QUALITY_NORMAL = 512;
        public static final int QUALITY_HIGH = 768;
        public static final int QUALITY_MAXIMUM = 1023;
        private static final long BYTE_COUNT_OFFSET = 8L;
        @Parameter
        private QTJavaService qtJavaService;
        @Parameter
        private FormatService formatService;
        @Parameter
        private TranslatorService translatorService;
        @Parameter
        private DataHandleService dataHandleService;
        private int codec = 0;
        private int quality = 512;
        private int numBytes;
        private List<Integer> offsets;
        private int created;
        private int pad;
        private boolean needLegacy = false;
        private LegacyQTFormat.Writer legacy;
        private int numWritten = 0;

        @Override
        protected String[] makeCompressionTypes() {
            if (this.qtJavaService.canDoQT()) {
                return new String[]{CompressionType.UNCOMPRESSED.getCompression(), CompressionType.CINEPAK.getCompression(), CompressionType.ANIMATION.getCompression(), CompressionType.H_263.getCompression(), CompressionType.SORENSON.getCompression(), CompressionType.SORENSON_3.getCompression(), CompressionType.MPEG_4.getCompression()};
            }
            return new String[]{CompressionType.UNCOMPRESSED.getCompression()};
        }

        public void setCodec(int codec) {
            this.codec = codec;
        }

        public void setQuality(int quality) {
            this.quality = quality;
        }

        @Override
        protected void initialize(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
            if (!this.isInitialized(imageIndex, (int)planeIndex)) {
                this.setCodec();
                DataHandle<Location> handle = this.getHandle();
                if (this.codec != 0) {
                    this.needLegacy = true;
                    this.legacy.setDest(handle);
                    return;
                }
                Metadata meta = (Metadata)this.getMetadata();
                int height = (int)meta.get(imageIndex).getAxisLength(Axes.Y);
                this.numBytes = (int)((long)this.numBytes + (meta.get(imageIndex).getPlaneSize() + (long)(this.pad * height)));
                handle.seek(8L);
                handle.writeInt(this.numBytes + 8);
                handle.seek((long)this.offsets.get((int)planeIndex).intValue());
                if (!SCIFIOMetadataTools.wholePlane(imageIndex, meta, bounds)) {
                    handle.skipBytes((int)(meta.get(imageIndex).getPlaneSize() + (long)(this.pad * height)));
                }
            }
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
            byte[] buf = plane.getBytes();
            this.checkParams(imageIndex, planeIndex, buf, bounds);
            if (this.needLegacy) {
                this.legacy.savePlane(imageIndex, planeIndex, plane, bounds);
                return;
            }
            Metadata meta = (Metadata)this.getMetadata();
            boolean interleaved = plane.getImageMetadata().getInterleavedAxisCount() > 0;
            int width = (int)meta.get(imageIndex).getAxisLength(Axes.X);
            int nChannels = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            int xIndex = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xIndex);
            int y = (int)bounds.min(yIndex);
            int w = (int)bounds.dimension(xIndex);
            int h = (int)bounds.dimension(yIndex);
            this.getHandle().seek((long)(this.offsets.get((int)planeIndex) + y * (nChannels * width + this.pad)));
            byte[] tmp = new byte[buf.length];
            if (nChannels == 1 && !this.needLegacy) {
                for (int i = 0; i < buf.length; ++i) {
                    tmp[i] = (byte)(255 - buf[i]);
                }
            } else {
                System.arraycopy(buf, 0, tmp, 0, buf.length);
            }
            if (!interleaved) {
                byte[] tmp2 = new byte[tmp.length];
                System.arraycopy(tmp, 0, tmp2, 0, tmp.length);
                for (int i = 0; i < tmp.length; ++i) {
                    int c = i / (w * h);
                    int index = i % (w * h);
                    tmp[index * nChannels + c] = tmp2[i];
                }
            }
            int rowLen = tmp.length / h;
            for (int row = 0; row < h; ++row) {
                this.getHandle().skipBytes(nChannels * x);
                this.getHandle().write(tmp, row * rowLen, rowLen);
                for (int i = 0; i < this.pad; ++i) {
                    this.getHandle().writeByte(0);
                }
                if (row >= h - 1) continue;
                this.getHandle().skipBytes(nChannels * (width - w - x));
            }
            ++this.numWritten;
        }

        @Override
        public boolean canDoStacks() {
            return true;
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{1};
        }

        @Override
        public void close() throws IOException {
            if (this.getHandle() != null) {
                this.writeFooter();
            }
            super.close();
            this.numBytes = 0;
            this.created = 0;
            this.offsets = null;
            this.pad = 0;
            this.numWritten = 0;
        }

        @Override
        public void setDest(DataHandle<Location> stream, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            super.setDest(stream, imageIndex, config);
            Metadata meta = (Metadata)this.getMetadata();
            SCIFIOMetadataTools.verifyMinimumPopulated((io.scif.Metadata)meta, stream);
            int width = (int)meta.get(imageIndex).getAxisLength(Axes.X);
            int height = (int)meta.get(imageIndex).getAxisLength(Axes.Y);
            int nChannels = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            int planeSize = width * height * nChannels;
            int n = this.pad = nChannels > 1 ? 0 : (4 - width % 4) % 4;
            if (this.legacy == null) {
                LegacyQTFormat legacyFormat = this.formatService.getFormatFromClass(LegacyQTFormat.class);
                this.legacy = (LegacyQTFormat.Writer)legacyFormat.createWriter();
                io.scif.Metadata legacyMeta = legacyFormat.createMetadata();
                this.translatorService.translate(meta, legacyMeta, false);
                this.legacy.setMetadata(legacyMeta);
                this.legacy.setCodec(this.codec);
            }
            this.offsets = new ArrayList<Integer>();
            this.created = (int)System.currentTimeMillis();
            this.numBytes = 0;
            if (this.getHandle().length() == 0L) {
                this.writeAtom(8, "wide");
                this.writeAtom(this.numBytes + 8, "mdat");
            } else {
                this.getHandle().seek(8L);
                try (DataHandle tmp = (DataHandle)this.dataHandleService.create(stream.get());){
                    tmp.seek(8L);
                    this.numBytes = tmp.readInt() - 8;
                }
            }
            int i = 0;
            while ((long)i < meta.get(0).getPlaneCount()) {
                this.offsets.add(16 + i * (planeSize + this.pad * height));
                ++i;
            }
        }

        private void setCodec() {
            if (this.getCompression() == null) {
                return;
            }
            if (this.getCompression().equals("Uncompressed")) {
                this.codec = 0;
            } else if (this.getCompression().equals("Motion JPEG-B")) {
                this.codec = 1835692130;
            } else if (this.getCompression().equals("Cinepak")) {
                this.codec = 1668704612;
            } else if (this.getCompression().equals("Animation")) {
                this.codec = 1919706400;
            } else if (this.getCompression().equals("H.263")) {
                this.codec = 1748121139;
            } else if (this.getCompression().equals("Sorenson")) {
                this.codec = 1398165809;
            } else if (this.getCompression().equals("Sorenson 3")) {
                this.codec = 1398165811;
            } else if (this.getCompression().equals("MPEG 4")) {
                this.codec = 1836070006;
            }
        }

        private void writeFooter() throws IOException {
            int i;
            this.getHandle().seek(this.getHandle().length());
            Metadata meta = (Metadata)this.getMetadata();
            int width = (int)meta.get(0).getAxisLength(Axes.X);
            int height = (int)meta.get(0).getAxisLength(Axes.Y);
            int nChannels = (int)meta.get(0).getAxisLength(Axes.CHANNEL);
            int timeScale = 1000;
            int duration = (int)((double)this.numWritten * (1000.0 / (double)this.getFramesPerSecond()));
            int bitsPerPixel = nChannels > 1 ? 24 : 40;
            int channels = bitsPerPixel >= 40 ? 1 : 3;
            int atomLength = 685 + 8 * this.numWritten;
            this.writeAtom(atomLength, "moov");
            this.writeAtom(108, "mvhd");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(this.created);
            this.getHandle().writeInt((int)System.currentTimeMillis());
            this.getHandle().writeInt(1000);
            this.getHandle().writeInt(duration);
            this.getHandle().write(new byte[]{0, 1, 0, 0});
            this.getHandle().write(new byte[]{0, -1, 0, 0, 0, 0, 0, 0, 0, 0});
            this.writeRotationMatrix();
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(2);
            this.writeAtom(atomLength -= 116, "trak");
            this.writeAtom(92, "tkhd");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(15);
            this.getHandle().writeInt(this.created);
            this.getHandle().writeInt((int)System.currentTimeMillis());
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(duration);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(0);
            this.writeRotationMatrix();
            this.getHandle().writeInt(width);
            this.getHandle().writeInt(height);
            this.getHandle().writeShort(0);
            this.writeAtom(36, "edts");
            this.writeAtom(28, "elst");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(duration);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(1);
            this.getHandle().writeShort(0);
            this.writeAtom(atomLength -= 136, "mdia");
            this.writeAtom(32, "mdhd");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(this.created);
            this.getHandle().writeInt((int)System.currentTimeMillis());
            this.getHandle().writeInt(1000);
            this.getHandle().writeInt(duration);
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.writeAtom(58, "hdlr");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeBytes("mhlr");
            this.getHandle().writeBytes("vide");
            this.getHandle().writeBytes("appl");
            this.getHandle().write(new byte[]{16, 0, 0, 0, 0, 1, 1, 11, 25});
            this.getHandle().writeBytes("Apple Video Media Handler");
            this.writeAtom(atomLength -= 98, "minf");
            this.writeAtom(20, "vmhd");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(1);
            this.getHandle().writeShort(64);
            this.getHandle().writeShort(32768);
            this.getHandle().writeShort(32768);
            this.getHandle().writeShort(32768);
            this.writeAtom(57, "hdlr");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeBytes("dhlr");
            this.getHandle().writeBytes("alis");
            this.getHandle().writeBytes("appl");
            this.getHandle().write(new byte[]{16, 0, 0, 1, 0, 1, 1, 31, 24});
            this.getHandle().writeBytes("Apple Alias Data Handler");
            this.writeAtom(36, "dinf");
            this.writeAtom(28, "dref");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(1);
            this.getHandle().write(new byte[]{0, 0, 0, 12});
            this.getHandle().writeBytes("alis");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(1);
            this.writeAtom(atomLength -= 121, "stbl");
            this.writeAtom(118, "stsd");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(1);
            this.getHandle().write(new byte[]{0, 0, 0, 102});
            this.getHandle().writeBytes("raw ");
            this.getHandle().write(new byte[]{0, 0, 0, 0, 0, 0});
            this.getHandle().writeShort(1);
            this.getHandle().writeShort(1);
            this.getHandle().writeShort(1);
            this.getHandle().writeBytes("appl");
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(768);
            this.getHandle().writeShort(width);
            this.getHandle().writeShort(height);
            byte[] dpi = new byte[]{0, 72, 0, 0};
            this.getHandle().write(dpi);
            this.getHandle().write(dpi);
            this.getHandle().writeInt(0);
            this.getHandle().writeShort(1);
            this.getHandle().writeShort(12);
            this.getHandle().writeBytes("Uncompressed");
            this.getHandle().writeInt(bitsPerPixel);
            this.getHandle().writeInt(bitsPerPixel);
            this.getHandle().writeInt(bitsPerPixel);
            this.getHandle().writeInt(bitsPerPixel);
            this.getHandle().writeInt(bitsPerPixel);
            this.getHandle().writeShort(bitsPerPixel);
            this.getHandle().writeInt(65535);
            this.getHandle().write(new byte[]{12, 103, 97, 108});
            this.getHandle().write(new byte[]{97, 1, -52, -52, 0, 0, 0, 0});
            this.writeAtom(24, "stts");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(this.numWritten);
            this.getHandle().writeInt((int)(1000.0 / (double)this.getFramesPerSecond()));
            this.writeAtom(28, "stsc");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(1);
            this.writeAtom(20 + 4 * this.numWritten, "stsz");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(this.numWritten);
            for (i = 0; i < this.numWritten; ++i) {
                this.getHandle().writeInt(channels * height * (width + this.pad));
            }
            this.writeAtom(16 + 4 * this.numWritten, "stco");
            this.getHandle().writeShort(0);
            this.getHandle().writeShort(0);
            this.getHandle().writeInt(this.numWritten);
            for (i = 0; i < this.numWritten; ++i) {
                this.getHandle().writeInt(this.offsets.get(i).intValue());
            }
        }

        private void writeRotationMatrix() throws IOException {
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(1);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(0);
            this.getHandle().writeInt(16384);
        }

        private void writeAtom(int length, String type) throws IOException {
            this.getHandle().writeInt(length);
            this.getHandle().writeBytes(type);
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            byte[] t;
            Metadata meta = (Metadata)this.getMetadata();
            byte[] buf = (byte[])plane.getData();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, bounds);
            String code = meta.getCodec();
            if (planeIndex >= meta.get(imageIndex).getPlaneCount() - (long)meta.getAltPlanes()) {
                code = meta.altCodec;
            }
            int offset = meta.getOffsets().get((int)planeIndex);
            int nextOffset = (int)meta.getPixelBytes();
            meta.setScale(meta.getOffsets().get(0));
            offset -= meta.getScale();
            if (planeIndex < (long)(meta.getOffsets().size() - 1)) {
                nextOffset = meta.getOffsets().get((int)planeIndex + 1) - meta.getScale();
            }
            if (nextOffset - offset < 0) {
                int temp = offset;
                offset = nextOffset;
                nextOffset = temp;
            }
            byte[] pixs = new byte[nextOffset - offset];
            this.getHandle().seek(meta.getPixelOffset() + (long)offset);
            this.getHandle().read(pixs);
            meta.setCanUsePrevious(meta.getPrevPixels() != null && meta.getPrevPlane() == planeIndex - 1L && !code.equals(meta.getAltCodec()));
            byte[] byArray = t = meta.getPrevPlane() == planeIndex && meta.getPrevPixels() != null && !code.equals(meta.getAltCodec()) ? meta.getPrevPixels() : NativeQTUtils.uncompress(pixs, code, meta);
            if (code.equals("rpza")) {
                for (int i = 0; i < t.length; ++i) {
                    t[i] = (byte)(255 - t[i]);
                }
                meta.setPrevPlane((int)planeIndex);
                return plane;
            }
            if (meta.isCanUsePrevious() && meta.getPrevPixels().length < t.length) {
                byte[] temp = t;
                t = new byte[meta.getPrevPixels().length];
                System.arraycopy(temp, 0, t, 0, t.length);
            }
            meta.setPrevPixels(t);
            meta.setPrevPlane(planeIndex);
            int bytes = meta.getBitsPerPixel() < 40 ? meta.getBitsPerPixel() / 8 : (meta.getBitsPerPixel() - 32) / 8;
            int pad = (4 - (int)(meta.get(imageIndex).getAxisLength(Axes.X) % 4L)) % 4;
            if (meta.getCodec().equals("mjpb")) {
                pad = 0;
            }
            int expectedSize = (int)FormatTools.getPlaneSize(this, imageIndex);
            if (meta.getPrevPixels().length == expectedSize || meta.getBitsPerPixel() == 32 && 3 * (meta.getPrevPixels().length / 4) == expectedSize) {
                pad = 0;
            }
            if (pad > 0) {
                t = new byte[meta.getPrevPixels().length - (int)meta.get(imageIndex).getAxisLength(Axes.Y) * pad];
                int row = 0;
                while ((long)row < meta.get(imageIndex).getAxisLength(Axes.Y)) {
                    int sourceIndex = row * (bytes * (int)meta.get(imageIndex).getAxisLength(Axes.X) + pad);
                    int destIndex = row * (int)meta.get(imageIndex).getAxisLength(Axes.X) * bytes;
                    int length = (int)meta.get(imageIndex).getAxisLength(Axes.X) * bytes;
                    System.arraycopy(meta.getPrevPixels(), sourceIndex, t, destIndex, length);
                    ++row;
                }
            }
            int bpp = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xAxis);
            int y = (int)bounds.min(yAxis);
            int w = (int)bounds.dimension(xAxis);
            int h = (int)bounds.dimension(yAxis);
            int srcRowLen = (int)(meta.get(imageIndex).getAxisLength(Axes.X) * (long)bpp * meta.get(imageIndex).getAxisLength(Axes.CHANNEL));
            int destRowLen = w * bpp * (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            for (int row = 0; row < h; ++row) {
                if (meta.getBitsPerPixel() == 32) {
                    for (int col = 0; col < w; ++col) {
                        int src = (row + y) * (int)meta.get(imageIndex).getAxisLength(Axes.X) * bpp * 4 + (x + col) * bpp * 4 + 1;
                        int dst = row * destRowLen + col * bpp * 3;
                        if (src + 3 > t.length || dst + 3 > buf.length) continue;
                        System.arraycopy(t, src, buf, dst, 3);
                    }
                    continue;
                }
                System.arraycopy(t, row * srcRowLen + x * bpp * (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL), buf, row * destRowLen, destRowLen);
            }
            if (!(meta.getBitsPerPixel() != 40 && meta.getBitsPerPixel() != 8 || code.equals("mjpb"))) {
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(255 - buf[i]);
                }
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Parameter
        DataHandleService dataHandleService;

        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            meta.setSpork(true);
            ArrayList<Integer> offsets = new ArrayList<Integer>();
            ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
            meta.setOffsets(offsets);
            meta.setChunkSizes(chunkSizes);
            meta.createImageMetadata(1);
            this.log().info((Object)"Parsing tags");
            NativeQTUtils.parse((DataHandle<Location>)stream, meta, 0, 0L, stream.length(), this.log());
            ImageMetadata iMeta = meta.get(0);
            iMeta.setPlanarAxisCount(2);
            iMeta.setAxisLength(Axes.TIME, (long)offsets.size());
            if ((long)chunkSizes.size() < iMeta.getPlaneCount() && chunkSizes.size() > 0) {
                iMeta.setAxisLength(Axes.TIME, (long)chunkSizes.size());
            }
            this.log().info((Object)"Populating metadata");
            Location baseLocation = (Location)stream.get();
            String id = baseLocation.getName();
            if (meta.isSpork()) {
                if (!(baseLocation instanceof BrowsableLocation)) {
                    throw new IOException("Can not open sporked QT file from an not browsable location!");
                }
                BrowsableLocation browsableBaseLoc = (BrowsableLocation)baseLocation;
                String base = null;
                base = id.contains(".") ? id.substring(0, id.lastIndexOf(46)) : id;
                BrowsableLocation f = browsableBaseLoc.sibling(base + ".qtr");
                this.log().debug((Object)"Searching for research fork:");
                if (this.dataHandleService.exists((Location)f)) {
                    this.log().debug((Object)("\t Found: " + f));
                    if (this.getSource() != null) {
                        this.getSource().close();
                    }
                    this.updateSource((Location)f);
                    NativeQTUtils.stripHeader((DataHandle<Location>)stream);
                    NativeQTUtils.parse((DataHandle<Location>)stream, meta, 0, 0L, this.getSource().length(), this.log());
                    meta.get(0).setAxisLength(Axes.TIME, (long)offsets.size());
                } else {
                    this.log().debug((Object)("\tAbsent: " + f));
                    f = browsableBaseLoc.sibling("._" + base);
                    if (this.dataHandleService.exists((Location)f)) {
                        this.log().debug((Object)("\t Found: " + f));
                        this.parseLocation(meta, offsets, (Location)f);
                    } else {
                        this.log().debug((Object)("\tAbsent: " + f));
                        f = browsableBaseLoc.sibling(File.separator + ".." + File.separator + "namedfork" + File.separator + "rsrc");
                        if (this.dataHandleService.exists((Location)f)) {
                            this.log().debug((Object)("\t Found: " + f));
                            this.parseLocation(meta, offsets, (Location)f);
                        } else {
                            this.log().debug((Object)("\tAbsent: " + f));
                            throw new FormatException("QuickTime resource fork not found.  To avoid this issue, please flatten your QuickTime movies before importing with SCIFIO.");
                        }
                    }
                }
            }
        }

        private void parseLocation(Metadata meta, List<Integer> offsets, Location f) throws IOException, FormatException {
            try (DataHandle tmpStream = (DataHandle)this.dataHandleService.create((Object)f);){
                NativeQTUtils.stripHeader((DataHandle<Location>)tmpStream);
                NativeQTUtils.parse((DataHandle<Location>)tmpStream, meta, 0, tmpStream.offset(), tmpStream.length(), this.log());
                meta.get(0).setAxisLength(Axes.TIME, (long)offsets.size());
            }
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean isFormat(DataHandle<Location> stream) throws IOException {
            int blockLen = 64;
            if (!FormatTools.validStream(stream, 64, false)) {
                return false;
            }
            String s = stream.readString(64);
            for (String CONTAINER_TYPE : CONTAINER_TYPES) {
                if (!s.contains(CONTAINER_TYPE) || CONTAINER_TYPE.equals("imag")) continue;
                return true;
            }
            return s.contains("wide") || s.contains("mdat") || s.contains("ftypqt");
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private long pixelOffset;
        private long pixelBytes;
        private int bitsPerPixel;
        private int rawSize;
        private List<Integer> offsets;
        private byte[] prevPixels;
        private long prevPlane;
        private boolean canUsePrevious;
        private String codec;
        private String altCodec;
        private int altPlanes;
        private int scale;
        private List<Integer> chunkSizes;
        private boolean interlaced;
        private boolean spork;
        private boolean flip;

        public long getPixelOffset() {
            return this.pixelOffset;
        }

        public void setPixelOffset(long pixelOffset) {
            this.pixelOffset = pixelOffset;
        }

        public long getPixelBytes() {
            return this.pixelBytes;
        }

        public void setPixelBytes(long pixelBytes) {
            this.pixelBytes = pixelBytes;
        }

        public int getBitsPerPixel() {
            return this.bitsPerPixel;
        }

        public void setBitsPerPixel(int bitsPerPixel) {
            this.bitsPerPixel = bitsPerPixel;
        }

        public int getRawSize() {
            return this.rawSize;
        }

        public void setRawSize(int rawSize) {
            this.rawSize = rawSize;
        }

        public List<Integer> getOffsets() {
            return this.offsets;
        }

        public void setOffsets(List<Integer> offsets) {
            this.offsets = offsets;
        }

        public byte[] getPrevPixels() {
            return this.prevPixels;
        }

        public void setPrevPixels(byte[] prevPixels) {
            this.prevPixels = prevPixels;
        }

        public long getPrevPlane() {
            return this.prevPlane;
        }

        public void setPrevPlane(long prevPlane) {
            this.prevPlane = prevPlane;
        }

        public boolean isCanUsePrevious() {
            return this.canUsePrevious;
        }

        public void setCanUsePrevious(boolean canUsePrevious) {
            this.canUsePrevious = canUsePrevious;
        }

        public String getCodec() {
            return this.codec;
        }

        public void setCodec(String codec) {
            this.codec = codec;
        }

        public String getAltCodec() {
            return this.altCodec;
        }

        public void setAltCodec(String altCodec) {
            this.altCodec = altCodec;
        }

        public int getAltPlanes() {
            return this.altPlanes;
        }

        public void setAltPlanes(int altPlanes) {
            this.altPlanes = altPlanes;
        }

        public int getScale() {
            return this.scale;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }

        public List<Integer> getChunkSizes() {
            return this.chunkSizes;
        }

        public void setChunkSizes(List<Integer> chunkSizes) {
            this.chunkSizes = chunkSizes;
        }

        public boolean isInterlaced() {
            return this.interlaced;
        }

        public void setInterlaced(boolean interlaced) {
            this.interlaced = interlaced;
        }

        public boolean isSpork() {
            return this.spork;
        }

        public void setSpork(boolean spork) {
            this.spork = spork;
        }

        public boolean isFlip() {
            return this.flip;
        }

        public void setFlip(boolean flip) {
            this.flip = flip;
        }

        @Override
        public void populateImageMetadata() {
            int bytes;
            ImageMetadata iMeta = this.get(0);
            if (this.getBitsPerPixel() < 40) {
                iMeta.setPlanarAxisCount(3);
                iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y, Axes.TIME);
                iMeta.setAxisLength(Axes.CHANNEL, 3L);
            }
            iMeta.setPixelType((bytes = this.getBitsPerPixel() / 8 % 4) == 2 ? 3 : 1);
            iMeta.setBitsPerPixel(FormatTools.getBitsPerPixel(iMeta.getPixelType()));
            iMeta.setLittleEndian(false);
            iMeta.setMetadataComplete(true);
            iMeta.setIndexed(false);
            iMeta.setFalseColor(false);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.offsets = null;
                this.prevPixels = null;
                this.altCodec = null;
                this.codec = null;
                this.rawSize = 0;
                this.bitsPerPixel = 0;
                this.pixelOffset = this.pixelBytes = (long)0;
                this.altPlanes = 0;
                this.prevPlane = 0;
                this.canUsePrevious = false;
                this.scale = 0;
                this.chunkSizes = null;
                this.flip = false;
                this.spork = false;
                this.interlaced = false;
            }
        }
    }
}

