/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

public class TiffRational
extends Number
implements Comparable<TiffRational> {
    private long numer;
    private long denom;

    public TiffRational(long numer, long denom) {
        this.numer = numer;
        this.denom = denom;
    }

    public long getNumerator() {
        return this.numer;
    }

    public long getDenominator() {
        return this.denom;
    }

    public void reduce() {
        long gcdMax;
        for (long i = gcdMax = (sqrt1 = (long)Math.sqrt(this.numer)) < (sqrt2 = (long)Math.sqrt(this.denom)) ? sqrt1 : sqrt2; i >= 2L; --i) {
            if (this.numer % i != 0L || this.denom % i != 0L) continue;
            this.numer /= i;
            this.denom /= i;
            this.reduce();
            break;
        }
    }

    @Override
    public byte byteValue() {
        return (byte)this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.denom == 0L ? Double.MAX_VALUE : (double)this.numer / (double)this.denom;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.denom == 0L ? Long.MAX_VALUE : this.numer / this.denom;
    }

    @Override
    public short shortValue() {
        return (short)this.longValue();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof TiffRational && this.compareTo((TiffRational)o) == 0;
    }

    public int hashCode() {
        return (int)(this.numer - this.denom);
    }

    public String toString() {
        return this.numer + "/" + this.denom;
    }

    @Override
    public int compareTo(TiffRational q) {
        long diff = this.numer * q.denom - q.numer * this.denom;
        if (diff > Integer.MAX_VALUE) {
            diff = Integer.MAX_VALUE;
        } else if (diff < Integer.MIN_VALUE) {
            diff = Integer.MIN_VALUE;
        }
        return (int)diff;
    }
}

