/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.ImageMetadata;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.util.FormatTools;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.type.numeric.integer.GenericByteType;

public class CharArrayLoader
extends AbstractArrayLoader<CharArray> {
    public CharArrayLoader(Reader reader, ImageRegion subRegion) {
        super(reader, subRegion);
    }

    @Override
    public void convertBytes(CharArray data, byte[] bytes, int planesRead) {
        ImageMetadata iMeta = this.reader().getMetadata().get(0);
        if (this.isCompatible()) {
            int offset = planesRead * bytes.length;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(iMeta.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            bb.asCharBuffer().get(data.getCurrentStorageArray(), offset, bytes.length);
        } else {
            int pixelType = iMeta.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            int offset = planesRead * (bytes.length / bpp);
            for (int index = 0; index < bytes.length / bpp; ++index) {
                char value = (char)this.utils().decodeWord(bytes, index * bpp, pixelType, iMeta.isLittleEndian());
                data.setValue(offset + index, value);
            }
        }
    }

    @Override
    public CharArray emptyArray(int entities) {
        return new CharArray(entities);
    }

    @Override
    public int getBitsPerElement() {
        return 8;
    }

    @Override
    public Class<?> outputClass() {
        return GenericByteType.class;
    }
}

