/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2;

import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ini.trakem2.ControlWindow;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Connector;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Dissector;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Stack;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.DBLoader;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.Loader;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.plugin.TPlugIn;
import ini.trakem2.tree.DNDTree;
import ini.trakem2.tree.LayerThing;
import ini.trakem2.tree.LayerTree;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.ProjectTree;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.TemplateTree;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Search;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpicbg.trakem2.transform.DTD;

public class Project
extends DBObject {
    private static final Vector<PlugInSource> PLUGIN_SOURCES;
    private Map<PlugInSource, TPlugIn> plugins = null;
    private static ArrayList<Project> al_open_projects;
    private Loader loader;
    private TemplateTree template_tree = null;
    private ProjectTree project_tree = null;
    private ProjectThing root_pt;
    private LayerThing root_lt;
    private TemplateThing root_tt;
    private LayerSet layer_set;
    private static TemplateThing layer_template;
    private static TemplateThing layer_set_template;
    private final Map<String, TemplateThing> ht_unique_tt = Collections.synchronizedMap(new HashMap());
    private LayerTree layer_tree = null;
    private String title = "Project";
    private final HashMap<String, String> ht_props = new HashMap();
    private int mipmaps_mode = 6;
    private ScheduledFuture<?> autosaving = null;
    private final Map<Object, ProjectThing> ptcache = new HashMap<Object, ProjectThing>();
    private boolean input_disabled = false;
    private int first_mipmap_level_saved = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<PlugInSource, TPlugIn> createPlugins() {
        Map<PlugInSource, TPlugIn> m = Collections.synchronizedMap(new TreeMap());
        Vector<PlugInSource> vector = PLUGIN_SOURCES;
        synchronized (vector) {
            for (PlugInSource source : PLUGIN_SOURCES) {
                try {
                    m.put(source, (TPlugIn)source.c.newInstance());
                }
                catch (Exception e) {
                    Utils.log("ERROR initializing plugin!\nParsed tokens: [" + source.menu + "][" + source.title + "][" + source.c.getName() + "]");
                    IJError.print(e);
                }
            }
        }
        return m;
    }

    public synchronized TreeMap<String, TPlugIn> getPlugins(String menu) {
        TreeMap<String, TPlugIn> m = new TreeMap<String, TPlugIn>();
        if (null == this.plugins) {
            this.plugins = this.createPlugins();
        }
        for (Map.Entry<PlugInSource, TPlugIn> e : this.plugins.entrySet()) {
            if (!e.getKey().menu.equals(menu)) continue;
            m.put(e.getKey().title, e.getValue());
        }
        return m;
    }

    private Project(Loader loader) {
        super(loader);
        ControlWindow.getInstance();
        this.loader = loader;
        this.project = this;
        loader.addToDatabase(this);
    }

    public Project(long id, String title) {
        super(null, id);
        ControlWindow.getInstance();
        this.title = title;
        this.project = this;
    }

    private void restartAutosaving() {
        int interval_in_minutes;
        if (null != this.autosaving) {
            try {
                this.autosaving.cancel(true);
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
        if (0 == (interval_in_minutes = this.getProperty("autosaving_interval", 0))) {
            return;
        }
        this.autosaving = FSLoader.autosaver.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Project.this.loader.hasChanges()) {
                        Bureaucrat.createAndStart((Worker)new Worker.Task("auto-saving"){

                            @Override
                            public void exec() {
                                Project.this.save();
                            }
                        }, Project.this).join();
                    }
                }
                catch (Throwable e) {
                    Utils.log("*** Autosaver failed:");
                    IJError.print(e);
                }
            }
        }, interval_in_minutes * 60, interval_in_minutes * 60, TimeUnit.SECONDS);
    }

    public static Project getProject(String title) {
        for (Project pr : al_open_projects) {
            if (!pr.title.equals(title)) continue;
            return pr;
        }
        return null;
    }

    public static ArrayList<Project> getProjects() {
        return new ArrayList<Project>(al_open_projects);
    }

    public static Project newDBProject() {
        if (Utils.wrongImageJVersion()) {
            return null;
        }
        DBLoader loader = new DBLoader();
        if (!loader.isReady()) {
            return null;
        }
        if (!loader.isConnected()) {
            Utils.showMessage("Can't talk to database.");
            return null;
        }
        return Project.createNewProject(loader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Project openDBProject() {
        if (Utils.wrongImageJVersion()) {
            return null;
        }
        DBLoader loader = new DBLoader();
        if (!loader.isReady()) {
            return null;
        }
        if (!loader.isConnected()) {
            Utils.showMessage("Can't talk to database.");
            loader.destroy();
            return null;
        }
        Project[] projects = loader.getProjects();
        if (null == projects) {
            Utils.showMessage("Can't talk to database (null list of projects).");
            loader.destroy();
            return null;
        }
        Project project = null;
        if (0 == projects.length) {
            Utils.showMessage("No projects in this database.");
            loader.destroy();
            return null;
        }
        if (1 == projects.length) {
            project = projects[0];
        } else {
            void var4_5;
            String[] titles = new String[projects.length];
            boolean bl = false;
            while (var4_5 < projects.length) {
                titles[var4_5] = projects[var4_5].title;
                ++var4_5;
            }
            GenericDialog genericDialog = new GenericDialog("Choose");
            genericDialog.addMessage("Choose project to open:");
            genericDialog.addChoice("project: ", titles, (String)titles[titles.length - 1]);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                loader.destroy();
                return null;
            }
            project = projects[genericDialog.getNextChoiceIndex()];
        }
        for (Project project2 : al_open_projects) {
            if (!loader.isIdenticalProjectSource(project2.loader) || project2.id != project.id || !project2.title.equals(project.title)) continue;
            Utils.showMessage("A project with title " + project2.title + " and id " + project2.id + " from the same database is already open.");
            loader.destroy();
            return null;
        }
        project.loader = loader;
        TemplateThing template_root = loader.getTemplateRoot(project);
        if (null == template_root) {
            Utils.showMessage("Failed to retrieve the template tree.");
            project.destroy();
            return null;
        }
        project.template_tree = new TemplateTree(project, template_root);
        Map<String, TemplateThing> map = project.ht_unique_tt;
        synchronized (map) {
            project.ht_unique_tt.clear();
            project.ht_unique_tt.putAll(template_root.getUniqueTypes(new HashMap<String, TemplateThing>()));
        }
        HashMap<Long, Displayable> hashMap = new HashMap<Long, Displayable>();
        try {
            TemplateThing project_template = new TemplateThing("project");
            project.ht_unique_tt.put("project", project_template);
            project_template.addChild(template_root);
            project.root_pt = loader.getRootProjectThing(project, template_root, project_template, hashMap);
            project.root_pt.setup();
        }
        catch (Exception e) {
            Utils.showMessage("Failed to retrieve the Thing tree for the project.");
            IJError.print(e);
            project.destroy();
            return null;
        }
        project.project_tree = new ProjectTree(project, project.root_pt);
        loader.restoreNodesExpandedState(project);
        project.createLayerTemplates();
        LayerThing root_layer_thing = null;
        try {
            root_layer_thing = loader.getRootLayerThing(project, project.root_pt, layer_set_template, layer_template);
            if (null == root_layer_thing) {
                project.destroy();
                Utils.showMessage("Could not retrieve the root layer thing.");
                return null;
            }
            root_layer_thing.setup();
            project.layer_set = (LayerSet)root_layer_thing.getObject();
            if (null == project.layer_set) {
                project.destroy();
                Utils.showMessage("Could not retrieve the root layer set.");
                return null;
            }
            project.layer_set.setup();
            project.layer_tree = new LayerTree(project, root_layer_thing);
            project.root_lt = root_layer_thing;
        }
        catch (Exception e) {
            Utils.showMessage("Failed to retrieve the Layer tree for the project.");
            IJError.print(e);
            project.destroy();
            return null;
        }
        al_open_projects.add(project);
        ControlWindow.add(project, project.template_tree, project.project_tree, project.layer_tree);
        Display.openLater();
        return project;
    }

    public static Project newFSProject(String arg) {
        return Project.newFSProject(arg, null);
    }

    public static Project newFSProject(String arg, TemplateThing template_root) {
        return Project.newFSProject(arg, null, null);
    }

    public static Project newFSProject(String arg, TemplateThing template_root, String storage_folder) {
        return Project.newFSProject(arg, template_root, storage_folder, true);
    }

    public static Project newFSProject(String arg, TemplateThing template_root, String storage_folder, boolean autocreate_one_layer) {
        if (Utils.wrongImageJVersion()) {
            return null;
        }
        FSLoader loader = null;
        try {
            String dir_project = storage_folder;
            if (null == dir_project || !new File(dir_project).isDirectory()) {
                DirectoryChooser dc = new DirectoryChooser("Select storage folder");
                dir_project = dc.getDirectory();
                if (null == dir_project) {
                    return null;
                }
                if (!Loader.canReadAndWriteTo(dir_project)) {
                    Utils.showMessage("Can't read/write to the selected storage folder.\nPlease check folder permissions.");
                    return null;
                }
                if (IJ.isWindows()) {
                    dir_project = dir_project.replace('\\', '/');
                }
            }
            loader = new FSLoader(dir_project);
            Project project = Project.createNewProject(loader, !"blank".equals(arg) && !"amira".equals(arg), template_root);
            if (autocreate_one_layer && null != project && ControlWindow.isGUIEnabled()) {
                Utils.log2("Creating automatic Display.");
                Layer layer = new Layer(project, 0.0, 1.0, project.layer_set);
                project.layer_set.add(layer);
                project.layer_tree.addLayer(project.layer_set, layer);
                layer.recreateBuckets();
                Display.createDisplay(project, layer);
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            if ("amira".equals(arg) || "stack".equals(arg)) {
                loader.importStack(project.layer_set.getLayer(0), null, true);
            }
            project.restartAutosaving();
            return project;
        }
        catch (Exception e) {
            IJError.print(e);
            if (null != loader) {
                loader.destroy();
            }
            return null;
        }
    }

    public static Project openFSProject(String path) {
        return Project.openFSProject(path, true);
    }

    public static synchronized Project openFSProject(String path, boolean open_displays) {
        if (Utils.wrongImageJVersion()) {
            return null;
        }
        FSLoader loader = new FSLoader();
        Object[] data = loader.openFSProject(path, open_displays);
        if (null == data) {
            loader.destroy();
            return null;
        }
        TemplateThing root_tt = (TemplateThing)data[0];
        ProjectThing root_pt = (ProjectThing)data[1];
        LayerThing root_lt = (LayerThing)data[2];
        HashMap ht_pt_expanded = (HashMap)data[3];
        final Project project = (Project)root_pt.getObject();
        project.createLayerTemplates();
        project.template_tree = new TemplateTree(project, root_tt);
        project.root_tt = root_tt;
        project.root_pt = root_pt;
        project.project_tree = new ProjectTree(project, project.root_pt);
        project.layer_tree = new LayerTree(project, root_lt);
        project.root_lt = root_lt;
        project.layer_set = (LayerSet)root_lt.getObject();
        al_open_projects.add(project);
        ControlWindow.add(project, project.template_tree, project.project_tree, project.layer_tree);
        try {
            Field f = JTree.class.getDeclaredField("expandedState");
            f.setAccessible(true);
            Hashtable ht_exp = (Hashtable)f.get(project.project_tree);
            for (Map.Entry entry : ht_pt_expanded.entrySet()) {
                ProjectThing pt = (ProjectThing)entry.getKey();
                Boolean expanded = (Boolean)entry.getValue();
                DefaultMutableTreeNode nd = DNDTree.findNode(pt, project.project_tree);
                if (null == nd) {
                    Utils.log2("Can't find node for " + pt);
                    continue;
                }
                ht_exp.put(new TreePath(nd.getPath()), expanded);
            }
            project.project_tree.updateUILater();
        }
        catch (Exception e) {
            IJError.print(e);
        }
        if (open_displays) {
            final Bureaucrat burro = Display.openLater();
            if (null != burro) {
                final Runnable ru = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            burro.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        project.loader.setChanged(false);
                        Utils.log2("C set to false");
                    }
                };
                new Thread(){

                    @Override
                    public void run() {
                        this.setPriority(5);
                        try {
                            SwingUtilities.invokeAndWait(ru);
                        }
                        catch (Exception e) {
                            Utils.log2("ERROR: " + e);
                        }
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(4000L);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    project.getLoader().setChanged(false);
                                    Utils.log2("D set to false");
                                }
                            });
                            project.getTemplateTree().updateUILater();
                            project.getProjectTree().updateUILater();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            } else {
                Display.createDisplay(project, project.layer_set.getLayer(0));
            }
        }
        project.restartAutosaving();
        return project;
    }

    private static Project createNewProject(Loader loader, boolean ask_for_template) {
        return Project.createNewProject(loader, ask_for_template, null);
    }

    private static Project createNewProject(Loader loader, boolean ask_for_template, TemplateThing template_root) {
        return Project.createNewProject(loader, ask_for_template, template_root, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Project createNewProject(Loader loader, boolean ask_for_template, TemplateThing template_root, boolean clone_ids) {
        Project project = new Project(loader);
        if (ask_for_template) {
            template_root = project.loader.askForXMLTemplate(project);
        }
        if (null == template_root) {
            template_root = new TemplateThing("anything");
        } else if (clone_ids) {
            template_root = template_root.clone(project, true);
        }
        project.template_tree = new TemplateTree(project, template_root);
        project.root_tt = template_root;
        Map<String, TemplateThing> map = project.ht_unique_tt;
        synchronized (map) {
            project.ht_unique_tt.clear();
            project.ht_unique_tt.putAll(template_root.getUniqueTypes(new HashMap<String, TemplateThing>()));
        }
        if (!clone_ids) {
            template_root.addToDatabase(project);
        }
        TemplateThing project_template = new TemplateThing("project");
        project.ht_unique_tt.put("project", project_template);
        project_template.addChild(template_root);
        try {
            project.root_pt = new ProjectThing(project_template, project, project);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        project.project_tree = new ProjectTree(project, project.root_pt);
        project.createLayerTemplates();
        project.layer_set = new LayerSet(project, "Top Level", 0.0, 0.0, null, 2048.0f, 2048.0f);
        try {
            project.root_lt = new LayerThing(layer_set_template, project, project.layer_set);
            project.layer_tree = new LayerTree(project, project.root_lt);
        }
        catch (Exception e) {
            project.remove();
            IJError.print(e);
        }
        ControlWindow.add(project, project.template_tree, project.project_tree, project.layer_tree);
        al_open_projects.add(project);
        return project;
    }

    public void setTempLoader(Loader loader) {
        if (null == this.loader) {
            this.loader = loader;
        } else {
            Utils.log2("Project.setTempLoader: already have one.");
        }
    }

    public final Loader getLoader() {
        return this.loader;
    }

    public String save() {
        Thread.yield();
        XMLOptions options = new XMLOptions();
        options.overwriteXMLFile = true;
        options.export_images = false;
        options.patches_dir = null;
        options.include_coordinate_transform = true;
        String path = this.loader.save(this, options);
        if (null != path) {
            this.restartAutosaving();
        }
        return path;
    }

    public String saveAs(String xml_path, boolean overwrite) throws IllegalArgumentException {
        if (null == xml_path) {
            throw new IllegalArgumentException("xml_path cannot be null.");
        }
        XMLOptions options = new XMLOptions();
        options.overwriteXMLFile = overwrite;
        options.export_images = false;
        options.patches_dir = null;
        options.include_coordinate_transform = true;
        String path = this.loader.saveAs(xml_path, options);
        if (null != path) {
            this.restartAutosaving();
        }
        return path;
    }

    public String saveWithoutCoordinateTransforms() {
        XMLOptions options = new XMLOptions();
        options.overwriteXMLFile = false;
        options.export_images = false;
        options.include_coordinate_transform = false;
        options.patches_dir = null;
        return this.loader.saveAs(this, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        if (null == this.loader) {
            return true;
        }
        if (this.loader.hasChanges() && !this.getBooleanProperty("no_shutdown_hook")) {
            if (ControlWindow.isGUIEnabled()) {
                YesNoDialog yn = ControlWindow.makeYesNoDialog("TrakEM2", "There are unsaved changes in project " + this.title + ".\nSave them?");
                if (yn.yesPressed()) {
                    this.save();
                }
            } else {
                Utils.log2("WARNING: closing project '" + this.title + "' with unsaved changes.");
            }
        }
        try {
            if (null != this.autosaving) {
                this.autosaving.cancel(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        al_open_projects.remove(this);
        if (null != this.loader) {
            this.loader.destroy();
            this.loader = null;
        }
        if (null != this.layer_set) {
            this.layer_set.destroy();
        }
        ControlWindow.remove(this);
        if (null != this.template_tree) {
            this.template_tree.destroy();
        }
        if (null != this.project_tree) {
            this.project_tree.destroy();
        }
        if (null != this.layer_tree) {
            this.layer_tree.destroy();
        }
        Polyline.flushTraceCache(this);
        this.template_tree = null;
        Display.close(this);
        Search.removeTabs(this);
        Map<Object, ProjectThing> map = this.ptcache;
        synchronized (map) {
            this.ptcache.clear();
        }
        return true;
    }

    public boolean isBeingDestroyed() {
        return null == this.template_tree;
    }

    public void remove() {
        this.removeFromDatabase();
        this.destroy();
    }

    @Override
    public boolean remove(boolean check) {
        if (!Utils.check("Delete the project " + this.toString() + " from the database?")) {
            return false;
        }
        this.removeFromDatabase();
        this.destroy();
        return true;
    }

    public void setTitle(String title) {
        if (null == title) {
            return;
        }
        this.title = title;
        ControlWindow.updateTitle(this);
        this.loader.updateInDatabase((DBObject)this, "title");
    }

    public String toString() {
        if (null == this.title || this.title.equals("Project")) {
            try {
                return this.loader.makeProjectName();
            }
            catch (Exception e) {
                Utils.log2("Swing again.");
            }
        }
        return this.title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public TemplateTree getTemplateTree() {
        return this.template_tree;
    }

    public LayerTree getLayerTree() {
        return this.layer_tree;
    }

    public ProjectTree getProjectTree() {
        return this.project_tree;
    }

    public Object makeObject(TemplateThing tt) {
        String type = tt.getType();
        if (type.equals("profile")) {
            ProjectToolbar.setTool(15);
            return new Profile(this, "profile", 0.0, 0.0);
        }
        if (type.equals("pipe")) {
            ProjectToolbar.setTool(16);
            return new Pipe(this, "pipe", 0.0, 0.0);
        }
        if (type.equals("polyline")) {
            ProjectToolbar.setTool(16);
            return new Polyline(this, "polyline");
        }
        if (type.equals("area_list")) {
            ProjectToolbar.setTool(17);
            return new AreaList(this, "area_list", 0.0, 0.0);
        }
        if (type.equals("treeline")) {
            ProjectToolbar.setTool(16);
            return new Treeline(this, "treeline");
        }
        if (type.equals("areatree")) {
            ProjectToolbar.setTool(16);
            return new AreaTree(this, "areatree");
        }
        if (type.equals("ball")) {
            ProjectToolbar.setTool(16);
            return new Ball(this, "ball", 0.0, 0.0);
        }
        if (type.equals("connector")) {
            ProjectToolbar.setTool(16);
            return new Connector(this, "connector");
        }
        if (type.equals("dissector")) {
            ProjectToolbar.setTool(16);
            return new Dissector(this, "dissector", 0.0, 0.0);
        }
        if (type.equals("label")) {
            return new DLabel(this, "  ", 0.0, 0.0);
        }
        return type;
    }

    public static boolean isBasicType(String type) {
        return Project.isProjectType(type) || Project.isLayerSetType(type) || Project.isLayerType(type);
    }

    public static boolean isProjectType(String type) {
        type = type.toLowerCase();
        return type.equals("profile_list");
    }

    public static boolean isLayerSetType(String type) {
        return (type = type.toLowerCase().replace(' ', '_')).equals("area_list") || type.equals("pipe") || type.equals("ball") || type.equals("polyline") || type.equals("dissector") || type.equals("stack") || type.equals("treeline") || type.equals("areatree") || type.equals("connector");
    }

    public static boolean isLayerType(String type) {
        return (type = type.toLowerCase().replace(' ', '_')).equals("patch") || type.equals("profile") || type.equals("layer") || type.equals("layer_set") || type.equals("label");
    }

    public boolean removeProjectThing(Object object, boolean check) {
        return this.removeProjectThing(object, check, false, 0);
    }

    public boolean removeProjectThing(Object object, boolean check, boolean remove_empty_parents, int levels) {
        if (levels < 0) {
            Utils.log2("Project.removeProjectThing: levels must be zero or above.");
            return false;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.project_tree.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        DefaultMutableTreeNode node = null;
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            Object ob = node.getUserObject();
            if (!(ob instanceof ProjectThing) || ((ProjectThing)ob).getObject() != object) continue;
            if (check && !Utils.check("Remove " + object.toString() + "?")) {
                return false;
            }
            this.project_tree.remove(node, false, remove_empty_parents, levels);
            return true;
        }
        return false;
    }

    public void select(Layer layer) {
        this.layer_tree.selectNode(layer);
    }

    public void select(Displayable d) {
        if (d.getClass() == LayerSet.class) {
            this.select(d, this.layer_tree);
        } else {
            ProjectThing pt = this.findProjectThing(d);
            if (null != pt) {
                DNDTree.selectNode(pt, this.project_tree);
            }
        }
    }

    private final void select(Object ob, DNDTree tree) {
        Thing root_thing = (Thing)((DefaultMutableTreeNode)tree.getModel().getRoot()).getUserObject();
        Thing child_thing = root_thing.findChild(ob);
        DNDTree.selectNode(child_thing, tree);
    }

    public ProjectThing find(long id) {
        return this.root_pt.findChild(id);
    }

    public DBObject findById(long id) {
        if (this.id == id) {
            return this;
        }
        DBObject dbo = this.layer_set.findById(id);
        if (null != dbo) {
            return dbo;
        }
        dbo = this.root_pt.findChild(id);
        if (null != dbo) {
            return dbo;
        }
        return (DBObject)((Object)this.root_tt.findChild(id));
    }

    public LayerThing findLayerThing(Object ob) {
        Thing lob = this.root_lt.findChild(ob);
        return null != lob ? (LayerThing)lob : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectThing findProjectThing(Object ob) {
        ProjectThing pt;
        Map<Object, ProjectThing> map = this.ptcache;
        synchronized (map) {
            pt = this.ptcache.get(ob);
        }
        if (null == pt) {
            pt = (ProjectThing)this.root_pt.findChild(ob);
            if (null != ob) {
                map = this.ptcache;
                synchronized (map) {
                    this.ptcache.put(ob, pt);
                }
            }
        }
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decache(Object ob) {
        Map<Object, ProjectThing> map = this.ptcache;
        synchronized (map) {
            this.ptcache.remove(ob);
        }
    }

    public ProjectThing getRootProjectThing() {
        return this.root_pt;
    }

    public LayerSet getRootLayerSet() {
        return this.layer_set;
    }

    public String getParentTitle(Displayable d) {
        try {
            ProjectThing thing = this.findProjectThing(d);
            ProjectThing parent = (ProjectThing)thing.getParent();
            if (d instanceof Profile) {
                parent = (ProjectThing)parent.getParent();
            }
            if (null == parent) {
                Utils.log2("null parent for " + d);
            }
            if (null != parent && null == parent.getObject()) {
                Utils.log2("null ob for parent " + parent + " of " + d);
            }
            return parent.getObject().toString();
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    public String getMeaningfulTitle2(Displayable d) {
        ProjectThing thing = this.findProjectThing(d);
        if (null == thing) {
            return d.getTitle();
        }
        if (!thing.getType().equals(d.getTitle())) {
            return (!thing.getType().equals(d.getTitle()) ? d.getTitle() + " [" : "[") + thing.getType() + ']';
        }
        for (Thing parent = (ProjectThing)thing.getParent(); null != parent; parent = parent.getParent()) {
            String type = parent.getType();
            Object ob = parent.getObject();
            if (ob.getClass() == Project.class) break;
            if (ob.equals(type)) continue;
            return ob.toString() + " [" + thing.getType() + "]";
        }
        if (d.getTitle().equals(thing.getType())) {
            return "[" + thing.getType() + "]";
        }
        return d.getTitle() + " [" + thing.getType() + "]";
    }

    public String getMeaningfulTitle(Displayable d) {
        Object ob;
        ProjectThing thing = this.findProjectThing(d);
        if (null == thing) {
            return d.getTitle();
        }
        String title = (!thing.getType().equals(d.getTitle()) ? d.getTitle() + " [" : "[") + thing.getType() + ' ' + '#' + d.getId() + ']';
        if (!thing.getType().equals(d.getTitle())) {
            return title;
        }
        StringBuilder sb = new StringBuilder(title);
        for (ProjectThing parent = (ProjectThing)thing.getParent(); null != parent && (ob = parent.getObject()).getClass() != Project.class; parent = (ProjectThing)parent.getParent()) {
            String type = parent.getType();
            if (!ob.equals(type)) {
                sb.insert(0, ob.toString() + ' ' + '[' + type + ']' + '/');
                break;
            }
            sb.insert(0, '/');
            sb.insert(0, type);
        }
        return sb.toString();
    }

    public String getShortMeaningfulTitle(Displayable d) {
        ProjectThing thing = this.findProjectThing(d);
        if (null == thing) {
            return d.getTitle();
        }
        return this.getShortMeaningfulTitle(thing, d);
    }

    public String getShortMeaningfulTitle(ProjectThing thing, Displayable d) {
        if (thing.getObject() != d) {
            return thing.toString();
        }
        String title = "#" + d.getId();
        for (ProjectThing parent = (ProjectThing)thing.getParent(); null != parent; parent = (ProjectThing)parent.getParent()) {
            String type;
            Object ob = parent.getObject();
            if (ob.equals(type = parent.getType())) continue;
            title = ob.toString() + " [" + type + "] " + title;
            break;
        }
        if ('#' == title.charAt(0)) {
            title = Project.getName(d.getClass()) + " " + title;
        }
        return title;
    }

    public static String getType(Class<?> c) {
        if (AreaList.class == c) {
            return "area_list";
        }
        if (DLabel.class == c) {
            return "label";
        }
        String name = c.getName().toLowerCase();
        int i = name.lastIndexOf(46);
        if (-1 != i) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public TemplateThing getTemplateThing(String type) {
        return this.ht_unique_tt.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUniqueTypes() {
        Map<String, TemplateThing> map = this.ht_unique_tt;
        synchronized (map) {
            if (!this.ht_unique_tt.containsKey("profile")) {
                this.ht_unique_tt.put("profile", new TemplateThing("profile"));
            }
            if (!this.ht_unique_tt.containsKey("profile_list")) {
                TemplateThing tpl = new TemplateThing("profile_list");
                tpl.addChild(this.ht_unique_tt.get("profile"));
                this.ht_unique_tt.put("profile_list", tpl);
            }
            if (!this.ht_unique_tt.containsKey("pipe")) {
                this.ht_unique_tt.put("pipe", new TemplateThing("pipe"));
            }
            if (!this.ht_unique_tt.containsKey("polyline")) {
                this.ht_unique_tt.put("polyline", new TemplateThing("polyline"));
            }
            if (!this.ht_unique_tt.containsKey("treeline")) {
                this.ht_unique_tt.put("treeline", new TemplateThing("treeline"));
            }
            if (!this.ht_unique_tt.containsKey("areatree")) {
                this.ht_unique_tt.put("areatree", new TemplateThing("areatree"));
            }
            if (!this.ht_unique_tt.containsKey("connector")) {
                this.ht_unique_tt.put("connector", new TemplateThing("connector"));
            }
            if (!this.ht_unique_tt.containsKey("ball")) {
                this.ht_unique_tt.put("ball", new TemplateThing("ball"));
            }
            if (!this.ht_unique_tt.containsKey("area_list")) {
                this.ht_unique_tt.put("area_list", new TemplateThing("area_list"));
            }
            if (!this.ht_unique_tt.containsKey("dissector")) {
                this.ht_unique_tt.put("dissector", new TemplateThing("dissector"));
            }
            TemplateThing project_tt = this.ht_unique_tt.remove("project");
            Object[] ut = new String[this.ht_unique_tt.size()];
            this.ht_unique_tt.keySet().toArray(ut);
            this.ht_unique_tt.put("project", project_tt);
            Arrays.sort(ut);
            return ut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUniqueType(String type) {
        if (null == type || Project.isBasicType(type)) {
            return false;
        }
        Map<String, TemplateThing> map = this.ht_unique_tt;
        synchronized (map) {
            return null != this.ht_unique_tt.remove(type);
        }
    }

    public boolean typeExists(String type) {
        return this.ht_unique_tt.containsKey(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUniqueType(TemplateThing tt) {
        Map<String, TemplateThing> map = this.ht_unique_tt;
        synchronized (map) {
            if (this.ht_unique_tt.containsKey(tt.getType())) {
                return false;
            }
            this.ht_unique_tt.put(tt.getType(), tt);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTypeName(String old_type, String new_type) {
        Map<String, TemplateThing> map = this.ht_unique_tt;
        synchronized (map) {
            if (this.ht_unique_tt.containsKey(new_type)) {
                Utils.showMessage("Can't rename type '" + old_type + "' : a type named '" + new_type + "' already exists!");
                return false;
            }
            this.ht_unique_tt.put(new_type, this.ht_unique_tt.remove(old_type));
            return true;
        }
    }

    private void createLayerTemplates() {
        if (null == layer_template) {
            layer_template = new TemplateThing("layer");
            layer_set_template = new TemplateThing("layer_set");
            layer_set_template.addChild(layer_template);
            layer_template.addChild(layer_set_template);
        }
    }

    @Override
    public void exportXML(StringBuilder sb, String indent, XMLOptions options) {
        Utils.logAll("ERROR: cannot call Project.exportXML(StringBuilder, String, ExportOptions) !!");
        throw new UnsupportedOperationException("Cannot call Project.exportXML(StringBuilder, String, Object)");
    }

    public void exportXML(Writer writer, String indent, XMLOptions options) throws Exception {
        Utils.showProgress(0.0);
        writer.write(indent);
        writer.write("<trakem2>\n");
        String in = indent + "\t";
        this.exportXML2(writer, in, options);
        this.layer_set.exportXML(writer, in, options);
        Display.exportXML(this, writer, in, options);
        writer.write("</trakem2>\n");
    }

    private final void exportXML2(Writer writer, String in, XMLOptions options) throws Exception {
        StringBuilder sb_body = new StringBuilder();
        sb_body.append(in).append("<project \n").append(in).append("\tid=\"").append(this.id).append("\"\n").append(in).append("\ttitle=\"").append(this.title).append("\"\n");
        this.loader.insertXMLOptions(sb_body, in + "\t");
        HashMap<String, String> props = new HashMap<String, String>(this.ht_props);
        props.put("image_resizing_mode", Loader.getMipMapModeName(this.mipmaps_mode));
        props.put("first_mipmap_level_saved", Integer.toString(this.first_mipmap_level_saved));
        for (Map.Entry<String, String> e : props.entrySet()) {
            sb_body.append(in).append('\t').append(e.getKey()).append("=\"").append(e.getValue()).append("\"\n");
        }
        sb_body.append(in).append(">\n");
        this.project_tree.getExpandedStates(options.expanded_states);
        if (null != this.root_pt.getChildren()) {
            String in2 = in + "\t";
            for (ProjectThing pt : this.root_pt.getChildren()) {
                pt.exportXML(sb_body, in2, options);
            }
        }
        sb_body.append(in).append("</project>\n");
        writer.write(sb_body.toString());
    }

    public void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        sb_header.append(indent).append("<!ELEMENT ").append("trakem2 (project,t2_layer_set,t2_display)>\n");
        sb_header.append(indent).append("<!ELEMENT ").append("project (").append(this.root_tt.getType()).append(")>\n");
        sb_header.append(indent).append("<!ATTLIST project id NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ATTLIST project unuid NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ATTLIST project title NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ATTLIST project preprocessor NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ATTLIST project mipmaps_folder NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ATTLIST project storage_folder NMTOKEN #REQUIRED>\n");
        for (String key : this.ht_props.keySet()) {
            sb_header.append(indent).append("<!ATTLIST project ").append(key).append(" NMTOKEN #REQUIRED>\n");
        }
        this.root_tt.exportDTD(sb_header, hs, indent);
        Layer.exportDTD(sb_header, hs, indent);
        LayerSet.exportDTD(sb_header, hs, indent);
        Ball.exportDTD(sb_header, hs, indent);
        DLabel.exportDTD(sb_header, hs, indent);
        Patch.exportDTD(sb_header, hs, indent);
        Pipe.exportDTD(sb_header, hs, indent);
        Polyline.exportDTD(sb_header, hs, indent);
        Profile.exportDTD(sb_header, hs, indent);
        AreaList.exportDTD(sb_header, hs, indent);
        Dissector.exportDTD(sb_header, hs, indent);
        Stack.exportDTD(sb_header, hs, indent);
        Treeline.exportDTD(sb_header, hs, indent);
        AreaTree.exportDTD(sb_header, hs, indent);
        Connector.exportDTD(sb_header, hs, indent);
        Displayable.exportDTD(sb_header, hs, indent);
        Display.exportDTD(sb_header, hs, indent);
        DTD.append((StringBuilder)sb_header, hs, (String)indent);
    }

    public String getDocType() {
        return "trakem2_" + this.root_tt.getType();
    }

    public static String getName(Class<?> c) {
        String name = c.getName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).equals("DLabel")) {
            return "Label";
        }
        if (name.equals("Patch")) {
            return "Image";
        }
        return name;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder("Project id: ");
        sb.append(this.id).append("\nProject name: ").append(this.title).append("\nTrees:\n").append(this.project_tree.getInfo()).append("\n").append(this.layer_tree.getInfo());
        return sb.toString();
    }

    public static Project findProject(Loader loader) {
        for (Project pro : al_open_projects) {
            if (pro.getLoader() != loader) continue;
            return pro;
        }
        return null;
    }

    public void setReceivesInput(boolean b) {
        this.input_disabled = !b;
        Display.setReceivesInput(this, b);
    }

    public boolean isInputEnabled() {
        return !this.input_disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createSubproject(Rectangle roi, Layer first, Layer last, boolean ignore_hidden_patches) {
        try {
            Project pr = new Project(new FSLoader(this.getLoader().getStorageFolder()));
            pr.id = this.id;
            pr.title = this.title;
            pr.ht_props.putAll(this.ht_props);
            pr.root_tt = this.root_tt.clone(pr, true);
            pr.template_tree = new TemplateTree(pr, pr.root_tt);
            Map<String, TemplateThing> map = pr.ht_unique_tt;
            synchronized (map) {
                pr.ht_unique_tt.clear();
                pr.ht_unique_tt.putAll(this.root_tt.getUniqueTypes(new HashMap<String, TemplateThing>()));
            }
            TemplateThing project_template = new TemplateThing("project");
            project_template.addChild(pr.root_tt);
            pr.ht_unique_tt.put("project", project_template);
            pr.createLayerTemplates();
            pr.layer_set = (LayerSet)this.layer_set.clone(pr, first, last, roi, false, true, ignore_hidden_patches);
            LayerSet.cloneInto(this.layer_set, first, last, pr, pr.layer_set, roi, true);
            pr.root_lt = new LayerThing(layer_set_template, pr, pr.layer_set);
            pr.layer_tree = new LayerTree(pr, pr.root_lt);
            pr.layer_set.updateLayerTree();
            pr.root_pt = this.root_pt.subclone(pr);
            pr.project_tree = new ProjectTree(pr, pr.root_pt);
            al_open_projects.add(pr);
            ControlWindow.add(pr, pr.template_tree, pr.project_tree, pr.layer_tree);
            pr.loader.regenerateMipMaps(pr.layer_set.getDisplayables(Patch.class));
            pr.restartAutosaving();
            return pr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void parseXMLOptions(HashMap<String, String> ht_attributes) {
        ((FSLoader)this.project.getLoader()).parseXMLOptions(ht_attributes);
        String mipmapsMode = ht_attributes.remove("image_resizing_mode");
        this.mipmaps_mode = null == mipmapsMode ? 6 : Loader.getMipMapModeIndex(mipmapsMode);
        String firstMipMapLevelSaved = ht_attributes.remove("first_mipmap_level_saved");
        if (null != firstMipMapLevelSaved) {
            try {
                int fmls;
                this.first_mipmap_level_saved = fmls = Integer.parseInt(firstMipMapLevelSaved);
            }
            catch (Exception e) {
                Utils.log2("Ignoring invalid value for 'first_mipmap_level_saved': " + firstMipMapLevelSaved);
                IJError.print(e);
            }
        }
        this.ht_props.putAll(ht_attributes);
        for (Map.Entry<String, String> prop : ht_attributes.entrySet()) {
            Utils.log2("parsed: " + prop.getKey() + "=" + prop.getValue());
        }
    }

    public HashMap<String, String> getPropertiesCopy() {
        return new HashMap<String, String>(this.ht_props);
    }

    public String getProperty(String key) {
        return this.ht_props.get(key);
    }

    public float getProperty(String key, float default_value) {
        try {
            String s = this.ht_props.get(key);
            if (null == s) {
                return default_value;
            }
            float num = Float.parseFloat(s);
            if (Float.isNaN(num)) {
                return default_value;
            }
            return num;
        }
        catch (NumberFormatException nfe) {
            IJError.print(nfe);
            return default_value;
        }
    }

    public int getProperty(String key, int default_value) {
        try {
            String s = this.ht_props.get(key);
            if (null == s) {
                return default_value;
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            IJError.print(nfe);
            return default_value;
        }
    }

    public boolean getBooleanProperty(String key) {
        return "true".equals(this.ht_props.get(key));
    }

    public void setProperty(String key, String value) {
        if (null == value) {
            this.ht_props.remove(key);
        } else {
            this.ht_props.put(key, value);
        }
    }

    private final boolean addBox(GenericDialog gd, Class<?> c) {
        String name = Project.getName(c);
        boolean link = "true".equals(this.ht_props.get(name.toLowerCase() + "_nolinks"));
        gd.addCheckbox(name, link);
        return link;
    }

    private final void setLinkProp(boolean before, boolean after, Class<?> c) {
        if (before) {
            if (!after) {
                this.ht_props.remove(Project.getName(c).toLowerCase() + "_nolinks");
            }
        } else if (after) {
            this.ht_props.put(Project.getName(c).toLowerCase() + "_nolinks", "true");
        }
    }

    private final boolean adjustProp(String prop, boolean before, boolean after) {
        if (before) {
            if (!after) {
                this.ht_props.remove(prop);
            }
        } else if (after) {
            this.ht_props.put(prop, "true");
        }
        return before != after;
    }

    public final int setFirstMipMapLevelSaved(double level) {
        if (Double.isNaN(level) || level < 0.0) {
            return this.first_mipmap_level_saved;
        }
        this.first_mipmap_level_saved = (int)Math.floor(level);
        return this.first_mipmap_level_saved;
    }

    public final int getFirstMipMapLevelSaved() {
        return this.first_mipmap_level_saved;
    }

    public void adjustProperties() {
        int meshResolution2;
        int n_mipmap_threads2;
        YesNoDialog yn;
        int old_mipmap_format;
        GenericDialog gd = new GenericDialog("Properties");
        gd.addMessage("Ignore image linking for:");
        boolean link_labels = this.addBox(gd, DLabel.class);
        boolean nolink_segmentations = "true".equals(this.ht_props.get("segmentations_nolinks"));
        gd.addCheckbox("Segmentations", nolink_segmentations);
        gd.addMessage("Currently linked objects will remain so\nunless explicitly unlinked.");
        boolean dissector_zoom = "true".equals(this.ht_props.get("dissector_zoom"));
        gd.addCheckbox("Zoom-invariant markers for Dissector", dissector_zoom);
        gd.addChoice("Image_resizing_mode: ", Loader.MIPMAP_MODES.values().toArray(new String[Loader.MIPMAP_MODES.size()]), Loader.getMipMapModeName(this.mipmaps_mode));
        gd.addChoice("mipmaps format:", FSLoader.MIPMAP_FORMATS, FSLoader.MIPMAP_FORMATS[this.loader.getMipMapFormat()]);
        gd.addNumericField("Save mipmap images from level", (double)this.first_mipmap_level_saved, 0);
        boolean layer_mipmaps = "true".equals(this.ht_props.get("layer_mipmaps"));
        gd.addCheckbox("Layer_mipmaps", layer_mipmaps);
        boolean keep_mipmaps = "true".equals(this.ht_props.get("keep_mipmaps"));
        gd.addCheckbox("Keep_mipmaps_when_deleting_images", keep_mipmaps);
        int bucket_side = this.getProperty("bucket_side", 4096);
        gd.addNumericField("Bucket side length: ", (double)bucket_side, 0, 6, "pixels");
        boolean no_shutdown_hook = "true".equals(this.ht_props.get("no_shutdown_hook"));
        gd.addCheckbox("No_shutdown_hook to save the project", no_shutdown_hook);
        int n_undo_steps = this.getProperty("n_undo_steps", 32);
        gd.addSlider("Undo steps", 32.0, 200.0, (double)n_undo_steps);
        boolean flood_fill_to_image_edge = "true".equals(this.ht_props.get("flood_fill_to_image_edge"));
        gd.addCheckbox("AreaList_flood_fill_to_image_edges", flood_fill_to_image_edge);
        int look_ahead_cache = this.getProperty("look_ahead_cache", 0);
        gd.addNumericField("Look_ahead_cache:", (double)look_ahead_cache, 0, 6, "layers");
        int autosaving_interval = this.getProperty("autosaving_interval", 10);
        gd.addNumericField("Autosave every:", (double)autosaving_interval, 0, 6, "minutes");
        int n_mipmap_threads = this.getProperty("n_mipmap_threads", 1);
        gd.addSlider("Number of threads for mipmaps", 1.0, (double)n_mipmap_threads, (double)n_mipmap_threads);
        int meshResolution = this.getProperty("mesh_resolution", 32);
        gd.addSlider("Default mesh resolution for images", 1.0, 512.0, (double)meshResolution);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.setLinkProp(link_labels, gd.getNextBoolean(), DLabel.class);
        boolean nolink_segmentations2 = gd.getNextBoolean();
        if (nolink_segmentations) {
            if (!nolink_segmentations2) {
                this.ht_props.remove("segmentations_nolinks");
            }
        } else if (nolink_segmentations2) {
            this.ht_props.put("segmentations_nolinks", "true");
        }
        if (this.adjustProp("dissector_zoom", dissector_zoom, gd.getNextBoolean())) {
            Display.repaint(this.layer_set);
        }
        this.mipmaps_mode = Loader.getMipMapModeIndex(gd.getNextChoice());
        int new_mipmap_format = gd.getNextChoiceIndex();
        if (new_mipmap_format != (old_mipmap_format = this.loader.getMipMapFormat()) && (yn = new YesNoDialog("MipMaps format", "Changing mipmaps format to '" + FSLoader.MIPMAP_FORMATS[new_mipmap_format] + "'requires regenerating all mipmaps. Proceed?")).yesPressed() && this.loader.setMipMapFormat(new_mipmap_format)) {
            this.loader.updateMipMapsFormat(old_mipmap_format, new_mipmap_format);
        }
        this.setFirstMipMapLevelSaved(gd.getNextNumber());
        boolean layer_mipmaps2 = gd.getNextBoolean();
        if (!this.adjustProp("layer_mipmaps", layer_mipmaps, layer_mipmaps2) || layer_mipmaps && !layer_mipmaps2 || layer_mipmaps || layer_mipmaps2) {
            // empty if block
        }
        this.adjustProp("keep_mipmaps", keep_mipmaps, gd.getNextBoolean());
        Utils.log2("keep_mipmaps: " + this.getBooleanProperty("keep_mipmaps"));
        bucket_side = (int)gd.getNextNumber();
        if (bucket_side > 4096) {
            this.setProperty("bucket_side", Integer.toString(bucket_side));
            this.layer_set.recreateBuckets(true);
        }
        this.adjustProp("no_shutdown_hook", no_shutdown_hook, gd.getNextBoolean());
        n_undo_steps = (int)gd.getNextNumber();
        if (n_undo_steps < 0) {
            n_undo_steps = 0;
        }
        this.setProperty("n_undo_steps", Integer.toString(n_undo_steps));
        this.adjustProp("flood_fill_to_image_edge", flood_fill_to_image_edge, gd.getNextBoolean());
        double d_look_ahead_cache = gd.getNextNumber();
        if (!Double.isNaN(d_look_ahead_cache) && d_look_ahead_cache >= 0.0) {
            this.setProperty("look_ahead_cache", Integer.toString((int)d_look_ahead_cache));
            if (0.0 == d_look_ahead_cache) {
                Display.clearColumnScreenshots(this.layer_set);
            } else {
                Utils.logAll("WARNING: look-ahead cache is incomplete.\n  Expect issues when editing objects, adding new ones, and the like.\n  Use \"Project - Flush image cache\" to fix any lack of refreshing issues you encounter.");
            }
        } else {
            Utils.log2("Ignoring invalid 'look ahead cache' value " + d_look_ahead_cache);
        }
        double autosaving_interval2 = gd.getNextNumber();
        if ((int)autosaving_interval2 != autosaving_interval) {
            if (autosaving_interval2 < 0.0 || Double.isNaN(autosaving_interval)) {
                Utils.log("IGNORING invalid autosaving interval: " + autosaving_interval2);
            } else {
                this.setProperty("autosaving_interval", Integer.toString((int)autosaving_interval2));
                this.restartAutosaving();
            }
        }
        if (n_mipmap_threads != (n_mipmap_threads2 = (int)Math.max(1.0, gd.getNextNumber()))) {
            this.setProperty("n_mipmap_threads", Integer.toString(n_mipmap_threads2));
            FSLoader.restartMipMapThreads(n_mipmap_threads2);
        }
        if (meshResolution != (meshResolution2 = (int)gd.getNextNumber())) {
            if (meshResolution2 > 0) {
                this.setProperty("mesh_resolution", Integer.toString(meshResolution2));
            } else {
                Utils.log("WARNING: ignoring invalid mesh resolution value " + meshResolution2);
            }
        }
    }

    public String getUNUId() {
        return this.loader.getUNUId();
    }

    public final boolean remove(Displayable d) {
        HashSet<Displayable> s = new HashSet<Displayable>();
        s.add(d);
        return this.removeAll(s);
    }

    public final boolean removeAll(Set<Displayable> col) {
        return this.removeAll(col, null);
    }

    public final boolean removeAll(Set<Displayable> col, DefaultMutableTreeNode top_node) {
        HashSet<ZDisplayable> zds = new HashSet<ZDisplayable>();
        ArrayList<Displayable> ds = new ArrayList<Displayable>();
        for (Displayable d : col) {
            if (d instanceof ZDisplayable) {
                zds.add((ZDisplayable)d);
                continue;
            }
            ds.add(d);
        }
        HashMap<Layer, HashSet<Displayable>> ml = new HashMap<Layer, HashSet<Displayable>>();
        Iterator<Object> it = ds.iterator();
        while (it.hasNext()) {
            Displayable displayable = (Displayable)it.next();
            if (displayable.getClass() == Profile.class) {
                if (!this.project_tree.remove(false, this.findProjectThing(displayable), null)) {
                    Utils.log("Could NOT delete " + displayable);
                    continue;
                }
                it.remove();
                continue;
            }
            HashSet<Displayable> l = (HashSet<Displayable>)ml.get(displayable.getLayer());
            if (null == l) {
                l = new HashSet<Displayable>();
                ml.put(displayable.getLayer(), l);
            }
            l.add(displayable);
        }
        if (ml.size() > 0) {
            for (Map.Entry entry : ml.entrySet()) {
                ((Layer)entry.getKey()).removeAll((Set)entry.getValue());
            }
        }
        if (zds.size() > 0) {
            HashSet<ZDisplayable> stacks = new HashSet<ZDisplayable>();
            Iterator iterator = zds.iterator();
            while (iterator.hasNext()) {
                ZDisplayable zd = (ZDisplayable)iterator.next();
                if (zd.getClass() != Stack.class) continue;
                iterator.remove();
                stacks.add(zd);
            }
            this.layer_set.removeAll(stacks);
        }
        if (zds.size() > 0) {
            Set<Displayable> not_removed = this.project_tree.remove(zds, top_node);
            zds.removeAll(not_removed);
            this.layer_set.removeAll(zds);
        }
        return true;
    }

    public void resetRootProjectThing(ProjectThing pt, HashMap<Thing, Boolean> ptree_exp) {
        this.root_pt = pt;
        this.project_tree.reset(ptree_exp);
    }

    public void resetRootTemplateThing(TemplateThing tt, HashMap<Thing, Boolean> ttree_exp) {
        this.root_tt = tt;
        this.template_tree.reset(ttree_exp);
    }

    public void resetRootLayerThing(LayerThing lt, HashMap<Thing, Boolean> ltree_exp) {
        this.root_lt = lt;
        this.layer_tree.reset(ltree_exp);
    }

    public TemplateThing getRootTemplateThing() {
        return this.root_tt;
    }

    public LayerThing getRootLayerThing() {
        return this.root_lt;
    }

    public Bureaucrat saveTask(final String command) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Saving"){

            @Override
            public void exec() {
                if (command.equals("Save")) {
                    Project.this.save();
                } else if (command.equals("Save as...")) {
                    XMLOptions options = new XMLOptions();
                    options.overwriteXMLFile = false;
                    options.export_images = false;
                    options.include_coordinate_transform = true;
                    options.patches_dir = null;
                    Project.this.loader.saveAs(Project.this.project, options);
                    Project.this.restartAutosaving();
                } else if (command.equals("Save as... without coordinate transforms")) {
                    YesNoDialog yn = new YesNoDialog("WARNING", "You are about to save an XML file that lacks the information for the coordinate transforms of each image.\nThese transforms are referred to with the attribute 'ct_id' of each 't2_patch' entry in the XML document,\nand the data for the transform is stored in an individual file under the folder 'trakem2.cts/'.\n \nIt is advised to keep a complete XML file with all coordinate transforms included along with this new copy.\nPlease check NOW that you have such a complete XML copy.\n \nProceed?");
                    if (!yn.yesPressed()) {
                        return;
                    }
                    Project.this.saveWithoutCoordinateTransforms();
                } else if (command.equals("Delete stale files...")) {
                    this.setTaskName("Deleting stale files");
                    GenericDialog gd = new GenericDialog("Delete stale files");
                    gd.addMessage("You are about to remove all files under the folder 'trakem2.cts/' which are not referred to from the\ncurrently loaded project. If you have sibling XML files whose 't2_patch' entries (the images) refer,\nvia 'ct_id' attributes, to coordinate transforms in 'trakem2.cts/' that this current XML doesn't,\nthey may be LOST FOREVER. Unless you have a version of the XML file with the coordinate transforms\nwritten in it, as can be obtained by using the 'Project - Save' command.\n \nThe same is true for the .zip files that store alpha masks, under folder 'trakem2.masks/'\nand which are referred to from the 'alpha_mask_id' attribute of 't2_patch' entries.\n \nDo you have such complete XML file? Check *NOW*.\n \nProceed with deleting:");
                    gd.addCheckbox("Delete stale coordinate transform files", true);
                    gd.addCheckbox("Delete stale alpha mask files", true);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    Project.this.project.getLoader().deleteStaleFiles(gd.getNextBoolean(), gd.getNextBoolean());
                }
            }
        }, this.project);
    }

    public int getMipMapsMode() {
        return this.mipmaps_mode;
    }

    public void setMipMapsMode(int mode) {
        this.mipmaps_mode = mode;
    }

    static {
        try {
            if (IJ.isLinux() && "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                if (null != IJ.getInstance()) {
                    SwingUtilities.updateComponentTreeUI((Component)IJ.getInstance());
                }
            }
        }
        catch (Exception e) {
            Utils.log("Failed to set System Look and Feel");
        }
        PLUGIN_SOURCES = new Vector();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.setPriority(5);
                    this.setContextClassLoader(IJ.getClassLoader());
                    String plugins_dir = Utils.fixDir(Menus.getPlugInsPath());
                    Vector vector = PLUGIN_SOURCES;
                    synchronized (vector) {
                        block12: for (String name : new File(plugins_dir).list()) {
                            File f = new File(name);
                            if (f.isHidden() || !name.toLowerCase().endsWith(".jar")) continue;
                            JarFile jar = new JarFile(plugins_dir + name);
                            JarEntry entry = null;
                            Enumeration<JarEntry> en = jar.entries();
                            while (en.hasMoreElements()) {
                                JarEntry je = en.nextElement();
                                if (!je.getName().endsWith(".trakem2")) continue;
                                entry = je;
                                break;
                            }
                            if (entry == null) continue;
                            BufferedReader br = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
                            block14: while (true) {
                                while (true) {
                                    int lq;
                                    String menu;
                                    int lc;
                                    int fc;
                                    String line;
                                    if (null == (line = br.readLine())) {
                                        continue block12;
                                    }
                                    if (line.startsWith("#") || -1 == (fc = line.indexOf(44)) || -1 == (lc = line.lastIndexOf(44)) || !(menu = line.substring(0, fc).trim()).equals("Project Tree") && !menu.equals("Display")) continue;
                                    String classname = line.substring(lc + 1).trim();
                                    try {
                                        Class.forName(classname);
                                    }
                                    catch (ClassNotFoundException cnfe) {
                                        Utils.log2("TPlugIn class not found: " + classname);
                                        continue;
                                    }
                                    int fq = line.indexOf(34, fc);
                                    if (-1 == fq || -1 == (lq = line.lastIndexOf(34, lc))) continue;
                                    String title = line.substring(fq + 1, lq).trim();
                                    try {
                                        PLUGIN_SOURCES.add(new PlugInSource(menu, Class.forName(classname), title));
                                        Utils.log2("Found plugin for menu " + menu + " titled " + title + " for class " + classname);
                                        continue block14;
                                    }
                                    catch (ClassNotFoundException cnfe) {
                                        Utils.log("Could not find TPlugIn class " + classname);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            finally {
                                br.close();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Utils.log("ERROR while parsing TrakEM2 plugins:");
                    IJError.print(t);
                }
            }
        }.start();
        al_open_projects = new ArrayList();
        layer_template = null;
        layer_set_template = null;
    }

    private static class PlugInSource
    implements Comparable<PlugInSource> {
        String menu;
        Class<?> c;
        String title;

        PlugInSource(String menu, Class<?> c, String title) {
            this.menu = menu;
            this.c = c;
            this.title = title;
        }

        @Override
        public int compareTo(PlugInSource ob) {
            return ob.title.compareTo(this.title);
        }
    }
}

