/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.display.Patch;
import ini.trakem2.imaging.FastIntegralImage;
import ini.trakem2.imaging.P;
import ini.trakem2.io.ImageSaver;
import ini.trakem2.persistence.ImageBytes;
import ini.trakem2.persistence.Loader;
import java.awt.image.BufferedImage;
import mpicbg.imglib.algorithm.integral.IntegralImage;
import mpicbg.imglib.algorithm.integral.ScaleAreaAveraging2d;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.DataAccess;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.function.IntegerTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;

public class IntegralImageMipMaps {
    public static final ImageBytes[] create(Patch patch, ImageProcessor ip, ByteProcessor alpha, ByteProcessor outside, int type) {
        ByteProcessor mask;
        if (null == alpha) {
            mask = null == outside ? null : outside;
        } else if (null == outside) {
            mask = alpha;
        } else {
            byte[] b1 = (byte[])alpha.getPixels();
            byte[] b2 = (byte[])outside.getPixels();
            for (int i = 0; i < b1.length; ++i) {
                b2[i] = (byte)((b2[i] & 0xFF) != 255 ? 0 : b1[i] & 0xFF);
            }
            mask = outside;
        }
        switch (type) {
            case 1: 
            case 2: {
                ip = ip.convertToByte(true);
            }
            case 0: {
                return IntegralImageMipMaps.fastCreateGRAY8(patch, (ByteProcessor)ip, mask);
            }
            case 3: 
            case 4: {
                return IntegralImageMipMaps.fastCreateRGB(patch, (ColorProcessor)ip, mask);
            }
        }
        return null;
    }

    private static final Image<UnsignedByteType> wrap(byte[] p, int[] dims) {
        Array c = new Array(new ArrayContainerFactory(), (DataAccess)new ByteArray(p), dims, 1);
        UnsignedByteType t = new UnsignedByteType((DirectAccessContainer)c);
        c.setLinkedType((Type)t);
        return new Image((Container)c, (Type)t);
    }

    private static final int[] blend(byte[] pi, byte[] pm) {
        int[] p = new int[pi.length];
        for (int i = 0; i < p.length; ++i) {
            int c = pi[i] & 0xFF;
            p[i] = (pm[i] & 0xFF) << 24 | c << 16 | c << 8 | c;
        }
        return p;
    }

    private static final int[] blend(int[] pi, byte[] pm) {
        for (int i = 0; i < pi.length; ++i) {
            pi[i] = (pm[i] & 0xFF) << 24 | pi[i];
        }
        return pi;
    }

    private static final int[] blend(byte[] r, byte[] g, byte[] b, byte[] a) {
        int[] p = new int[r.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = (a[i] & 0xFF) << 24 | (r[i] & 0xFF) << 16 | (g[i] & 0xFF) << 8 | b[i] & 0xFF;
        }
        return p;
    }

    private static final int[] blend(byte[] r, byte[] g, byte[] b) {
        int[] p = new int[r.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = (r[i] & 0xFF) << 16 | (g[i] & 0xFF) << 8 | b[i] & 0xFF;
        }
        return p;
    }

    private static final BufferedImage[] createGRAY8(Patch patch, ByteProcessor ip, ByteProcessor mask) {
        ScaleAreaAveraging2d saam;
        int w = ip.getWidth();
        int h = ip.getHeight();
        int[] dims = new int[]{w, h};
        IntegralImage oa = new IntegralImage(IntegralImageMipMaps.wrap((byte[])ip.getPixels(), dims), (NumericType)new LongType(), (Converter)new IntegerTypeConverter());
        oa.process();
        ScaleAreaAveraging2d saai = new ScaleAreaAveraging2d(oa.getResult(), (RealType)new UnsignedByteType(), dims);
        if (null != mask) {
            IntegralImage ma = new IntegralImage(IntegralImageMipMaps.wrap((byte[])mask.getPixels(), dims), (NumericType)new LongType(), (Converter)new IntegerTypeConverter());
            ma.process();
            saam = new ScaleAreaAveraging2d(ma.getResult(), (RealType)new UnsignedByteType(), dims);
        } else {
            saam = null;
        }
        BufferedImage[] bis = new BufferedImage[Loader.getHighestMipMapLevel(patch) + 1];
        if (null == saam) {
            bis[0] = ImageSaver.createGrayImage((byte[])ip.getPixels(), w, h);
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                int hk = h / K;
                saai.setOutputDimensions(wk, hk);
                saai.process();
                bis[i] = ImageSaver.createGrayImage(((ByteArray)((Array)saai.getResult().getContainer()).update(null)).getCurrentStorageArray(), wk, hk);
            }
        } else {
            bis[0] = ImageSaver.createARGBImage(IntegralImageMipMaps.blend((byte[])ip.getPixels(), (byte[])mask.getPixels()), w, h);
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                int hk = h / K;
                saai.setOutputDimensions(wk, hk);
                saai.process();
                saam.setOutputDimensions(wk, hk);
                saam.process();
                bis[i] = ImageSaver.createARGBImage(IntegralImageMipMaps.blend(((ByteArray)((Array)saai.getResult().getContainer()).update(null)).getCurrentStorageArray(), ((ByteArray)((Array)saam.getResult().getContainer()).update(null)).getCurrentStorageArray()), wk, hk);
            }
        }
        return bis;
    }

    private static final ImageBytes[] fastCreateGRAY8(Patch patch, ByteProcessor ip, ByteProcessor mask) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        long[] ii = FastIntegralImage.longIntegralImage((byte[])ip.getPixels(), w, h);
        long[] mi = null == mask ? null : FastIntegralImage.longIntegralImage((byte[])mask.getPixels(), w, h);
        ImageBytes[] bis = new ImageBytes[Loader.getHighestMipMapLevel(patch) + 1];
        if (null == mask) {
            bis[0] = new ImageBytes(new byte[][]{(byte[])ip.getPixels()}, ip.getWidth(), ip.getHeight());
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                int hk = h / K;
                bis[i] = new ImageBytes(new byte[][]{FastIntegralImage.scaleAreaAverage(ii, w + 1, h + 1, wk, hk)}, wk, hk);
            }
        } else {
            bis[0] = new ImageBytes(new byte[][]{(byte[])ip.getPixels(), (byte[])mask.getPixels()}, ip.getWidth(), ip.getHeight());
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                int hk = h / K;
                bis[i] = new ImageBytes(new byte[][]{FastIntegralImage.scaleAreaAverage(ii, w + 1, h + 1, wk, hk), FastIntegralImage.scaleAreaAverage(mi, w + 1, h + 1, wk, hk)}, wk, hk);
            }
        }
        return bis;
    }

    private static final ScaleAreaAveraging2d<LongType, UnsignedByteType> saa(byte[] b, int[] dims) {
        IntegralImage ii = new IntegralImage(IntegralImageMipMaps.wrap(b, dims), (NumericType)new LongType(), (Converter)new IntegerTypeConverter());
        ii.process();
        return new ScaleAreaAveraging2d(ii.getResult(), (RealType)new UnsignedByteType(), dims);
    }

    private static final BufferedImage[] createRGB(Patch patch, ColorProcessor ip, ByteProcessor mask) {
        int hk;
        int w = ip.getWidth();
        int h = ip.getHeight();
        int[] dims = new int[]{w, h};
        int[] p = (int[])ip.getPixels();
        byte[] r = new byte[p.length];
        byte[] g = new byte[p.length];
        byte[] b = new byte[p.length];
        for (int i = 0; i < p.length; ++i) {
            int a = p[i];
            r[i] = (byte)(a >> 16 & 0xFF);
            g[i] = (byte)(a >> 8 & 0xFF);
            b[i] = (byte)(a & 0xFF);
        }
        ScaleAreaAveraging2d<LongType, UnsignedByteType> saar = IntegralImageMipMaps.saa(r, dims);
        ScaleAreaAveraging2d<LongType, UnsignedByteType> saag = IntegralImageMipMaps.saa(g, dims);
        ScaleAreaAveraging2d<LongType, UnsignedByteType> saab = IntegralImageMipMaps.saa(b, dims);
        ScaleAreaAveraging2d<LongType, UnsignedByteType> saam = null == mask ? null : IntegralImageMipMaps.saa((byte[])mask.getPixels(), dims);
        BufferedImage[] bis = new BufferedImage[Loader.getHighestMipMapLevel(patch) + 1];
        if (null == saam) {
            bis[0] = ImageSaver.createARGBImage((int[])ip.getPixels(), w, h);
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                hk = h / K;
                saar.setOutputDimensions(wk, hk);
                saar.process();
                saag.setOutputDimensions(wk, hk);
                saag.process();
                saab.setOutputDimensions(wk, hk);
                saab.process();
                bis[i] = ImageSaver.createARGBImage(IntegralImageMipMaps.blend(((ByteArray)((Array)saar.getResult().getContainer()).update(null)).getCurrentStorageArray(), ((ByteArray)((Array)saag.getResult().getContainer()).update(null)).getCurrentStorageArray(), ((ByteArray)((Array)saab.getResult().getContainer()).update(null)).getCurrentStorageArray()), wk, hk);
            }
        } else {
            bis[0] = ImageSaver.createARGBImage(IntegralImageMipMaps.blend((int[])ip.getPixels(), (byte[])mask.getPixels()), w, h);
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                hk = h / K;
                saar.setOutputDimensions(wk, hk);
                saar.process();
                saag.setOutputDimensions(wk, hk);
                saag.process();
                saab.setOutputDimensions(wk, hk);
                saab.process();
                saam.setOutputDimensions(wk, hk);
                saam.process();
                bis[i] = ImageSaver.createARGBImage(IntegralImageMipMaps.blend(((ByteArray)((Array)saar.getResult().getContainer()).update(null)).getCurrentStorageArray(), ((ByteArray)((Array)saag.getResult().getContainer()).update(null)).getCurrentStorageArray(), ((ByteArray)((Array)saab.getResult().getContainer()).update(null)).getCurrentStorageArray(), ((ByteArray)((Array)saam.getResult().getContainer()).update(null)).getCurrentStorageArray()), wk, hk);
            }
        }
        return bis;
    }

    private static final ImageBytes[] fastCreateRGB(Patch patch, ColorProcessor ip, ByteProcessor mask) {
        int hk;
        int w = ip.getWidth();
        int h = ip.getHeight();
        int[] p = (int[])ip.getPixels();
        byte[] r = new byte[p.length];
        byte[] g = new byte[p.length];
        byte[] b = new byte[p.length];
        for (int i = 0; i < p.length; ++i) {
            int a = p[i];
            r[i] = (byte)(a >> 16 & 0xFF);
            g[i] = (byte)(a >> 8 & 0xFF);
            b[i] = (byte)(a & 0xFF);
        }
        long[] ir = FastIntegralImage.longIntegralImage(r, w, h);
        long[] ig = FastIntegralImage.longIntegralImage(g, w, h);
        long[] ib = FastIntegralImage.longIntegralImage(b, w, h);
        long[] im = null == mask ? null : FastIntegralImage.longIntegralImage((byte[])mask.getPixels(), w, h);
        ImageBytes[] bis = new ImageBytes[Loader.getHighestMipMapLevel(patch) + 1];
        if (null == mask) {
            bis[0] = new ImageBytes(P.asRGBBytes((int[])ip.getPixels()), ip.getWidth(), ip.getHeight());
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                hk = h / K;
                bis[i] = new ImageBytes(new byte[][]{FastIntegralImage.scaleAreaAverage(ir, w + 1, h + 1, wk, hk), FastIntegralImage.scaleAreaAverage(ig, w + 1, h + 1, wk, hk), FastIntegralImage.scaleAreaAverage(ib, w + 1, h + 1, wk, hk)}, wk, hk);
            }
        } else {
            bis[0] = new ImageBytes(P.asRGBABytes((int[])ip.getPixels(), (byte[])mask.getPixels(), null), ip.getWidth(), ip.getHeight());
            for (int i = 1; i < bis.length; ++i) {
                int K = (int)Math.pow(2.0, i);
                int wk = w / K;
                hk = h / K;
                bis[i] = new ImageBytes(new byte[][]{FastIntegralImage.scaleAreaAverage(ir, w + 1, h + 1, wk, hk), FastIntegralImage.scaleAreaAverage(ig, w + 1, h + 1, wk, hk), FastIntegralImage.scaleAreaAverage(ib, w + 1, h + 1, wk, hk), FastIntegralImage.scaleAreaAverage(im, w + 1, h + 1, wk, hk)}, wk, hk);
            }
        }
        return bis;
    }
}

