/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import io.airlift.compress.MalformedInputException;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import java.io.IOException;
import java.util.Arrays;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;

public class LZ4Codec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data to compress");
        }
        Lz4Compressor compressor = new Lz4Compressor();
        byte[] output = new byte[compressor.maxCompressedLength(data.length)];
        int len = compressor.compress(data, 0, data.length, output, 0, output.length);
        return Arrays.copyOfRange(output, 0, len);
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        long byteCount = in.length() - in.getFilePointer();
        if (byteCount > Integer.MAX_VALUE || byteCount < 0L) {
            throw new CodecException("Integer overflow detected when calculating file byteCount.");
        }
        byte[] data = new byte[(int)byteCount];
        in.readFully(data);
        return this.decompress(data, options);
    }

    @Override
    public byte[] decompress(byte[] data) throws CodecException {
        return this.decompress(data, 0, data.length, data.length * 255);
    }

    @Override
    public byte[] decompress(byte[] data, CodecOptions options) throws CodecException {
        return this.decompress(data, 0, data.length, options.maxBytes);
    }

    public byte[] decompress(byte[] data, int inputOffset, int length, int outputLength) throws CodecException {
        Lz4Decompressor decompressor = new Lz4Decompressor();
        byte[] output = new byte[outputLength];
        try {
            decompressor.decompress(data, inputOffset, length, output, 0, outputLength);
        }
        catch (MalformedInputException e) {
            throw new CodecException(e);
        }
        return output;
    }
}

