/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import java.util.Stack;
import levelsets.algorithm.BandElement;

public class BandElementCache {
    private final Stack<BandElement> element_cache = new Stack();

    public BandElementCache(int capacity) {
        this.element_cache.ensureCapacity(capacity);
    }

    public final void recycleBandElement(BandElement elem) {
        if (this.element_cache.size() < this.element_cache.capacity()) {
            this.element_cache.push(elem);
        }
    }

    public final BandElement getRecycledBandElement(int x, int y, int z, double value) {
        if (this.element_cache.size() == 0) {
            return new BandElement(x, y, z, value);
        }
        BandElement elem = this.element_cache.pop();
        elem.setX(x);
        elem.setY(y);
        elem.setZ(z);
        elem.setValue(value);
        return elem;
    }

    public final BandElement getRecycledBandElement() {
        return this.getRecycledBandElement(0, 0, 0, 0.0);
    }
}

