/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.appose;

import java.util.function.Supplier;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.logic.NativeBoolType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.apposed.appose.NDArray;

public class DTypes {
    public static <T extends NativeType<T>> NDArray.DType dtype(T type) {
        if (type instanceof ByteType) {
            return NDArray.DType.INT8;
        }
        if (type instanceof ShortType) {
            return NDArray.DType.INT16;
        }
        if (type instanceof IntType) {
            return NDArray.DType.INT32;
        }
        if (type instanceof LongType) {
            return NDArray.DType.INT64;
        }
        if (type instanceof UnsignedByteType) {
            return NDArray.DType.UINT8;
        }
        if (type instanceof UnsignedShortType) {
            return NDArray.DType.UINT16;
        }
        if (type instanceof UnsignedIntType) {
            return NDArray.DType.UINT32;
        }
        if (type instanceof UnsignedLongType) {
            return NDArray.DType.UINT64;
        }
        if (type instanceof FloatType) {
            return NDArray.DType.FLOAT32;
        }
        if (type instanceof DoubleType) {
            return NDArray.DType.FLOAT64;
        }
        if (type instanceof ComplexFloatType) {
            return NDArray.DType.COMPLEX64;
        }
        if (type instanceof ComplexDoubleType) {
            return NDArray.DType.COMPLEX64;
        }
        if (type instanceof NativeBoolType) {
            return NDArray.DType.BOOL;
        }
        throw new IllegalArgumentException();
    }

    public static Supplier<? extends NativeType<?>> type(NDArray.DType dType) {
        switch (dType) {
            case INT8: {
                return ByteType::new;
            }
            case INT16: {
                return ShortType::new;
            }
            case INT32: {
                return IntType::new;
            }
            case INT64: {
                return LongType::new;
            }
            case UINT8: {
                return UnsignedByteType::new;
            }
            case UINT16: {
                return UnsignedShortType::new;
            }
            case UINT32: {
                return UnsignedIntType::new;
            }
            case UINT64: {
                return UnsignedLongType::new;
            }
            case FLOAT32: {
                return FloatType::new;
            }
            case FLOAT64: {
                return DoubleType::new;
            }
            case COMPLEX64: {
                return ComplexFloatType::new;
            }
            case COMPLEX128: {
                return ComplexDoubleType::new;
            }
            case BOOL: {
                return NativeBoolType::new;
            }
        }
        throw new IllegalArgumentException();
    }

    public static PrimitiveType primitiveType(NDArray.DType dType) {
        switch (dType) {
            case INT8: 
            case UINT8: {
                return PrimitiveType.BYTE;
            }
            case INT16: 
            case UINT16: {
                return PrimitiveType.SHORT;
            }
            case INT32: 
            case UINT32: {
                return PrimitiveType.INT;
            }
            case INT64: 
            case UINT64: {
                return PrimitiveType.LONG;
            }
            case FLOAT32: 
            case COMPLEX64: {
                return PrimitiveType.FLOAT;
            }
            case FLOAT64: 
            case COMPLEX128: {
                return PrimitiveType.DOUBLE;
            }
            case BOOL: {
                return PrimitiveType.BOOLEAN;
            }
        }
        throw new IllegalArgumentException();
    }
}

