/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plot.defaultplot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.scijava.plot.BarSeries;
import org.scijava.plot.BoxSeries;
import org.scijava.plot.CategoryAxis;
import org.scijava.plot.CategoryChart;
import org.scijava.plot.CategoryChartItem;
import org.scijava.plot.LineSeries;
import org.scijava.plot.NumberAxis;
import org.scijava.plot.defaultplot.AbstractPlot;
import org.scijava.plot.defaultplot.DefaultBarSeries;
import org.scijava.plot.defaultplot.DefaultBoxSeries;
import org.scijava.plot.defaultplot.DefaultCategoryAxis;
import org.scijava.plot.defaultplot.DefaultLineSeries;
import org.scijava.plot.defaultplot.DefaultNumberAxis;

public class DefaultCategoryChart<C>
extends AbstractPlot
implements CategoryChart {
    private final NumberAxis valueAxis = new DefaultNumberAxis();
    private final CategoryAxis categoryAxis = new DefaultCategoryAxis();
    private final List<CategoryChartItem> items = new LinkedList<CategoryChartItem>();

    @Override
    public LineSeries addLineSeries() {
        return this.addItem(new DefaultLineSeries());
    }

    @Override
    public BarSeries addBarSeries() {
        return this.addItem(new DefaultBarSeries());
    }

    @Override
    public BoxSeries addBoxSeries() {
        return this.addItem(new DefaultBoxSeries());
    }

    @Override
    public NumberAxis numberAxis() {
        return this.valueAxis;
    }

    @Override
    public CategoryAxis categoryAxis() {
        return this.categoryAxis;
    }

    @Override
    public List<CategoryChartItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public List<Object> getCategories() {
        List<Object> categories = this.unsortedCategories();
        return this.sortCategories(categories);
    }

    private List<Object> sortCategories(List<Object> categories) {
        if (this.categoryAxis.hasOrder()) {
            if (!(categories instanceof ArrayList)) {
                categories = new ArrayList<Object>(categories);
            }
            categories.sort(this.categoryAxis.getOrder());
        }
        return categories;
    }

    private List<Object> unsortedCategories() {
        if (this.categoryAxis.hasManualCategories()) {
            return this.categoryAxis.getManualCategories();
        }
        HashSet<Object> set = new HashSet<Object>();
        for (CategoryChartItem item : this.items) {
            set.addAll(item.getCategories());
        }
        return new ArrayList<Object>(set);
    }

    private <T extends CategoryChartItem> T addItem(T value) {
        this.items.add(value);
        return value;
    }
}

