/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMapped;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.ColorBar;
import edu.mines.jtk.mosaic.ContoursView;
import edu.mines.jtk.mosaic.GridView;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PlotFrame;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.mosaic.SequenceView;
import edu.mines.jtk.mosaic.TiledView;

public class SimplePlot
extends PlotFrame {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_WIDTH = 720;
    private static final int DEFAULT_HEIGHT = 550;
    private PlotPanel _panel = super.getPlotPanel();

    public SimplePlot() {
        this(Origin.LOWER_LEFT);
    }

    public SimplePlot(Origin origin) {
        super(SimplePlot.makePanel(origin));
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    public static SimplePlot asPoints(float[] f) {
        SimplePlot plot = new SimplePlot(Origin.LOWER_LEFT);
        plot.addPoints(f);
        return plot;
    }

    public static SimplePlot asPoints(Sampling s, float[] f) {
        SimplePlot plot = new SimplePlot(Origin.LOWER_LEFT);
        plot.addPoints(s, f);
        return plot;
    }

    public static SimplePlot asPoints(float[] x, float[] y) {
        SimplePlot plot = new SimplePlot(Origin.LOWER_LEFT);
        plot.addPoints(x, y);
        return plot;
    }

    public static SimplePlot asSequence(float[] f) {
        SimplePlot plot = new SimplePlot(Origin.LOWER_LEFT);
        plot.addSequence(f);
        return plot;
    }

    public static SimplePlot asSequence(Sampling s, float[] f) {
        SimplePlot plot = new SimplePlot(Origin.LOWER_LEFT);
        plot.addSequence(s, f);
        return plot;
    }

    public static SimplePlot asPixels(float[][] f) {
        SimplePlot plot = new SimplePlot(Origin.UPPER_LEFT);
        PixelsView pv = plot.addPixels(f);
        pv.setInterpolation(PixelsView.Interpolation.NEAREST);
        return plot;
    }

    public static SimplePlot asPixels(Sampling s1, Sampling s2, float[][] f) {
        SimplePlot plot = new SimplePlot(Origin.UPPER_LEFT);
        PixelsView pv = plot.addPixels(s1, s2, f);
        pv.setInterpolation(PixelsView.Interpolation.NEAREST);
        return plot;
    }

    public static SimplePlot asPoints(double[] f) {
        return SimplePlot.asPoints(SimplePlot.convertToFloat(f));
    }

    public static SimplePlot asPoints(Sampling s, double[] f) {
        return SimplePlot.asPoints(s, SimplePlot.convertToFloat(f));
    }

    public static SimplePlot asPoints(double[] x, double[] y) {
        return SimplePlot.asPoints(SimplePlot.convertToFloat(x), SimplePlot.convertToFloat(y));
    }

    public static SimplePlot asSequence(double[] f) {
        return SimplePlot.asSequence(SimplePlot.convertToFloat(f));
    }

    public static SimplePlot asSequence(Sampling s, double[] f) {
        return SimplePlot.asSequence(s, SimplePlot.convertToFloat(f));
    }

    public static SimplePlot asPixels(double[][] f) {
        return SimplePlot.asPixels(SimplePlot.convertToFloat(f));
    }

    public static SimplePlot asPixels(Sampling s1, Sampling s2, double[][] f) {
        return SimplePlot.asPixels(s1, s2, SimplePlot.convertToFloat(f));
    }

    public static SimplePlot asContours(float[][] f) {
        SimplePlot plot = new SimplePlot(Origin.UPPER_LEFT);
        plot.addContours(f);
        return plot;
    }

    public GridView addGrid() {
        return this._panel.addGrid();
    }

    public GridView addGrid(String parameters) {
        return this._panel.addGrid(parameters);
    }

    public PointsView addPoints(float[] f) {
        return this._panel.addPoints(f);
    }

    public PointsView addPoints(Sampling s, float[] f) {
        return this._panel.addPoints(s, f);
    }

    public PointsView addPoints(float[] x, float[] y) {
        return this._panel.addPoints(x, y);
    }

    public PointsView addPoints(double[] f) {
        return this.addPoints(SimplePlot.convertToFloat(f));
    }

    public PointsView addPoints(Sampling s, double[] f) {
        return this.addPoints(s, SimplePlot.convertToFloat(f));
    }

    public PointsView addPoints(double[] x, double[] y) {
        return this.addPoints(SimplePlot.convertToFloat(x), SimplePlot.convertToFloat(y));
    }

    public SequenceView addSequence(float[] f) {
        return this._panel.addSequence(f);
    }

    public SequenceView addSequence(Sampling s, float[] f) {
        return this._panel.addSequence(s, f);
    }

    public SequenceView addSequence(double[] f) {
        return this.addSequence(SimplePlot.convertToFloat(f));
    }

    public SequenceView addSequence(Sampling s, double[] f) {
        return this.addSequence(s, SimplePlot.convertToFloat(f));
    }

    public PixelsView addPixels(float[][] f) {
        return this._panel.addPixels(f);
    }

    public PixelsView addPixels(Sampling s1, Sampling s2, float[][] f) {
        return this._panel.addPixels(s1, s2, f);
    }

    public PixelsView addPixels(double[][] f) {
        return this.addPixels(SimplePlot.convertToFloat(f));
    }

    public PixelsView addPixels(Sampling s1, Sampling s2, double[][] f) {
        return this.addPixels(s1, s2, SimplePlot.convertToFloat(f));
    }

    public ContoursView addContours(float[][] f) {
        return this._panel.addContours(f);
    }

    public ContoursView addContours(Sampling s1, Sampling s2, float[][] f) {
        return this._panel.addContours(s1, s2, f);
    }

    public ContoursView addContours(double[][] f) {
        return this.addContours(SimplePlot.convertToFloat(f));
    }

    public ContoursView addContours(Sampling s1, Sampling s2, double[][] f) {
        return this.addContours(s1, s2, SimplePlot.convertToFloat(f));
    }

    public ColorBar addColorBar() {
        return this._panel.addColorBar();
    }

    public ColorBar addColorBar(String label) {
        return this._panel.addColorBar(label);
    }

    public ColorBar addColorBar(ColorMapped cm) {
        return this._panel.addColorBar(cm);
    }

    public ColorBar addColorBar(ColorMapped cm, String label) {
        return this._panel.addColorBar(cm, label);
    }

    public boolean add(TiledView tv) {
        return this._panel.addTiledView(tv);
    }

    public boolean remove(TiledView tv) {
        return this._panel.remove(tv);
    }

    public void addTitle(String title) {
        this._panel.addTitle(title);
    }

    @Override
    public void setTitle(String title) {
        this._panel.setTitle(title);
    }

    public void removeTitle() {
        this._panel.removeTitle();
    }

    public void setLimits(double hmin, double vmin, double hmax, double vmax) {
        this._panel.setLimits(hmin, vmin, hmax, vmax);
    }

    public void setHLimits(double hmin, double hmax) {
        this._panel.setHLimits(hmin, hmax);
    }

    public void setVLimits(double vmin, double vmax) {
        this._panel.setVLimits(vmin, vmax);
    }

    public void setLimitsDefault() {
        this._panel.setLimitsDefault();
    }

    public void setHLimitsDefault() {
        this._panel.setHLimitsDefault();
    }

    public void setVLimitsDefault() {
        this._panel.setVLimitsDefault();
    }

    public void setHInterval(double interval) {
        this._panel.setHInterval(interval);
    }

    public void setVInterval(double interval) {
        this._panel.setVInterval(interval);
    }

    public void setHLabel(String label) {
        this._panel.setHLabel(label);
    }

    public void setVLabel(String label) {
        this._panel.setVLabel(label);
    }

    public void setHFormat(String format) {
        this._panel.setHFormat(format);
    }

    public void setVFormat(String format) {
        this._panel.setVFormat(format);
    }

    public void setVRotated(boolean rotated) {
        this._panel.setVRotated(0, rotated);
    }

    @Override
    public PlotPanel getPlotPanel() {
        return this._panel;
    }

    private static PlotPanel makePanel(Origin origin) {
        if (origin == Origin.LOWER_LEFT) {
            return new PlotPanel(PlotPanel.Orientation.X1RIGHT_X2UP);
        }
        return new PlotPanel(PlotPanel.Orientation.X1DOWN_X2RIGHT);
    }

    private static float[] convertToFloat(double[] a) {
        int n = a.length;
        float[] b = new float[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (float)a[i];
        }
        return b;
    }

    private static float[][] convertToFloat(double[][] a) {
        int n2 = a.length;
        float[][] b = new float[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n1 = a[i2].length;
            b[i2] = new float[n1];
            for (int i1 = 0; i1 < n1; ++i1) {
                b[i2][i1] = (float)a[i2][i1];
            }
        }
        return b;
    }

    public static enum Origin {
        LOWER_LEFT,
        UPPER_LEFT;

    }
}

