/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class MedianFinder {
    private int[] _m = new int[2];
    private int _n;
    private float[] _w;
    private float[] _x;

    public MedianFinder(int n) {
        this._n = n;
        this._x = new float[n];
    }

    public float findMedian(float[] x) {
        Check.argument(this._n == x.length, "length of x is valid");
        ArrayMath.copy(x, this._x);
        int k = (this._n - 1) / 2;
        ArrayMath.quickPartialSort(k, this._x);
        float xmed = this._x[k];
        if (this._n % 2 == 0) {
            float xmin = this._x[this._n - 1];
            for (int i = this._n - 2; i > k; --i) {
                if (!(this._x[i] < xmin)) continue;
                xmin = this._x[i];
            }
            xmed = 0.5f * (xmed + xmin);
        }
        return xmed;
    }

    public float findMedian(float[] w, float[] x) {
        Check.argument(this._n == w.length, "length of w is valid");
        Check.argument(this._n == x.length, "length of x is valid");
        if (this._w == null) {
            this._w = new float[this._n];
        }
        ArrayMath.copy(w, this._w);
        ArrayMath.copy(x, this._x);
        if (this._n < 16) {
            return this.findMedianSmallN(this._w, this._x);
        }
        return this.findMedianLargeN(this._w, this._x);
    }

    private static int med3(float[] a, int i, int j, int k) {
        return a[i] < a[j] ? (a[j] < a[k] ? j : (a[i] < a[k] ? k : i)) : (a[j] > a[k] ? j : (a[i] > a[k] ? k : i));
    }

    private static void swap(float[] a, float[] b, int i, int j) {
        float ai = a[i];
        a[i] = a[j];
        a[j] = ai;
        float bi = b[i];
        b[i] = b[j];
        b[j] = bi;
    }

    private static void swap(float[] a, float[] b, int i, int j, int n) {
        while (n > 0) {
            float ai = a[i];
            a[i] = a[j];
            a[j] = ai;
            float bi = b[i];
            b[i++] = b[j];
            b[j++] = bi;
            --n;
        }
    }

    private static void insertionSort(float[] w, float[] x, int p, int q) {
        for (int i = p + 1; i <= q; ++i) {
            for (int j = i; j > p && x[j - 1] > x[j]; --j) {
                MedianFinder.swap(w, x, j, j - 1);
            }
        }
    }

    private static void quickPartition(float[] w, float[] x, int[] m) {
        int p = m[0];
        int q = m[1];
        int k = MedianFinder.med3(x, p, (p + q) / 2, q);
        float y = x[k];
        int a = p;
        int b = p;
        int c = q;
        int d = q;
        while (true) {
            if (b <= c && x[b] <= y) {
                if (x[b] == y) {
                    MedianFinder.swap(w, x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= y) {
                if (x[c] == y) {
                    MedianFinder.swap(w, x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MedianFinder.swap(w, x, b, c);
            ++b;
            --c;
        }
        int r = Math.min(a - p, b - a);
        int s = Math.min(d - c, q - d);
        int t = q + 1;
        MedianFinder.swap(w, x, p, b - r, r);
        MedianFinder.swap(w, x, b, t - s, s);
        m[0] = p + (b - a);
        m[1] = q - (d - c);
    }

    private float findMedianSmallN(float[] w, float[] x) {
        for (int i = 1; i < this._n; ++i) {
            for (int j = i; j > 0 && x[j - 1] > x[j]; --j) {
                MedianFinder.swap(w, x, j, j - 1);
            }
        }
        float ws = 0.0f;
        for (int i = 0; i < this._n; ++i) {
            ws += w[i];
        }
        float wh = 0.5f * ws;
        int kl = 0;
        for (float wl = w[kl]; wl < wh; wl += w[++kl]) {
        }
        int kr = this._n - 1;
        for (float wr = w[kr]; wr < wh; wr += w[--kr]) {
        }
        if (kl == kr) {
            return x[kl];
        }
        return 0.5f * (x[kl] + x[kr]);
    }

    private float findMedianLargeN(float[] w, float[] x) {
        float xnot;
        int q;
        int p;
        int p0 = p = 0;
        int q0 = q = this._n - 1;
        float wc = 0.0f;
        float xmed = xnot = Float.MAX_VALUE;
        while (p < q && xmed == xnot) {
            int i;
            this._m[0] = p;
            this._m[1] = q;
            MedianFinder.quickPartition(w, x, this._m);
            int pp = this._m[0];
            int qq = this._m[1];
            float wl = 0.0f;
            for (int i2 = p; i2 < pp; ++i2) {
                wl += w[i2];
            }
            float wm = 0.0f;
            for (int i3 = pp; i3 <= qq; ++i3) {
                wm += w[i3];
            }
            float wr = 0.0f;
            for (int i4 = qq + 1; i4 <= q; ++i4) {
                wr += w[i4];
            }
            float dl = wc + wl - wm - wr;
            float dr = wc + wl + wm - wr;
            if (dl > 0.0f) {
                q = pp - 1;
                wc -= wm + wr;
                continue;
            }
            if (dr < 0.0f) {
                p = qq + 1;
                wc += wl + wm;
                continue;
            }
            if (dl == 0.0f) {
                float xmax = x[p0];
                for (i = pp - 1; i > p0; --i) {
                    if (!(x[i] > xmax)) continue;
                    xmax = x[i];
                }
                xmed = 0.5f * (x[pp] + xmax);
                continue;
            }
            if (dr == 0.0f) {
                float xmin = x[q0];
                for (i = qq + 1; i < q0; ++i) {
                    if (!(x[i] < xmin)) continue;
                    xmin = x[i];
                }
                xmed = 0.5f * (x[qq] + xmin);
                continue;
            }
            xmed = x[pp];
        }
        if (xmed == xnot) {
            xmed = x[p];
        }
        return xmed;
    }
}

