/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;

public class ConcurrentIntFunctionCache<T>
implements IntFunction<T> {
    private final IntFunction<T> function;
    private Object[] values = new Object[16];

    public ConcurrentIntFunctionCache(IntFunction<T> function) {
        this.function = function;
    }

    @Override
    public T apply(int input) {
        Object output;
        if (input < 0) {
            throw new IllegalArgumentException("input must be positive");
        }
        if (input >= this.values.length) {
            this.grow(input);
        }
        if ((output = this.values[input]) == null) {
            this.values[input] = output = Objects.requireNonNull(this.function.apply(input));
        }
        return (T)output;
    }

    private synchronized void grow(int input) {
        int capacity;
        if (input < this.values.length) {
            return;
        }
        for (capacity = this.values.length; capacity <= input; capacity *= 2) {
        }
        this.values = Arrays.copyOf(this.values, capacity);
    }
}

