/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.plugin.HyperStackReducer;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class BatchOpener {
    private static final int TIFF_FIELD_TYPE_SHORT = 3;
    private static final int TIFF_FIELD_TYPE_LONG = 4;

    public static ImagePlus openFirstChannel(String path) {
        ImagePlus[] channels = BatchOpener.open(path);
        if (channels == null) {
            return null;
        }
        if (channels.length == 0) {
            return null;
        }
        return channels[0];
    }

    public static ImagePlus openParticularChannel(String path, int i) throws NoSuchChannelException {
        ImagePlus[] channels = BatchOpener.open(path);
        if (channels == null) {
            return null;
        }
        if (i >= channels.length || i < 0) {
            throw new NoSuchChannelException("No channel " + i + " in file " + path + ", which has " + channels.length + " channels.  (Channel indices start at zero.)");
        }
        return channels[i];
    }

    public static ImagePlus[] open(String path) {
        ChannelsAndLoader cal;
        try {
            cal = BatchOpener.openToChannelsAndLoader(path);
        }
        catch (ImageLoaderException e) {
            return null;
        }
        if (cal == null) {
            return null;
        }
        return cal.channels;
    }

    public static ChannelsAndLoader openToChannelsAndLoader(String path) throws ImageLoaderException {
        File imageFile;
        File imageDir;
        File commonDir;
        String[] list;
        String loaderUsed = null;
        File file = new File(path);
        byte[] buf = new byte[132];
        try {
            FileInputStream is = new FileInputStream(path);
            ((InputStream)is).read(buf, 0, 132);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            return null;
        }
        String name = file.getName();
        String nameLowerCase = name.toLowerCase();
        String directory = file.getParent();
        byte[] tiffMagicIntel = new byte[]{73, 73, 42, 0};
        byte[] tiffMagicMotorola = new byte[]{77, 77, 0, 42};
        byte[] firstFour = new byte[4];
        System.arraycopy(buf, 0, firstFour, 0, 4);
        boolean tiffLittleEndian = Arrays.equals(tiffMagicIntel, firstFour);
        boolean tiffBigEndian = Arrays.equals(tiffMagicMotorola, firstFour);
        if (tiffLittleEndian || tiffBigEndian) {
            ImagePlus[] result;
            boolean isLSM;
            RandomAccessFile in = null;
            try {
                in = new RandomAccessFile(path, "r");
            }
            catch (IOException e) {
                return null;
            }
            if (in == null) {
                return null;
            }
            try {
                isLSM = BatchOpener.findLSMTag(in, tiffLittleEndian);
            }
            catch (IOException e) {
                return null;
            }
            if (isLSM) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    return null;
                }
                loaderUsed = "LSM_Toolbox";
                ClassLoader loader = IJ.getClassLoader();
                if (loader == null) {
                    throw new RuntimeException("IJ.getClassLoader() failed (!)");
                }
                try {
                    ImagePlus[] result2;
                    Class<?> c = loader.loadClass("org.imagearchive.lsm.toolbox.Reader");
                    Object newInstance = c.newInstance();
                    Class[] parameterTypes = new Class[]{String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE};
                    Method m = c.getMethod("open", parameterTypes);
                    Object[] parameters = new Object[]{file.getParent(), file.getName(), false, false, false};
                    Object invokeResult = m.invoke(newInstance, parameters);
                    if (invokeResult instanceof ImagePlus && ((ImagePlus)invokeResult).isComposite()) {
                        CompositeImage composite = (CompositeImage)invokeResult;
                        result2 = BatchOpener.splitChannelsToArray((ImagePlus)composite, true);
                    } else {
                        result2 = invokeResult instanceof ImagePlus ? new ImagePlus[]{(ImagePlus)invokeResult} : (ImagePlus[])invokeResult;
                    }
                    return new ChannelsAndLoader(result2, loaderUsed);
                }
                catch (IllegalArgumentException e) {
                    throw new ImageLoaderException("There was an illegal argument when trying to invoke the LSM_Toolbox reader: " + e);
                }
                catch (InvocationTargetException e) {
                    Throwable realException = e.getTargetException();
                    throw new ImageLoaderException("There was an exception thrown by the LSM_Toolbox plugin: " + realException);
                }
                catch (ClassNotFoundException e) {
                    throw new ImageLoaderException("The LSM_Toolbox plugin was not found: " + e);
                }
                catch (InstantiationException e) {
                    throw new ImageLoaderException("Failed to instantiate the LSM_Toolbox reader: " + e);
                }
                catch (IllegalAccessException e) {
                    throw new ImageLoaderException("IllegalAccessException when trying to create an instance of the LSM_Toolbox reader: " + e);
                }
                catch (NoSuchMethodException e) {
                    throw new ImageLoaderException("There was a NoSuchMethodException when trying to invoke the LSM_Toolbox reader: " + e);
                }
                catch (SecurityException e) {
                    throw new ImageLoaderException("There was a SecurityException when trying to invoke the LSM_Toolbox reader: " + e);
                }
            }
            byte[] leicaBytes = new byte[44];
            long seekTo = -1L;
            try {
                seekTo = in.length() - 1658L;
                in.seek(seekTo);
                in.readFully(leicaBytes);
            }
            catch (IOException e) {
                IJ.error((String)("Couldn't seek to " + seekTo + " in " + path));
                return null;
            }
            String leicaString = new String(leicaBytes);
            if (leicaString.equals("Leica Lasertechnik GmbH, Heidelberg, Germany")) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    IJ.error((String)"Couldn't close the Leica TIFF file.");
                    return null;
                }
                ClassLoader loader = IJ.getClassLoader();
                if (loader == null) {
                    IJ.error((String)"IJ.getClassLoader() failed (!)");
                    return null;
                }
                try {
                    loaderUsed = "Leica_SP_Reader";
                    Class<?> c = loader.loadClass("leica.Leica_SP_Reader");
                    Object newInstance = c.newInstance();
                    Class[] parameterTypes = new Class[]{String.class};
                    Object[] parameters = new Object[]{path};
                    Method m = c.getMethod("run", parameterTypes);
                    m.invoke(newInstance, parameters);
                    parameterTypes = new Class[]{};
                    parameters = new Object[]{};
                    m = c.getMethod("getNumberOfChannels", parameterTypes);
                    Integer n = (Integer)m.invoke(newInstance, parameters);
                    if (n < 1) {
                        IJ.error((String)("Error: got " + n + " channels from " + path + " with the Leica SP Reader"));
                        return null;
                    }
                    ImagePlus[] result3 = new ImagePlus[n.intValue()];
                    for (int i = 0; i < n; ++i) {
                        parameterTypes = new Class[]{Integer.TYPE};
                        parameters = new Object[]{new Integer(i)};
                        m = c.getMethod("getImage", parameterTypes);
                        result3[i] = (ImagePlus)m.invoke(newInstance, parameters);
                    }
                    return new ChannelsAndLoader(result3, loaderUsed);
                }
                catch (IllegalArgumentException e) {
                    IJ.error((String)("There was an illegal argument when trying to invoke a method on the Leica SP Reader plugin: " + e));
                }
                catch (InvocationTargetException e) {
                    Throwable realException = e.getTargetException();
                    IJ.error((String)("There was an exception thrown by the Leica SP Reader plugin: " + realException));
                }
                catch (ClassNotFoundException e) {
                    IJ.error((String)("The Leica SP Reader plugin was not found: " + e));
                }
                catch (InstantiationException e) {
                    IJ.error((String)("Failed to instantiate the Leica SP Reader plugin: " + e));
                }
                catch (IllegalAccessException e) {
                    IJ.error((String)("IllegalAccessException when trying the Leica SP Reader plugin: " + e));
                }
                catch (NoSuchMethodException e) {
                    IJ.error((String)("Couldn't find a method in the Leica SP Reader plugin: " + e));
                }
                catch (SecurityException e) {
                    IJ.error((String)("There was a SecurityException when trying to invoke a method of the Leica SP Reader plugin: " + e));
                }
                return null;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                IJ.error((String)"Couldn't close the file.");
                return null;
            }
            loaderUsed = "ImageJ TIFF";
            ImagePlus invokeResult = IJ.openImage((String)path);
            if (invokeResult instanceof ImagePlus && invokeResult.isComposite()) {
                CompositeImage composite = (CompositeImage)invokeResult;
                result = BatchOpener.splitChannelsToArray((ImagePlus)composite, true);
            } else {
                result = new ImagePlus[]{invokeResult};
            }
            return new ChannelsAndLoader(result, loaderUsed);
        }
        ImagePlus imp = null;
        if (buf[54] == 57 && buf[55] == 48) {
            loaderUsed = "Biorad_Reader";
            imp = (ImagePlus)IJ.runPlugIn((String)"Biorad_Reader", (String)path);
            if (imp == null) {
                return null;
            }
            if (imp != null && imp.getWidth() == 0) {
                return null;
            }
            ImagePlus[] i = new ImagePlus[]{IJ.openImage((String)path)};
            return new ChannelsAndLoader(i, loaderUsed);
        }
        if (buf[0] == 0 && buf[1] == 0 && buf[2] == 0 && buf[3] == 3) {
            loaderUsed = "DM3_Reader";
            String[] possibleClassNames = new String[]{"DM3_Reader", "io.DM3_Reader"};
            imp = BatchOpener.findAndRunPlugIn(possibleClassNames, path);
            if (imp == null) {
                return null;
            }
            if (imp != null && imp.getWidth() == 0) {
                return null;
            }
            ImagePlus[] i = new ImagePlus[]{IJ.openImage((String)path)};
            return new ChannelsAndLoader(i, loaderUsed);
        }
        if (buf[0] == 105 && buf[1] == 105 && buf[2] == 105 && buf[3] == 105 || buf[0] == 109 && buf[1] == 109 && buf[2] == 109 && buf[3] == 109) {
            loaderUsed = "IPLab_Reader";
            String[] possibleClassNames = new String[]{"IPLab_Reader", "io.IPLab_Reader"};
            imp = BatchOpener.findAndRunPlugIn(possibleClassNames, path);
            if (imp == null) {
                return null;
            }
            if (imp != null && imp.getWidth() == 0) {
                return null;
            }
            ImagePlus[] i = new ImagePlus[]{IJ.openImage((String)path)};
            return new ChannelsAndLoader(i, loaderUsed);
        }
        if (buf[0] == 35 && buf[1] == 32 && buf[2] == 65 && buf[3] == 109 && buf[4] == 105 && buf[5] == 114 && buf[6] == 97 && buf[7] == 77 && buf[8] == 101 && buf[9] == 115 && buf[10] == 104 && buf[11] == 32) {
            loaderUsed = "AmiraMeshReader_";
            ImagePlus[] i = new ImagePlus[1];
            imp = (ImagePlus)IJ.runPlugIn((String)"AmiraMeshReader_", (String)path);
            if (imp == null) {
                return null;
            }
            i[0] = imp;
            return new ChannelsAndLoader(i, loaderUsed);
        }
        if (buf[0] == 75 && buf[1] == 65 && buf[2] == 74 && buf[3] == 0) {
            loaderUsed = "InstantImager_Reader";
            String[] possibleClassNames = new String[]{"InstantImager_Reader", "io.InstantImager_Reader"};
            imp = BatchOpener.findAndRunPlugIn(possibleClassNames, path);
            if (imp == null) {
                return null;
            }
            if (imp != null && imp.getWidth() == 0) {
                return null;
            }
            ImagePlus[] i = new ImagePlus[]{imp};
            return new ChannelsAndLoader(i, loaderUsed);
        }
        if ((name.endsWith(".bin") || name.endsWith(".bin.gz")) && (list = (commonDir = new File((imageDir = new File((imageFile = new File(directory, name)).getParent())).getParent())).list()) != null) {
            for (int e = 0; e < list.length; ++e) {
                File headerFile;
                File f = new File(commonDir.getPath(), list[e]);
                if (!f.isDirectory() || !f.getName().equals(imageDir.getName() + ".study") || !(headerFile = new File(f.getPath(), "images")).exists()) continue;
                loaderUsed = "TorstenRaw_GZ_Reader";
                ImagePlus[] i = new ImagePlus[1];
                String[] possibleClassNames = new String[]{"io.TorstenRaw_GZ_Reader", "TorstenRaw_GZ_Reader"};
                imp = BatchOpener.findAndRunPlugIn(possibleClassNames, path);
                if (imp == null) {
                    return null;
                }
                i[0] = imp;
                return new ChannelsAndLoader(i, loaderUsed);
            }
        }
        return null;
    }

    private static ImagePlus findAndRunPlugIn(String[] possibleClassNames, String path) {
        ImagePlus imp = null;
        for (int si = 0; si < possibleClassNames.length; ++si) {
            String className = possibleClassNames[si];
            try {
                Class<?> c = Class.forName(className);
                PlugIn p = (PlugIn)c.newInstance();
                p.run(path);
                imp = (ImagePlus)p;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return imp;
    }

    public static ImagePlus[] splitChannelsToArray(ImagePlus imp, boolean closeAfter) {
        if (!imp.isComposite()) {
            String error = "splitChannelsToArray was called on a non-composite image";
            IJ.error((String)error);
            return null;
        }
        int width = imp.getWidth();
        int height = imp.getHeight();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int bitDepth = imp.getBitDepth();
        int size = slices * frames;
        ImagePlus[] result = new ImagePlus[channels];
        FileInfo fi = imp.getOriginalFileInfo();
        HyperStackReducer reducer = new HyperStackReducer(imp);
        for (int c = 1; c <= channels; ++c) {
            ImageStack stack2 = new ImageStack(width, height, size);
            stack2.setPixels(imp.getProcessor().getPixels(), 1);
            ImagePlus imp2 = new ImagePlus("C" + c + "-" + imp.getTitle(), stack2);
            stack2.setPixels(null, 1);
            imp.setPosition(c, 1, 1);
            imp2.setDimensions(1, slices, frames);
            reducer.reduce(imp2);
            imp2.setOpenAsHyperStack(true);
            imp2.setFileInfo(fi);
            result[c - 1] = imp2;
        }
        imp.changes = false;
        if (closeAfter) {
            imp.close();
        }
        return result;
    }

    private static boolean findLSMTag(RandomAccessFile in, boolean littleEndian) throws IOException {
        return BatchOpener.findTag(34412L, in, littleEndian);
    }

    private static boolean findTag(long tagToLookFor, RandomAccessFile in, boolean littleEndian) throws IOException {
        short byteOrder = in.readShort();
        int magicNumber = BatchOpener.getShort(in, littleEndian);
        int offset = BatchOpener.getInt(in, littleEndian);
        if (magicNumber != 42) {
            IJ.error((String)"Not really a TIFF file (BUG: should have been detected earlier.)");
        }
        if (offset < 0) {
            IJ.error((String)"TIFF file probably corrupted: offset is negative");
            return false;
        }
        while (offset > 0) {
            in.seek(offset);
            int nEntries = BatchOpener.getShort(in, littleEndian);
            if (nEntries < 1 || nEntries > 1000) {
                return false;
            }
            for (int i = 0; i < nEntries; ++i) {
                int tag = BatchOpener.getShort(in, littleEndian);
                int fieldType = BatchOpener.getShort(in, littleEndian);
                int count = BatchOpener.getInt(in, littleEndian);
                int value = BatchOpener.getValue(in, littleEndian, fieldType, count);
                if ((long)tag != tagToLookFor) continue;
                return true;
            }
            offset = BatchOpener.getInt(in, littleEndian);
        }
        return false;
    }

    private static int getInt(RandomAccessFile in, boolean littleEndian) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if (littleEndian) {
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    private static int getShort(RandomAccessFile in, boolean littleEndian) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        if (littleEndian) {
            return (b2 << 8) + b1;
        }
        return (b1 << 8) + b2;
    }

    private static int getValue(RandomAccessFile in, boolean littleEndian, int fieldType, int count) throws IOException {
        int value = 0;
        if (fieldType == 3 && count == 1) {
            value = BatchOpener.getShort(in, littleEndian);
            int unused = BatchOpener.getShort(in, littleEndian);
        } else {
            value = BatchOpener.getInt(in, littleEndian);
        }
        return value;
    }

    public static class ChannelsAndLoader {
        public ImagePlus[] channels;
        public String loaderUsed;

        public ChannelsAndLoader(ImagePlus[] channels, String loaderUsed) {
            this.channels = channels;
            this.loaderUsed = loaderUsed;
        }
    }

    public static class ImageLoaderException
    extends Exception {
        ImageLoaderException(String message) {
            super(message);
        }
    }

    public static class NoSuchChannelException
    extends Exception {
        NoSuchChannelException(String message) {
            super(message);
        }
    }
}

