/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;

public interface AxisMetadata {
    public Axis[] getAxes();

    default public Axis getAxis(int i) {
        return this.getAxes()[i];
    }

    default public String[] getAxisLabels() {
        return (String[])Arrays.stream(this.getAxes()).map(Axis::getName).toArray(String[]::new);
    }

    default public String[] getAxisTypes() {
        return (String[])Arrays.stream(this.getAxes()).map(Axis::getType).toArray(String[]::new);
    }

    default public String[] getUnits() {
        return (String[])Arrays.stream(this.getAxes()).map(Axis::getUnit).toArray(String[]::new);
    }

    default public int indexOf(String label) {
        for (int i = 0; i < this.getAxisLabels().length; ++i) {
            if (!this.getAxisLabels()[i].equals(label)) continue;
            return i;
        }
        return -1;
    }

    default public int[] indexesOfType(String type) {
        String[] types = this.getAxisTypes();
        return IntStream.range(0, this.getAxisTypes().length).filter(i -> types[i].equals(type)).toArray();
    }
}

