/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.transforms;

import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.AbstractLinearSpatialTransform;

public class AffineSpatialTransform
extends AbstractLinearSpatialTransform<double[]> {
    public double[] affine;
    public transient AffineGet transform;

    public AffineSpatialTransform(double[] affine) {
        super("affine");
        this.affine = affine;
        this.buildTransform(affine);
    }

    public AffineSpatialTransform(N5Reader n5, String path) {
        super("affine");
        this.affine = this.getParameters(n5);
        this.buildTransform(this.affine);
    }

    public AffineSpatialTransform(String path) {
        super("affine", path);
        this.affine = null;
    }

    @Override
    public AffineGet buildTransform(double[] parameters) {
        this.affine = parameters;
        if (parameters.length == 6) {
            AffineTransform2D tmp = new AffineTransform2D();
            tmp.set(parameters);
            this.transform = tmp;
        } else if (parameters.length == 12) {
            AffineTransform3D tmp = new AffineTransform3D();
            tmp.set(parameters);
            this.transform = tmp;
        } else {
            int nd = (int)Math.floor(Math.sqrt(parameters.length));
            AffineTransform tmp = new AffineTransform(nd);
            tmp.set(parameters);
            this.transform = tmp;
        }
        return this.transform;
    }

    @Override
    public AffineGet getTransform() {
        if (this.affine != null && this.transform == null) {
            this.buildTransform(this.affine);
        }
        return this.transform;
    }

    @Override
    public double[] getParameters(N5Reader n5) {
        return AffineSpatialTransform.getDoubleArray(n5, this.getParameterPath());
    }
}

