/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import mpicbg.ij.blockmatching.BlockMatching;
import mpicbg.ij.plugin.AbstractBlockMatching;
import mpicbg.models.AbstractModel;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.SpringMesh;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.Vertex;
import mpicbg.trakem2.align.Util;
import mpicbg.trakem2.util.Downsampler;
import net.imglib2.KDTree;
import net.imglib2.RealPoint;
import net.imglib2.RealPointSampleList;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.neighborsearch.NearestNeighborSearchOnKDTree;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;

public class BlockMatching_TestParameters
extends AbstractBlockMatching {
    static final int minGridSize = 8;
    static final boolean exportDisplacementVectors = true;
    protected ImagePlus imp1;
    protected ImageStack stack;

    protected final boolean setup() {
        this.imp1 = IJ.getImage();
        if (this.imp1 == null) {
            IJ.error((String)"Please open an image stack first.");
            return false;
        }
        this.stack = this.imp1.getStack();
        if (this.stack.getSize() < 2) {
            IJ.error((String)"The image stack should contain at least two slices.");
            return false;
        }
        GenericDialog gdBlockMatching = new GenericDialog("Test Block Matching Parameters");
        this.addFields(gdBlockMatching);
        gdBlockMatching.showDialog();
        if (gdBlockMatching.wasCanceled()) {
            return false;
        }
        this.readFields(gdBlockMatching);
        return true;
    }

    public ArrayList<PointMatch> match(FloatProcessor ip1, FloatProcessor ip2, FloatProcessor ip1Mask, FloatProcessor ip2Mask) {
        SpringMesh mesh = new SpringMesh(meshResolution, (double)this.imp1.getWidth(), (double)this.imp1.getHeight(), 1.0, 1000.0, (double)0.9f);
        ArrayList<PointMatch> pm12 = new ArrayList<PointMatch>();
        ArrayList v1 = mesh.getVertices();
        TranslationModel2D ct = new TranslationModel2D();
        try {
            BlockMatching.matchByMaximalPMCC((FloatProcessor)ip1, (FloatProcessor)ip2, (FloatProcessor)ip1Mask, (FloatProcessor)ip2Mask, (double)scale, (CoordinateTransform)ct, (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)minR, (float)rodR, (float)maxCurvatureR, (Collection)v1, pm12, (ErrorStatistic)new ErrorStatistic(1));
        }
        catch (InterruptedException e) {
            IJ.log((String)"Block Matching interrupted.");
            return pm12;
        }
        catch (ExecutionException e) {
            IJ.log((String)"Execution Exception occured during Block Matching.");
            e.printStackTrace();
            return pm12;
        }
        return pm12;
    }

    protected void filter(ArrayList<PointMatch> pm12) {
        AbstractModel model = Util.createModel((int)localModelIndex);
        try {
            model.localSmoothnessFilter(pm12, pm12, (double)localRegionSigma, (double)maxLocalEpsilon, (double)maxLocalTrust);
        }
        catch (NotEnoughDataPointsException e) {
            pm12.clear();
        }
        catch (IllDefinedDataPointsException e) {
            pm12.clear();
        }
    }

    protected void display(ArrayList<PointMatch> pm12, RealPointSampleList<ARGBType> maskSamples, ImagePlus impTable, ColorProcessor ipTable, int w, int h, int i, int j) {
        if (pm12.size() > 0) {
            ImagePlusImgFactory factory = new ImagePlusImgFactory();
            KDTree kdtreeMatches = new KDTree(BlockMatching_TestParameters.matches2ColorSamples(pm12));
            KDTree kdtreeMask = new KDTree(maskSamples);
            ImagePlusImg img = factory.create(new long[]{this.imp1.getWidth(), this.imp1.getHeight()}, (NativeType)new ARGBType());
            BlockMatching_TestParameters.drawNearestNeighbor(img, new NearestNeighborSearchOnKDTree(kdtreeMatches), new NearestNeighborSearchOnKDTree(kdtreeMask));
            try {
                ImagePlus impVis = img.getImagePlus();
                ColorProcessor ipVis = (ColorProcessor)impVis.getProcessor();
                while (ipVis.getWidth() > meshResolution * 8) {
                    ipVis = Downsampler.downsampleColorProcessor((ColorProcessor)ipVis);
                }
                ipTable.copyBits((ImageProcessor)ipVis, i * w + w, j * h + h, 0);
                impTable.updateAndDraw();
            }
            catch (ImgLibException e) {
                IJ.log((String)"ImgLib2 Exception, vectors could not be painted.");
                e.printStackTrace();
            }
        } else {
            Roi roi = new Roi(i * w + w, j * h + h, w, h);
            Color c = IJ.getInstance().getForeground();
            ipTable.setColor(Color.WHITE);
            ipTable.fill(roi);
            ipTable.setColor(c);
        }
    }

    public void run(String arg) {
        if (!this.setup()) {
            return;
        }
        int w = this.stack.getWidth();
        int h = this.stack.getHeight();
        while (w > meshResolution * 8) {
            w /= 2;
            h /= 2;
        }
        ColorProcessor ipTable = new ColorProcessor(w * this.stack.getSize() + w, h * this.stack.getSize() + h);
        ColorProcessor ipScale = new ColorProcessor(w, h);
        Color c = IJ.getInstance().getForeground();
        ipScale.setColor(Color.WHITE);
        ipScale.fill();
        ipScale.setColor(c);
        mpicbg.ij.util.Util.colorCircle((ColorProcessor)ipScale);
        ipTable.copyBits((ImageProcessor)ipScale, 0, 0, 0);
        for (int i = 0; i < this.stack.getSize(); ++i) {
            Object ip = (ColorProcessor)this.stack.getProcessor(i + 1).convertToRGB();
            while (ip.getWidth() > w) {
                ip = Downsampler.downsampleColorProcessor((ColorProcessor)ip);
            }
            ipTable.copyBits((ImageProcessor)ip, i * w + w, 0, 0);
            ipTable.copyBits((ImageProcessor)ip, 0, i * h + h, 0);
        }
        ImagePlus impTable = new ImagePlus("Block Matching Results", (ImageProcessor)ipTable);
        impTable.show();
        SpringMesh mesh = new SpringMesh(meshResolution, (double)this.imp1.getWidth(), (double)this.imp1.getHeight(), 1.0, 1000.0, (double)0.9f);
        ArrayList vertices = mesh.getVertices();
        RealPointSampleList maskSamples = new RealPointSampleList(2);
        for (Vertex vertex : vertices) {
            maskSamples.add(new RealPoint(vertex.getL()), (Object)new ARGBType(-1));
        }
        for (int i = 0; i < this.stack.getSize(); ++i) {
            for (int j = i + 1; j < this.stack.getSize(); ++j) {
                FloatProcessor ip1 = (FloatProcessor)this.stack.getProcessor(i + 1).convertToFloat().duplicate();
                FloatProcessor ip2 = (FloatProcessor)this.stack.getProcessor(j + 1).convertToFloat().duplicate();
                FloatProcessor ip1Mask = BlockMatching_TestParameters.createMask((ColorProcessor)this.stack.getProcessor(i + 1).convertToRGB());
                FloatProcessor ip2Mask = BlockMatching_TestParameters.createMask((ColorProcessor)this.stack.getProcessor(j + 1).convertToRGB());
                ArrayList<PointMatch> pm12 = this.match(ip1, ip2, ip1Mask, ip2Mask);
                IJ.log((String)(i + " > " + j + " " + pm12.size() + " blockmatch candidates found."));
                if (useLocalSmoothnessFilter) {
                    this.filter(pm12);
                    IJ.log((String)(pm12.size() + " blockmatch candidates passed local smoothness filter."));
                }
                this.display(pm12, (RealPointSampleList<ARGBType>)maskSamples, impTable, ipTable, w, h, i, j);
                ArrayList<PointMatch> pm21 = this.match(ip2, ip1, ip2Mask, ip1Mask);
                IJ.log((String)(i + " < " + j + " " + pm21.size() + " blockmatch candidates found."));
                if (useLocalSmoothnessFilter) {
                    this.filter(pm21);
                    IJ.log((String)(pm21.size() + " blockmatch candidates passed local smoothness filter."));
                }
                this.display(pm21, (RealPointSampleList<ARGBType>)maskSamples, impTable, ipTable, w, h, j, i);
            }
        }
    }
}

