/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.histogram;

import java.util.ArrayList;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.HistogramNd;
import net.imglib2.type.numeric.IntegerType;

public class Integer1dBinMapper<T extends IntegerType<T>>
implements BinMapper1d<T> {
    private final long bins;
    private final long minVal;
    private final long maxVal;
    private final boolean tailBins;

    public Integer1dBinMapper(long minVal, long numBins, boolean tailBins) {
        this.bins = numBins;
        this.tailBins = tailBins;
        this.minVal = minVal;
        this.maxVal = tailBins ? minVal + numBins - 1L - 2L : minVal + numBins - 1L;
        if (this.bins <= 0L || tailBins && this.bins <= 2L) {
            throw new IllegalArgumentException("invalid Integer1dBinMapper: no data bins specified");
        }
    }

    @Override
    public long getBinCount() {
        return this.bins;
    }

    @Override
    public long map(T value) {
        long pos;
        long val = value.getIntegerLong();
        if (val >= this.minVal && val <= this.maxVal) {
            pos = val - this.minVal;
            if (this.tailBins) {
                ++pos;
            }
        } else {
            pos = this.tailBins ? (val < this.minVal ? 0L : this.bins - 1L) : (val < this.minVal ? Long.MIN_VALUE : Long.MAX_VALUE);
        }
        return pos;
    }

    @Override
    public void getCenterValue(long binPos, T value) {
        long val = this.tailBins ? (binPos == 0L ? this.minVal - 1L : (binPos == this.bins - 1L ? this.maxVal + 1L : this.minVal + binPos - 1L)) : this.minVal + binPos;
        value.setInteger(val);
    }

    @Override
    public void getLowerBound(long binPos, T value) {
        if (this.tailBins && (binPos == 0L || binPos == this.bins - 1L)) {
            if (binPos == 0L) {
                value.setInteger(-9223372036854775807L);
            } else {
                value.setInteger(this.maxVal + 1L);
            }
        } else {
            this.getCenterValue(binPos, value);
        }
    }

    @Override
    public void getUpperBound(long binPos, T value) {
        if (this.tailBins && (binPos == 0L || binPos == this.bins - 1L)) {
            if (binPos == 0L) {
                value.setInteger(this.minVal - 1L);
            } else {
                value.setInteger(0x7FFFFFFFFFFFFFFEL);
            }
        } else {
            this.getCenterValue(binPos, value);
        }
    }

    @Override
    public boolean includesLowerBound(long binPos) {
        return true;
    }

    @Override
    public boolean includesUpperBound(long binPos) {
        return true;
    }

    @Override
    public boolean hasTails() {
        return this.tailBins;
    }

    @Override
    public Integer1dBinMapper<T> copy() {
        return new Integer1dBinMapper<T>(this.minVal, this.bins, this.tailBins);
    }

    public static <K extends IntegerType<K>> HistogramNd<K> histogramNd(long[] minVals, long[] numBins, boolean[] tailBins) {
        if (minVals.length != numBins.length || minVals.length != tailBins.length) {
            throw new IllegalArgumentException("multiDimMapper: differing input array sizes");
        }
        ArrayList binMappers = new ArrayList();
        for (int i = 0; i < minVals.length; ++i) {
            Integer1dBinMapper mapper = new Integer1dBinMapper(minVals[i], numBins[i], tailBins[i]);
            binMappers.add(mapper);
        }
        return new HistogramNd(binMappers);
    }
}

