/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kymographBuilder;

class Segment {
    public final int xStart;
    public final int yStart;
    public final int xEnd;
    public final int yEnd;
    private Double length;

    public Segment(int xStart, int yStart, int xEnd, int yEnd) {
        this.xStart = xStart;
        this.yStart = yStart;
        this.xEnd = xEnd;
        this.yEnd = yEnd;
    }

    public double getLength() {
        if (this.length == null) {
            this.length = Math.sqrt(Math.pow(this.xStart - this.xEnd, 2.0) + Math.pow(this.yStart - this.yEnd, 2.0));
        }
        return this.length;
    }

    public double[] getScaledVector() {
        double[] v = new double[2];
        double d = this.getLength();
        v[0] = (double)(this.xStart - this.xEnd) / d;
        v[1] = (double)(this.yStart - this.yEnd) / d;
        return v;
    }

    public String toString() {
        String s = new String();
        s = s + "xStart : " + this.xStart + " | ";
        s = s + "yStart : " + this.yStart + " | ";
        s = s + "xEnd : " + this.xEnd + " | ";
        s = s + "yEnd: " + this.yEnd;
        return s;
    }
}

