/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.gui.GuiUtils;
import ij.IJ;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.UIManager;

public abstract class Logger
extends PrintWriter {
    public static final Color NORMAL_COLOR = UIManager.getColor("TextField.foreground");
    public static final Color ERROR_COLOR;
    public static final Color GREEN_COLOR;
    public static final Color BLUE_COLOR;
    public static final Logger VOID_LOGGER;
    public static Logger DEFAULT_LOGGER;
    public static final Logger IJ_LOGGER;
    public static final Logger IJTOOLBAR_LOGGER;

    public Logger() {
        super(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        this.out = new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                Object str = "";
                for (int i = off; i < len; ++i) {
                    str = (String)str + cbuf[i];
                }
                Logger.this.log((String)str);
            }
        };
    }

    public abstract void log(String var1, Color var2);

    public abstract void error(String var1);

    public void log(String message) {
        this.log(message, NORMAL_COLOR);
    }

    public abstract void setProgress(double var1);

    public abstract void setStatus(String var1);

    static {
        Color bgColor = UIManager.getColor("Panel.background");
        boolean bgIsDark = GuiUtils.colorDistance(Color.WHITE, bgColor) > 0.5;
        BLUE_COLOR = bgIsDark ? new Color(0.4f, 0.4f, 0.9f) : new Color(0.0f, 0.0f, 0.7f);
        GREEN_COLOR = bgIsDark ? new Color(0.4f, 0.9f, 0.4f) : new Color(0.0f, 0.6f, 0.0f);
        ERROR_COLOR = bgIsDark ? new Color(0.8f, 0.0f, 0.0f).brighter() : new Color(0.8f, 0.0f, 0.0f);
        VOID_LOGGER = new VoidLogger();
        DEFAULT_LOGGER = new DefaultLogger();
        IJ_LOGGER = new ImageJLogger();
        IJTOOLBAR_LOGGER = new ImageJToolbarLogger();
    }

    private static class VoidLogger
    extends Logger {
        private VoidLogger() {
        }

        @Override
        public void setStatus(String status) {
        }

        @Override
        public void setProgress(double val) {
        }

        @Override
        public void log(String message, Color color) {
        }

        @Override
        public void error(String message) {
        }
    }

    private static class DefaultLogger
    extends Logger {
        private DefaultLogger() {
        }

        @Override
        public void log(String message, Color color) {
            System.out.print(message);
        }

        @Override
        public void error(String message) {
            System.err.print(message);
        }

        @Override
        public void setProgress(double val) {
        }

        @Override
        public void setStatus(String status) {
            System.out.println(status);
        }
    }

    private static class ImageJLogger
    extends Logger {
        private ImageJLogger() {
        }

        @Override
        public void log(String message, Color color) {
            IJ.log((String)message);
        }

        @Override
        public void error(String message) {
            IJ.log((String)message);
        }

        @Override
        public void setProgress(double val) {
            IJ.showProgress((double)val);
        }

        @Override
        public void setStatus(String status) {
            IJ.showStatus((String)status);
        }
    }

    private static class ImageJToolbarLogger
    extends Logger {
        private ImageJToolbarLogger() {
        }

        @Override
        public void log(String message, Color color) {
            IJ.showStatus((String)message);
        }

        @Override
        public void error(String message) {
            IJ.showStatus((String)message);
        }

        @Override
        public void setProgress(double val) {
            IJ.showProgress((double)val);
        }

        @Override
        public void setStatus(String status) {
            IJ.showStatus((String)status);
        }
    }

    public static class SlaveLogger
    extends Logger {
        private final Logger master;
        private final double progressStart;
        private final double progressRange;

        public SlaveLogger(Logger master, double progressStart, double progressRange) {
            this.master = master;
            this.progressStart = progressStart;
            this.progressRange = progressRange;
        }

        @Override
        public void log(String message, Color color) {
            this.master.log(message, color);
        }

        @Override
        public void error(String message) {
            this.master.error(message);
        }

        @Override
        public void setProgress(double val) {
            this.master.setProgress(this.progressStart + this.progressRange * val);
        }

        @Override
        public void setStatus(String status) {
            this.master.setStatus(status);
        }
    }

    public static class StringBuilderLogger
    extends Logger {
        private final StringBuilder sb;

        public StringBuilderLogger(StringBuilder sb) {
            this.sb = sb;
        }

        public StringBuilderLogger() {
            this(new StringBuilder());
        }

        @Override
        public void log(String message, Color color) {
            this.sb.append(message);
        }

        @Override
        public void error(String message) {
            this.sb.append(message);
        }

        @Override
        public void setProgress(double val) {
        }

        @Override
        public void setStatus(String status) {
            this.sb.append(status);
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

