/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.scijava.plugin.Plugin;

public class ExportTracksToXML
extends AbstractTMAction {
    public static final String NAME = "Export tracks to XML file";
    public static final String KEY = "EXPORT_TRACKS_TO_XML_SIMPLE";
    public static final String INFO_TEXT = "<html>Export the tracks in the current model content to a XML file in a simple format. <p> The file will have one element per track, and each track contains several spot elements. These spots are sorted by frame number, and have 4 numerical attributes: the frame number this spot is in, and its X, Y, Z position in physical units as specified in the image properties. <p>As such, this format <u>cannot</u> handle track merging and splitting properly, and is suited only for non-branching tracks.</html>";
    private static final String CONTENT_KEY = "Tracks";
    private static final String DATE_ATT = "generationDateTime";
    private static final String PHYSUNIT_ATT = "spaceUnits";
    private static final String FRAMEINTERVAL_ATT = "frameInterval";
    private static final String FRAMEINTERVALUNIT_ATT = "timeUnits";
    private static final String FROM_ATT = "from";
    private static final String NTRACKS_ATT = "nTracks";
    private static final String NSPOTS_ATT = "nSpots";
    private static final String TRACK_KEY = "particle";
    private static final String SPOT_KEY = "detection";
    private static final String X_ATT = "x";
    private static final String Y_ATT = "y";
    private static final String Z_ATT = "z";
    private static final String T_ATT = "t";

    public static void export(Model model, Settings settings, File file) throws FileNotFoundException, IOException {
        Element root = ExportTracksToXML.marshall(model, settings, Logger.VOID_LOGGER);
        Document document = new Document(root);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(document, (OutputStream)new FileOutputStream(file));
    }

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        File file;
        File folder;
        this.logger.log("Exporting tracks to simple XML format.\n");
        Model model = trackmate.getModel();
        int ntracks = model.getTrackModel().nTracks(true);
        if (ntracks == 0) {
            this.logger.log("No visible track found. Aborting.\n");
            return;
        }
        this.logger.log("  Preparing XML data.\n");
        Element root = ExportTracksToXML.marshall(model, trackmate.getSettings(), this.logger);
        try {
            folder = new File(trackmate.getSettings().imp.getOriginalFileInfo().directory);
        }
        catch (NullPointerException npe) {
            folder = new File(System.getProperty("user.dir")).getParentFile().getParentFile();
        }
        try {
            String filename = trackmate.getSettings().imageFileName;
            int dot = filename.indexOf(".");
            filename = dot < 0 ? filename : filename.substring(0, dot);
            file = new File(folder.getPath() + File.separator + filename + "_Tracks.xml");
        }
        catch (NullPointerException npe) {
            file = new File(folder.getPath() + File.separator + "Tracks.xml");
        }
        file = IOUtils.askForFileForSaving(file, parent);
        if (null == file) {
            this.logger.log("Exporting to simple XML aborted.\n");
            return;
        }
        this.logger.log("  Writing to file.\n");
        Document document = new Document(root);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(document, (OutputStream)new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            this.logger.error("Trouble writing to " + String.valueOf(file) + ":\n" + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("Trouble writing to " + String.valueOf(file) + ":\n" + e.getMessage());
        }
        this.logger.log("Done.\n");
    }

    private static Element marshall(Model model, Settings settings, Logger logger) {
        logger.setStatus("Marshalling...");
        Element content = new Element(CONTENT_KEY);
        content.setAttribute(NTRACKS_ATT, "" + model.getTrackModel().nTracks(true));
        content.setAttribute(PHYSUNIT_ATT, model.getSpaceUnits());
        content.setAttribute(FRAMEINTERVAL_ATT, "" + settings.dt);
        content.setAttribute(FRAMEINTERVALUNIT_ATT, model.getTimeUnits());
        content.setAttribute(DATE_ATT, TMUtils.getCurrentTimeString());
        content.setAttribute(FROM_ATT, "TrackMate v" + TrackMate.PLUGIN_NAME_VERSION);
        Set<Integer> trackIDs = model.getTrackModel().trackIDs(true);
        int i = 0;
        for (Integer trackID : trackIDs) {
            Set<Spot> track = model.getTrackModel().trackSpots(trackID);
            Element trackElement = new Element(TRACK_KEY);
            trackElement.setAttribute(NSPOTS_ATT, "" + track.size());
            TreeSet<Spot> sortedTrack = new TreeSet<Spot>(Spot.timeComparator);
            sortedTrack.addAll(track);
            for (Spot spot : sortedTrack) {
                int frame = spot.getFeature("FRAME").intValue();
                double x = spot.getFeature("POSITION_X");
                double y = spot.getFeature("POSITION_Y");
                double z = spot.getFeature("POSITION_Z");
                Element spotElement = new Element(SPOT_KEY);
                spotElement.setAttribute(T_ATT, "" + frame);
                spotElement.setAttribute(X_ATT, "" + x);
                spotElement.setAttribute(Y_ATT, "" + y);
                spotElement.setAttribute(Z_ATT, "" + z);
                trackElement.addContent((Content)spotElement);
            }
            content.addContent((Content)trackElement);
            logger.setProgress((double)i++ / (0.0 + (double)model.getTrackModel().nTracks(true)));
        }
        logger.setStatus("");
        logger.setProgress(1.0);
        return content;
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return ExportTracksToXML.INFO_TEXT;
        }

        @Override
        public String getName() {
            return ExportTracksToXML.NAME;
        }

        @Override
        public String getKey() {
            return ExportTracksToXML.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new ExportTracksToXML();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.SAVE_ICON;
        }
    }
}

