/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import fiji.plugin.trackmate.util.cli.Configurator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TrackMateSettingsBuilder {
    private TrackMateSettingsBuilder() {
    }

    private static void toMap(Configurator.Argument<?, ?> arg, Map<String, Object> settings) {
        if (arg.getKey() != null) {
            settings.put(arg.getKey(), arg.getValueObject());
        }
    }

    private static void toMap(Configurator.SelectableArguments selectable, Map<String, Object> settings) {
        if (selectable.getKey() != null) {
            settings.put(selectable.getKey(), selectable.getSelection().getKey());
        }
    }

    private static void fromMap(Map<String, Object> settings, Configurator.Argument<?, ?> arg) {
        Object val = settings.get(arg.getKey());
        if (val != null) {
            arg.setValueObject(val);
        }
    }

    private static void fromMap(Map<String, Object> settings, Configurator.SelectableArguments selectable) {
        Object val = settings.get(selectable.getKey());
        if (val != null) {
            selectable.select((String)val);
        }
    }

    public static void toTrackMateSettings(Map<String, Object> settings, Configurator config) {
        if (config instanceof CLIConfigurator) {
            TrackMateSettingsBuilder.toMap(((CLIConfigurator)config).getCommandArg(), settings);
        }
        config.getArguments().forEach(arg -> TrackMateSettingsBuilder.toMap(arg, settings));
        config.getSelectables().forEach(selectable -> TrackMateSettingsBuilder.toMap(selectable, settings));
    }

    public static final void fromTrackMateSettings(Map<String, Object> settings, Configurator config) {
        if (config instanceof CLIConfigurator) {
            TrackMateSettingsBuilder.fromMap(settings, ((CLIConfigurator)config).getCommandArg());
        }
        config.getArguments().forEach(arg -> TrackMateSettingsBuilder.fromMap(settings, arg));
        config.getSelectables().forEach(selectable -> TrackMateSettingsBuilder.fromMap(settings, selectable));
    }

    public static final Map<String, Object> getDefaultSettings(Configurator config) {
        Configurator.Argument<?, ?> commandArg;
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        if (config instanceof CLIConfigurator && (commandArg = ((CLIConfigurator)config).getCommandArg()).getKey() != null && commandArg.hasDefaultValue()) {
            settings.put(commandArg.getKey(), commandArg.getDefaultValue());
        }
        config.arguments.forEach(arg -> {
            String key = arg.getKey();
            if (key == null) {
                return;
            }
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The argument '" + key + "' in the configurator " + config.getClass().getSimpleName() + " has no default value, which is required.");
            }
            settings.put(key, arg.getDefaultValue());
        });
        config.selectables.forEach(sel -> {
            String selKey = sel.getKey();
            if (selKey == null) {
                return;
            }
            String argKey = sel.getSelection().getKey();
            if (argKey == null) {
                throw new IllegalArgumentException("The selectable argument '" + selKey + "' in the configurator " + String.valueOf(config) + " has no key, which is required.");
            }
            settings.put(selKey, argKey);
        });
        return settings;
    }
}

