/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.ModelChangeListener;
import fiji.plugin.trackmate.SelectionChangeEvent;
import fiji.plugin.trackmate.SelectionChangeListener;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.TrackMateModelView;
import java.util.Map;

public abstract class AbstractTrackMateModelView
implements SelectionChangeListener,
TrackMateModelView,
ModelChangeListener {
    protected final Model model;
    protected final SelectionModel selectionModel;
    protected final DisplaySettings displaySettings;

    protected AbstractTrackMateModelView(Model model, SelectionModel selectionModel, DisplaySettings displaySettings) {
        this.selectionModel = selectionModel;
        this.model = model;
        this.displaySettings = displaySettings;
        model.addModelChangeListener(this);
        selectionModel.addSelectionChangeListener(this);
    }

    @Override
    public void selectionChanged(SelectionChangeEvent event) {
        boolean added;
        Map<Spot, Boolean> spotsAdded = event.getSpots();
        if (spotsAdded != null && spotsAdded.size() == 1 && (added = spotsAdded.values().iterator().next().booleanValue())) {
            Spot spot = spotsAdded.keySet().iterator().next();
            this.centerViewOn(spot);
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }
}

