/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.SaveChangesDialog;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class Sync_Measure_3D
extends Sync_Windows {
    protected int DEFAULT_FIRST_SLICE = 1;
    protected int DEFAULT_LAST_SLICE = 999;
    protected boolean measuring = false;
    protected Button bMeasure;
    protected Panel measurePanel;
    private int mainPanelSize = 0;
    protected Vector vScrollThresh = null;
    protected final String I_THRESH_SLIDER = "iThresholdSlider";
    protected Vector vFirstButton = null;
    protected final String I_FIRST_SLICE_BUTTON = "iFirstSliceButton";
    protected Vector vFirstInt = null;
    protected int[] iFirstSlice = null;
    protected final String I_FIRST_SLICE_BOX = "iFirstSliceBox";
    protected Vector vLastButton = null;
    protected final String I_LAST_SLICE_BUTTON = "iLastSliceButton";
    protected Vector vLastInt = null;
    protected int[] iLastSlice = null;
    protected final String I_LAST_SLICE_BOX = "iLastSliceBox";
    protected Button bFirstSlice = null;
    protected IntField intFirstSlice = null;
    protected final String COMMON_FIRST_SLICE_BOX = "CommonFirstSliceBox";
    protected Button bLastSlice = null;
    protected IntField intLastSlice = null;
    protected final String COMMON_LAST_SLICE_BOX = "LastSliceBox";
    protected Button bProjection = null;
    protected boolean hasProjection = false;
    protected ImagePlus projection = null;
    protected M3DRTab resultsTable = null;
    protected M3DRWin resultsWindow = null;
    protected int nWindows = 0;
    protected int mOptions = 323;
    protected int nQuantities = 6;
    protected int nRelQuantities = 1;

    public Sync_Measure_3D() {
        this("Sync Measure 3D 1.7-fiji1");
    }

    public Sync_Measure_3D(String s) {
        super(s);
    }

    @Override
    public void run(String args) {
        super.run(args);
    }

    @Override
    protected Panel controlPanel() {
        Panel p = super.controlPanel();
        this.measurePanel = new Panel(new BorderLayout(0, 5));
        this.bMeasure = new Button("Start Measurements");
        this.bMeasure.addActionListener(this);
        this.measurePanel.add(this.bMeasure, "North", 0);
        p.add(this.measurePanel, "South", 2);
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String command = e.getActionCommand();
        Object source = e.getSource();
        if (source instanceof Button) {
            int windowNumber;
            ImagePlus image;
            Button bPressed = (Button)source;
            if (bPressed == this.bMeasure) {
                if (!this.measuring && this.vwins != null && this.vwins.size() > 0) {
                    this.startMeasurements();
                } else if (this.measuring) {
                    this.calcFinal();
                    this.stopMeasurements();
                }
            } else if (this.bFirstSlice != null && bPressed == this.bFirstSlice) {
                int slice = WindowManager.getCurrentImage().getCurrentSlice();
                this.setCommonFirstSlice(slice);
            } else if (this.bLastSlice != null && bPressed == this.bLastSlice) {
                int slice = WindowManager.getCurrentImage().getCurrentSlice();
                this.setCommonLastSlice(slice);
            } else if (this.bProjection != null && bPressed == this.bProjection) {
                if (this.hasProjection) {
                    return;
                }
                this.projection = this.computeProjection();
                this.projection.show();
                ImageCanvas projCanvas = this.projection.getWindow().getCanvas();
                this.vwins.addElement(new Integer(this.projection.getID()));
                projCanvas.addMouseListener((MouseListener)this);
                projCanvas.addMouseMotionListener((MouseMotionListener)this);
                this.projection.getWindow().addWindowListener((WindowListener)((Object)this));
                this.hasProjection = true;
            } else if (command.startsWith("iFirstSliceButton")) {
                int windowNumber2 = Integer.parseInt(command.substring("iFirstSliceButton".length()));
                ImagePlus image2 = this.getImageFromVector(windowNumber2);
                if (image2 != null) {
                    this.setFirstSlice(windowNumber2, image2.getCurrentSlice());
                }
            } else if (command.startsWith("iLastSliceButton") && (image = this.getImageFromVector(windowNumber = Integer.parseInt(command.substring("iLastSliceButton".length())))) != null) {
                this.setLastSlice(windowNumber, image.getCurrentSlice());
            }
        } else if (source instanceof IntField) {
            IntField field = (IntField)source;
            if (command.equals("CommonFirstSliceBox")) {
                this.setCommonFirstSlice(field.getValue());
            } else if (command.equals("LastSliceBox")) {
                this.setCommonLastSlice(field.getValue());
            } else if (command.startsWith("iFirstSliceBox")) {
                int windowNumber = Integer.parseInt(command.substring("iFirstSliceBox".length()));
                this.setFirstSlice(windowNumber, field.getValue());
            } else if (command.startsWith("iLastSliceBox")) {
                int windowNumber = Integer.parseInt(command.substring("iLastSliceBox".length()));
                this.setLastSlice(windowNumber, field.getValue());
            }
        } else if (source instanceof IntSlider && command.startsWith("iThresholdSlider")) {
            int windowNumber = Integer.parseInt(command.substring("iThresholdSlider".length()));
            this.updateThreshold(windowNumber);
        }
    }

    public void startMeasurements() {
        this.updateWindowList();
        if (this.vwins == null) {
            return;
        }
        this.nWindows = this.vwins.size();
        if (this.nWindows == 0) {
            return;
        }
        this.mainPanelSize = this.panel.getBounds().height;
        ScrollPane measureControl = this.buildMeasureControl();
        if (measureControl == null) {
            return;
        }
        this.bMeasure.setLabel("Stop Measurements");
        this.setControlsEnabled(false);
        this.measurePanel.add(measureControl, "Center", 1);
        this.measurePanel.add(this.buildCommonControls(), "South", 2);
        this.pack();
        this.resultsTable = new M3DRTab(this.nQuantities * this.nWindows + this.nRelQuantities * (this.nWindows - 1) * this.nWindows / 2);
        this.measuring = true;
        this.updateScrollbars();
    }

    public void stopMeasurements() {
        this.bMeasure.setLabel("Start Measurements");
        this.setControlsEnabled(true);
        for (int n = 0; n < this.nWindows; ++n) {
            ((IntSlider)this.vScrollThresh.elementAt(n)).removeActionListener(this);
            ((Button)this.vFirstButton.elementAt(n)).removeActionListener(this);
            ((IntField)this.vFirstInt.elementAt(n)).removeActionListener(this);
            ((Button)this.vLastButton.elementAt(n)).removeActionListener(this);
            ((IntField)this.vLastInt.elementAt(n)).removeActionListener(this);
            ImagePlus image = this.getImageFromVector(n);
            if (image == null) continue;
            image.getProcessor().resetThreshold();
            image.updateAndDraw();
        }
        this.vScrollThresh = null;
        this.vFirstButton = null;
        this.vFirstInt = null;
        this.vLastButton = null;
        this.vLastInt = null;
        this.bFirstSlice.removeActionListener(this);
        this.bFirstSlice = null;
        this.intFirstSlice.removeActionListener(this);
        this.intFirstSlice = null;
        this.bLastSlice.removeActionListener(this);
        this.bLastSlice = null;
        this.intLastSlice.removeActionListener(this);
        this.intLastSlice = null;
        this.bProjection.removeActionListener(this);
        this.bProjection = null;
        this.nWindows = 0;
        this.measurePanel.remove(1);
        this.measurePanel.remove(1);
        this.pack();
        if (this.resultsWindow != null) {
            this.resultsWindow.nullParent();
            this.resultsWindow = null;
        }
        if (this.hasProjection && this.projection != null) {
            this.projection.getWindow().setVisible(false);
            this.projection.getWindow().close();
            WindowManager.removeWindow((Frame)this.projection.getWindow());
            this.disconnectProjection();
            this.projection = null;
            this.hasProjection = false;
        }
        this.measuring = false;
        this.updateWindowList();
    }

    void setFirstSlice(int iWin, int slice) {
        int lastSlice = this.iLastSlice[iWin];
        int firstSlice = slice >= 1 && slice <= lastSlice ? slice : (slice > lastSlice ? lastSlice : 1);
        this.iFirstSlice[iWin] = firstSlice;
        ((IntField)this.vFirstInt.elementAt(iWin)).setValue(firstSlice);
    }

    void setLastSlice(int iWin, int slice) {
        ImagePlus image = this.getImageFromVector(iWin);
        if (image == null) {
            return;
        }
        int stackSize = image.getStackSize();
        int firstSlice = this.iFirstSlice[iWin];
        int lastSlice = slice >= firstSlice && slice <= stackSize ? slice : (slice > stackSize ? stackSize : firstSlice);
        this.iLastSlice[iWin] = lastSlice;
        ((IntField)this.vLastInt.elementAt(iWin)).setValue(lastSlice);
    }

    void setCommonFirstSlice(int slice) {
        int lastSlice = this.intLastSlice.getValue();
        int firstSlice = slice >= 1 && slice <= lastSlice ? slice : (slice > lastSlice ? lastSlice : 1);
        this.intFirstSlice.setValue(firstSlice);
        for (int n = 0; n < this.nWindows; ++n) {
            this.setLastSlice(n, lastSlice);
            this.setFirstSlice(n, firstSlice);
        }
    }

    void setCommonLastSlice(int slice) {
        int firstSlice = this.intFirstSlice.getValue();
        int lastSlice = slice >= firstSlice ? slice : firstSlice;
        this.intLastSlice.setValue(lastSlice);
        for (int n = 0; n < this.nWindows; ++n) {
            this.setFirstSlice(n, firstSlice);
            this.setLastSlice(n, lastSlice);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            if (!this.measuring) {
                super.windowClosing(e);
            }
        } else if (this.projection != null && e.getSource() == this.projection.getWindow()) {
            this.disconnectProjection();
        }
    }

    public void windowActivated(WindowEvent e) {
        if (e.getSource() == this) {
            super.windowActivated(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean button1 = (e.getModifiers() & 0x10) != 0;
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        ImagePlus image = iwc.getImagePlus();
        int x = icc.offScreenX(e.getX());
        int y = icc.offScreenY(e.getY());
        if (this.measuring && button1 && e.getClickCount() == 2 && image.getRoi() != null && image.getRoi().contains(x, y)) {
            this.measure(image, x, y);
            return;
        }
        super.mousePressed(e);
    }

    @Override
    public void imageOpened(ImagePlus imp) {
        if (!this.measuring) {
            this.updateWindowList();
        }
    }

    @Override
    public void imageClosed(ImagePlus imp) {
        if (!this.measuring) {
            this.updateWindowList();
        }
    }

    protected ScrollPane buildMeasureControl() {
        int screenHeight;
        int restHeight;
        this.vScrollThresh = new Vector(this.nWindows);
        this.vFirstButton = new Vector(this.nWindows);
        this.vFirstInt = new Vector(this.nWindows);
        this.iFirstSlice = new int[this.nWindows];
        this.vLastButton = new Vector(this.nWindows);
        this.vLastInt = new Vector(this.nWindows);
        this.iLastSlice = new int[this.nWindows];
        int minThresh = 0;
        int maxThresh = 255;
        Panel p = new Panel(new GridLayout(this.nWindows, 1, 0, 4));
        Font font = new Font("SansSerif", 0, 10);
        for (int n = 0; n < this.nWindows; ++n) {
            ImagePlus image = this.getImageFromVector(n);
            if (image == null) continue;
            ImageStack imageS = image.getStack();
            int type = image.getType();
            switch (type) {
                case 2: 
                case 3: 
                case 4: {
                    this.vScrollThresh = null;
                    this.vFirstButton = null;
                    this.vFirstInt = null;
                    this.iFirstSlice = null;
                    this.vLastButton = null;
                    this.vLastInt = null;
                    this.iLastSlice = null;
                    IJ.error((String)"This plugin only works with 8-bit and 16-bit images.");
                    return null;
                }
                case 1: {
                    minThresh = 65535;
                    maxThresh = 0;
                    for (int i = 1; i <= image.getStackSize(); ++i) {
                        short[] pix = (short[])imageS.getPixels(i);
                        for (int j = 0; j < pix.length; ++j) {
                            int pixel = 0xFFFF & pix[j];
                            if (pixel < minThresh) {
                                minThresh = pixel;
                            }
                            if (pixel <= maxThresh) continue;
                            maxThresh = pixel;
                        }
                    }
                    break;
                }
                case 0: {
                    minThresh = 0;
                    maxThresh = 255;
                    break;
                }
                default: {
                    IJ.error((String)"Unknown image type.");
                    return null;
                }
            }
            Panel windowPanel = new Panel(new BorderLayout(4, 0));
            windowPanel.setFont(font);
            windowPanel.add(new Label(image.getTitle()), "North", 0);
            IntSlider tScroll = new IntSlider(minThresh, minThresh, maxThresh + 1, 0, 1, 3, "iThresholdSlider" + Integer.toString(n));
            windowPanel.add(tScroll, "Center", 1);
            tScroll.addActionListener(this);
            this.vScrollThresh.addElement(tScroll);
            Panel zPanel = new Panel(new FlowLayout(0, 2, 2));
            Button bFirst = new Button("First  Z");
            bFirst.setActionCommand("iFirstSliceButton" + Integer.toString(n));
            bFirst.addActionListener(this);
            zPanel.add(bFirst);
            this.vFirstButton.addElement(bFirst);
            IntField iFirst = new IntField(1, 1, Integer.MAX_VALUE, 4, "iFirstSliceBox" + Integer.toString(n));
            this.iFirstSlice[n] = 1;
            iFirst.addActionListener(this);
            zPanel.add(iFirst);
            this.vFirstInt.addElement(iFirst);
            Button bLast = new Button("Last  Z");
            bLast.addActionListener(this);
            bLast.setActionCommand("iLastSliceButton" + Integer.toString(n));
            zPanel.add(bLast);
            this.vLastButton.addElement(bLast);
            IntField iLast = new IntField(image.getStackSize(), 1, Integer.MAX_VALUE, 4, "iLastSliceBox" + Integer.toString(n));
            this.iLastSlice[n] = image.getStackSize();
            iLast.addActionListener(this);
            zPanel.add(iLast);
            this.vLastInt.addElement(iLast);
            windowPanel.add(zPanel, "South", 2);
            p.add((Component)windowPanel, n);
        }
        Frame win = new Frame();
        win.add(p);
        win.pack();
        Rectangle bounds = p.getBounds();
        win.dispose();
        if (bounds.height > 380) {
            bounds.height = 380;
        }
        if ((restHeight = (screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height) - this.mainPanelSize - 44 - 55) < 1) {
            restHeight = 1;
        }
        if (bounds.height > restHeight) {
            bounds.height = restHeight;
        }
        ScrollPane pane = new ScrollPane(0);
        pane.add(p);
        pane.setSize(100, bounds.height + 4);
        pane.getVAdjustable().setUnitIncrement(20);
        return pane;
    }

    protected Panel buildCommonControls() {
        Panel p1 = new Panel(new BorderLayout(6, 0));
        Panel upDownSlicePanel = new Panel(new GridLayout(0, 4, 2, 0));
        this.bFirstSlice = new Button("First  Z");
        upDownSlicePanel.add(this.bFirstSlice);
        this.bFirstSlice.addActionListener(this);
        this.intFirstSlice = new IntField(this.DEFAULT_FIRST_SLICE, 1, Integer.MAX_VALUE, 4, "CommonFirstSliceBox");
        upDownSlicePanel.add(this.intFirstSlice);
        this.intFirstSlice.addActionListener(this);
        this.bLastSlice = new Button("Last  Z");
        upDownSlicePanel.add(this.bLastSlice);
        this.bLastSlice.addActionListener(this);
        this.intLastSlice = new IntField(this.DEFAULT_LAST_SLICE, 1, Integer.MAX_VALUE, 4, "LastSliceBox");
        upDownSlicePanel.add(this.intLastSlice);
        this.intLastSlice.addActionListener(this);
        this.bProjection = new Button("Projection");
        this.bProjection.addActionListener(this);
        p1.add((Component)upDownSlicePanel, "Center");
        p1.add((Component)this.bProjection, "East");
        Label infoLabel = new Label("Double-click into ROI to measure!");
        infoLabel.setFont(new Font("SansSerif", 0, 10));
        p1.add((Component)infoLabel, "South");
        return p1;
    }

    protected void setControlsEnabled(boolean enable) {
        if (this.wList != null) {
            this.wList.setEnabled(enable);
        }
        this.bSyncAll.setEnabled(enable);
        this.bUnsyncAll.setEnabled(enable);
    }

    protected void updateScrollbars() {
        if (!this.measuring) {
            return;
        }
        for (int n = 0; n < this.nWindows; ++n) {
            this.updateThreshold(n);
        }
    }

    protected void updateThreshold(int iWin) {
        if (!this.measuring) {
            return;
        }
        if (iWin < 0 || iWin >= this.nWindows) {
            return;
        }
        double threshold = 0.0;
        threshold = ((IntSlider)this.vScrollThresh.elementAt(iWin)).getValue();
        ImagePlus image = this.getImageFromVector(iWin);
        if (image == null) {
            return;
        }
        ImageProcessor imageP = image.getProcessor();
        int type = image.getType();
        switch (type) {
            case 0: {
                imageP.setThreshold(threshold, 255.0, 3);
                break;
            }
            case 1: {
                imageP.setThreshold(threshold, 65535.0, 3);
            }
        }
        image.updateAndDraw();
    }

    protected void measure(ImagePlus image, int x, int y) {
        boolean nullWindows = false;
        this.resultsTable.incrementCounter();
        for (int n = 0; n < this.nWindows; ++n) {
            int lastSlice;
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null) {
                for (int i = 0; i < this.nQuantities + n * this.nRelQuantities; ++i) {
                    this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + i, Double.NaN);
                }
                nullWindows = true;
                continue;
            }
            double Volume = 0.0;
            double Intensity = 0.0;
            double X = 0.0;
            double Y = 0.0;
            double Z = 0.0;
            Calibration cal = imp.getCalibration();
            double dZ = cal.pixelDepth;
            int currentSlice = imp.getCurrentSlice();
            int firstSlice = this.iFirstSlice[n];
            if (firstSlice > imp.getStackSize()) {
                firstSlice = imp.getStackSize();
            }
            if ((lastSlice = this.iLastSlice[n]) > imp.getStackSize()) {
                lastSlice = imp.getStackSize();
            }
            for (int slice = firstSlice; slice <= lastSlice; ++slice) {
                double yCenterOfMass;
                double xCenterOfMass;
                double pixelCount;
                double area;
                imp.setSlice(slice);
                ImageStatistics stats = imp.getStatistics(this.mOptions);
                if (stats == null) {
                    IJ.error((String)"Measurement Error");
                    return;
                }
                double mean = stats.mean;
                if (Double.isInfinite(mean) || Double.isNaN(mean)) {
                    mean = 0.0;
                }
                if (Double.isInfinite(area = stats.area) || Double.isNaN(area)) {
                    area = 0.0;
                }
                if (Double.isInfinite(pixelCount = (double)stats.pixelCount) || Double.isNaN(pixelCount)) {
                    pixelCount = 0.0;
                }
                if (Double.isInfinite(xCenterOfMass = stats.xCenterOfMass) || Double.isNaN(xCenterOfMass)) {
                    xCenterOfMass = 0.0;
                }
                if (Double.isInfinite(yCenterOfMass = stats.yCenterOfMass) || Double.isNaN(yCenterOfMass)) {
                    yCenterOfMass = 0.0;
                }
                Volume += area;
                Intensity += mean * pixelCount;
                X += xCenterOfMass * mean * pixelCount;
                Y += yCenterOfMass * mean * pixelCount;
                if (cal.scaled()) {
                    Z += cal.getZ((double)(slice - 1)) * mean * pixelCount;
                    continue;
                }
                Z += (double)(slice - 1) * mean * pixelCount;
            }
            imp.setSlice(currentSlice);
            this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2, X /= Intensity);
            this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + 1, Y /= Intensity);
            this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + 2, Z /= Intensity);
            this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + 3, Volume *= dZ);
            this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + 4, Intensity);
            this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + 5, imp.getProcessor().getMinThreshold());
            for (int i = 0; i < this.nRelQuantities * n; ++i) {
                int counter = this.resultsTable.getCounter() - 1;
                double Xi = this.resultsTable.getValue(this.nQuantities * i + this.nRelQuantities * (i - 1) * i / 2, counter);
                double Yi = this.resultsTable.getValue(this.nQuantities * i + this.nRelQuantities * (i - 1) * i / 2 + 1, counter);
                double Zi = this.resultsTable.getValue(this.nQuantities * i + this.nRelQuantities * (i - 1) * i / 2 + 2, counter);
                double D = Math.sqrt((X - Xi) * (X - Xi) + (Y - Yi) * (Y - Yi) + (Z - Zi) * (Z - Zi));
                this.resultsTable.addValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + 6 + i, D);
            }
        }
        this.displayResults();
        if (nullWindows) {
            IJ.error((String)"Some Images in the list do not exist. Added \"zero\" results.");
        }
    }

    private void displayResults() {
        int n;
        if (this.resultsTable == null || this.resultsTable.getCounter() < 1) {
            return;
        }
        int counter = this.resultsTable.getCounter();
        if (counter == 1) {
            String heading = " ";
            for (n = 0; n < this.nWindows; ++n) {
                String valueUnit;
                String unit;
                String title;
                ImagePlus imp = this.getImageFromVector(n);
                if (imp != null) {
                    title = this.getImageTitleFromVector(n);
                    unit = imp.getCalibration().getUnits();
                    valueUnit = imp.getCalibration().getValueUnit();
                    if (unit != "") {
                        unit = " / " + unit;
                    }
                    valueUnit = valueUnit != "" && valueUnit != "Gray Value" ? " / " + valueUnit : "";
                } else {
                    title = "null";
                    unit = "";
                    valueUnit = "";
                }
                heading = heading + "\t" + title;
                heading = heading + "\tX" + unit;
                heading = heading + "\tY" + unit;
                heading = heading + "\tZ" + unit;
                heading = heading + "\tVolume";
                heading = heading + "\tIntensity" + valueUnit;
                heading = heading + "\tThreshold";
                for (int i = 0; i < n; ++i) {
                    heading = heading + "\tDist " + (i + 1) + unit;
                }
            }
            this.resultsWindow = new M3DRWin("Sync Measurements", heading, heading, 500, 200, this);
        }
        String dataRow = "" + this.resultsTable.getCounter();
        for (n = 0; n < this.nWindows; ++n) {
            dataRow = dataRow + "\t ";
            for (int i = 0; i < this.nQuantities + this.nRelQuantities * n; ++i) {
                dataRow = dataRow + "\t" + IJ.d2s((double)this.resultsTable.getValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + i, this.resultsTable.getCounter() - 1), (int)3);
            }
        }
        this.resultsWindow.append(dataRow);
    }

    public void calcFinal() {
        int n;
        if (this.resultsTable == null || this.resultsTable.getCounter() < 1 || this.nWindows <= 1) {
            return;
        }
        this.resultsWindow.append("===");
        String rowShift = "Shift";
        String rowStddev = "Stddev";
        int nResults = this.resultsTable.getCounter();
        double[][] shifts = new double[3][this.nWindows];
        for (n = 0; n < this.nWindows; ++n) {
            double tmpShift;
            int i;
            double shiftSq;
            double shift;
            int xyz;
            rowShift = rowShift + "\t ";
            rowStddev = rowStddev + "\t ";
            for (xyz = 0; xyz < 3; ++xyz) {
                shift = 0.0;
                shiftSq = 0.0;
                for (i = 0; i < nResults; ++i) {
                    tmpShift = this.resultsTable.getValue(this.nQuantities * n + this.nRelQuantities * (n - 1) * n / 2 + xyz, i) - this.resultsTable.getValue(xyz, i);
                    shift += tmpShift;
                    shiftSq += tmpShift * tmpShift;
                }
                shifts[xyz][n] = shift /= (double)nResults;
                rowShift = rowShift + "\t" + IJ.d2s((double)shift, (int)3);
                if (nResults > 1) {
                    shiftSq = Math.sqrt((shiftSq - (double)nResults * shift * shift) / (double)(nResults - 1));
                    rowStddev = rowStddev + "\t" + IJ.d2s((double)shiftSq, (int)3);
                    continue;
                }
                rowStddev = rowStddev + "\t -";
            }
            for (xyz = 0; xyz < this.nQuantities - 3; ++xyz) {
                rowShift = rowShift + "\t ";
                rowStddev = rowStddev + "\t ";
            }
            for (int nDist = 0; nDist < n; ++nDist) {
                shift = 0.0;
                shiftSq = 0.0;
                for (i = 0; i < nResults; ++i) {
                    tmpShift = this.resultsTable.getValue(this.nQuantities * (n + 1) + this.nRelQuantities * (n - 1) * n / 2 + nDist, i);
                    shift += tmpShift;
                    shiftSq += tmpShift * tmpShift;
                }
                rowShift = rowShift + "\t" + IJ.d2s((double)(shift /= (double)nResults), (int)3);
                if (nResults > 1) {
                    shiftSq = Math.sqrt((shiftSq - (double)nResults * shift * shift) / (double)(nResults - 1));
                    rowStddev = rowStddev + "\t" + IJ.d2s((double)shiftSq, (int)3);
                    continue;
                }
                rowStddev = rowStddev + "\t -";
            }
        }
        this.resultsWindow.append(rowShift);
        this.resultsWindow.append(rowStddev);
        this.resultsWindow.append("");
        this.resultsWindow.append("Channel\tTitle\tShift x\tShift y\tShift z");
        for (n = 0; n < this.nWindows; ++n) {
            String tempShiftRow = "Ch " + Integer.toString(n + 1) + "\t";
            tempShiftRow = tempShiftRow + this.getImageTitleFromVector(n) + "\t";
            tempShiftRow = tempShiftRow + IJ.d2s((double)shifts[0][n], (int)3) + "\t";
            tempShiftRow = tempShiftRow + IJ.d2s((double)shifts[1][n], (int)3) + "\t";
            tempShiftRow = tempShiftRow + IJ.d2s((double)shifts[2][n], (int)3);
            this.resultsWindow.append(tempShiftRow);
        }
    }

    protected int stringToInt(String s) {
        int i;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            i = 0;
        }
        return i;
    }

    ImagePlus computeProjection() {
        int xSize = this.getImageFromVector(0).getWidth();
        int ySize = this.getImageFromVector(0).getHeight();
        FloatProcessor fp = new FloatProcessor(xSize, ySize);
        float[] fpixels = (float[])fp.getPixels();
        for (int i = 0; i < xSize * ySize; ++i) {
            fpixels[i] = -3.4028235E38f;
        }
        for (int n = 0; n < this.nWindows; ++n) {
            ImagePlus imp = this.getImageFromVector(n);
            int type = imp.getType();
            int size = imp.getStackSize();
            int xSizeN = imp.getWidth();
            int ySizeN = imp.getHeight();
            int minxSize = xSize < xSizeN ? xSize : xSizeN;
            int minySize = ySize < ySizeN ? ySize : ySizeN;
            ImageStack stk = imp.getStack();
            for (int slice = 1; slice <= size; ++slice) {
                int x;
                int y;
                Object[] pixels;
                if (type == 0) {
                    pixels = (byte[])stk.getPixels(slice);
                    for (y = 0; y < minySize; ++y) {
                        for (x = 0; x < minxSize; ++x) {
                            if (!((float)(pixels[y * xSizeN + x] & 0xFF) > fpixels[y * xSize + x])) continue;
                            fpixels[y * xSize + x] = pixels[y * xSizeN + x] & 0xFF;
                        }
                    }
                }
                if (type == 1) {
                    pixels = (short[])stk.getPixels(slice);
                    for (y = 0; y < minySize; ++y) {
                        for (x = 0; x < minxSize; ++x) {
                            if (!((float)(pixels[y * xSizeN + x] & 0xFFFF) > fpixels[y * xSize + x])) continue;
                            fpixels[y * xSize + x] = pixels[y * xSizeN + x] & 0xFFFF;
                        }
                    }
                }
                if (type != 2) continue;
                pixels = (float[])stk.getPixels(slice);
                for (y = 0; y < minySize; ++y) {
                    for (x = 0; x < minxSize; ++x) {
                        if (!(pixels[y * xSizeN + x] > fpixels[y * xSize + x])) continue;
                        fpixels[y * xSize + x] = pixels[y * xSizeN + x];
                    }
                }
            }
        }
        return new ImagePlus("Projection", fp.convertToShort(false));
    }

    void disconnectProjection() {
        if (!this.hasProjection) {
            return;
        }
        this.vwins.removeElementAt(this.vwins.size() - 1);
        this.projection.getWindow().getCanvas().removeMouseListener((MouseListener)this);
        this.projection.getWindow().getCanvas().removeMouseMotionListener((MouseMotionListener)this);
        this.projection.getWindow().removeWindowListener((WindowListener)((Object)this));
        this.hasProjection = false;
        this.projection = null;
    }

    @Override
    protected void showAbout() {
        Dialog dialog = new Dialog((Frame)this.ijInstance);
        dialog.setSize(550, 350);
        dialog.setTitle("Sync Measure 3D 1.7-fiji1");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Dialog src = (Dialog)e.getSource();
                src.setVisible(false);
                src.dispose();
            }
        });
        TextArea tArea = new TextArea();
        tArea.setEditable(false);
        tArea.setBackground(Color.white);
        tArea.append("Sync Measure 3D\n \nSynchronizes the cursor and z-slice in all selected windows, \nand performs measurements on 3D ROIs in all selected windows.\n \nAuthor: Joachim Walter\n \nUsage:\n- Load the data, each color channel as a separate 8- or 16-bit grayscale stack.\n \n- Run Sync_Measure_3D. (Analyze&gt;Tools&gt;Sync Measure 3D)\n \n- Synchronize the windows, in which you want to measure by selecting them in the\n    window list.\n \n- Click \"Start Measurements\".\n \n- Click on \"Projection\" to obtain a combined maximum intensity projection of all\n  selected images (stacks). This projection is not used for measurements, but is\n  synchronized with the other images and might be a convenient reference.\n \n- Choose a threshold for each image.\n \n- Measure gravity center, Volume, Intensity and distance to preceding stacks:\n    o Draw a ROI around the particle you want to measure. If the particles in different\n        channels are at different positions, turn \"Synchronize Cursor\" off for that.\n    o If necessary (when other particles are inside the ROI in different z-slices),\n        Select first and last slice to include this particle and exclude the other ones.\n    o Double-click with the left mousebutton into the ROI to perform a measurement.\n        + The X, Y and Z values are the coordinates of the intensity gravity centers\n            of the measured objects.\n        + The Volume and Intensity values are the volumes and the total intensities\n            of the measured objects.\n        + The Dist 1, Dist 2, ... values (for 2 or more image stacks) are the 3D distances\n            of the intensity gravity center of the object in the current stack to the intensity\n            gravity center of the object in the first, second, ... stack in the list.\n        + If the scale of the image is not set, the results are displayed in \"pixels\".\n            3D-distances are meaningless in this case, if the distance between slices\n            differs from the pixelsize. If the image scale is set, the results are displayed\n            in the selected unit.\n        + Intensity values are given in gray values or the selected units in case that the\n            image has been density calibrated. If the image is density calibrated, the centers\n            of mass are calculated with the calibrated values, but the threshold is still a raw\n            value (0-255 for 8-bit images).\n    o To calculate mean values and standard deviations, click on \"Stop Measurements\".\n        + For the x- y- and z- coordinates the differences to the coordinates of image stack #1\n             are calculated ( (value for this stack) minus (value for stack #1) ) and their mean\n             and standard deviation values are displayed. This helps in calculating the chromatic\n             shift to stack #1.\n        + For the Dist 1, Dist 2, ... values, simply the mean and the standard deviation are\n             calculated.");
        dialog.add(tArea);
        dialog.setVisible(true);
    }

    private class M3DRTab {
        private int counter;
        private float[][] columns;
        private int maxRows = 100;
        private int nColumns;
        private int lastColumn = -1;

        public M3DRTab(int nColumns) {
            this.columns = new float[nColumns][];
            this.nColumns = nColumns;
        }

        public synchronized void incrementCounter() {
            ++this.counter;
            if (this.counter == this.maxRows) {
                for (int i = 0; i < this.nColumns; ++i) {
                    if (this.columns[i] == null) continue;
                    float[] tmp = new float[this.maxRows * 2];
                    System.arraycopy(this.columns[i], 0, tmp, 0, this.maxRows);
                    this.columns[i] = tmp;
                }
                this.maxRows *= 2;
            }
        }

        public int getCounter() {
            return this.counter;
        }

        public void addValue(int column, double value) {
            if (column < 0 || column >= this.nColumns) {
                throw new IllegalArgumentException("Index out of range: " + column);
            }
            if (this.counter == 0) {
                throw new IllegalArgumentException("Counter==0");
            }
            if (this.columns[column] == null) {
                this.columns[column] = new float[this.maxRows];
                if (column > this.lastColumn) {
                    this.lastColumn = column;
                }
            }
            this.columns[column][this.counter - 1] = (float)value;
        }

        public float[] getColumn(int column) {
            if (column < 0 || column >= this.nColumns) {
                throw new IllegalArgumentException("Index out of range: " + column);
            }
            if (this.columns[column] == null) {
                return null;
            }
            float[] data = new float[this.counter];
            for (int i = 0; i < this.counter; ++i) {
                data[i] = this.columns[column][i];
            }
            return data;
        }

        public float getValue(int column, int row) {
            if (this.columns[column] == null) {
                throw new IllegalArgumentException("Column not defined: " + column);
            }
            if (column >= this.nColumns || row >= this.counter) {
                throw new IllegalArgumentException("Index out of range: " + column + "," + row);
            }
            return this.columns[column][row];
        }

        public void setValue(int column, int row, double value) {
            if (column < 0 || column >= this.nColumns) {
                throw new IllegalArgumentException("Column out of range: " + column);
            }
            if (row >= this.counter) {
                throw new IllegalArgumentException("row>=counter");
            }
            if (this.columns[column] == null) {
                this.columns[column] = new float[this.maxRows];
                if (column > this.lastColumn) {
                    this.lastColumn = column;
                }
            }
            this.columns[column][row] = (float)value;
        }

        public synchronized void reset() {
            this.counter = 0;
            this.maxRows = 100;
            for (int i = 0; i <= this.lastColumn; ++i) {
                this.columns[i] = null;
            }
            this.lastColumn = -1;
        }
    }

    private class M3DRWin
    extends TextWindow {
        private Sync_Measure_3D parent;

        M3DRWin(String title, String heading, String data, int sizex, int sizey, Sync_Measure_3D parent) {
            super(title, heading, data, sizex, sizey);
            this.parent = parent;
            this.getMenuBar().getMenu(1).remove(3);
            this.getMenuBar().getMenu(1).remove(0);
        }

        public void processWindowEvent(WindowEvent e) {
            if (e.getID() == 201) {
                SaveChangesDialog d = new SaveChangesDialog((Frame)((Object)this), "Save Measurements?");
                if (d.cancelPressed()) {
                    return;
                }
                if (d.savePressed()) {
                    if (this.parent != null) {
                        this.parent.calcFinal();
                    }
                    this.getTextPanel().saveAs("");
                }
                if (this.parent != null) {
                    this.parent.stopMeasurements();
                }
            }
            super.processWindowEvent(e);
        }

        public void nullParent() {
            this.parent = null;
        }
    }
}

