/*
 * Decompiled with CFR 0.152.
 */
package fiji;

import fiji.MediaWikiClient;
import ij.Prefs;
import ij.gui.GenericDialog;
import java.awt.TextField;

public class GraphicalMediaWikiClient
extends MediaWikiClient {
    protected String login;
    protected String password;

    public GraphicalMediaWikiClient() {
    }

    public GraphicalMediaWikiClient(String wikiBaseURI) {
        super(wikiBaseURI);
    }

    public boolean login() {
        return this.login("Wiki login");
    }

    public boolean login(String title) {
        if (this.login != null && this.password != null) {
            this.logIn(this.login, this.password);
        }
        while (!this.isLoggedIn()) {
            GenericDialog gd = new GenericDialog(title);
            if (this.login == null) {
                this.login = Prefs.get((String)"fiji.wiki.user", (String)"");
            }
            gd.addStringField("Login", this.login, 20);
            gd.addStringField("Password", "", 20);
            ((TextField)gd.getStringFields().lastElement()).setEchoChar('*');
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.login = gd.getNextString();
            Prefs.set((String)"fiji.wiki.user", (String)this.login);
            this.password = gd.getNextString();
            this.logIn(this.login, this.password);
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Need 1 arg: the wiki URL");
            System.exit(1);
        }
        GraphicalMediaWikiClient client = new GraphicalMediaWikiClient(args[0]);
        System.err.println("login: " + client.login("Test"));
    }
}

