/*
 * Decompiled with CFR 0.152.
 */
package fiji;

import ij.IJ;
import ij.plugin.BrowserLauncher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class MediaWikiClient {
    final String wikiBaseURI;
    String sessionID;
    String domain;
    String loginToken;
    boolean loggedIn = false;
    String boundary = "---e69de29bb2d1d6434b8b29ae775ad8c2e48c5391";
    Map<String, String> cookies = new HashMap<String, String>();
    String response;
    String sessionKey = "wikidb_session";
    Pattern cookiePattern = Pattern.compile("^([a-z]+[^_]*_[^=]*session)=([^;]*);.*$");

    public MediaWikiClient() {
        this("http://fiji.sc/index.php");
    }

    public MediaWikiClient(String wikiBaseURI) {
        this.wikiBaseURI = wikiBaseURI;
    }

    boolean hasSessionKey() {
        return this.cookies.containsKey(this.sessionKey);
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean logIn(String user, String password) {
        if (this.loggedIn) {
            return true;
        }
        try {
            String[] getVars = new String[]{"title", "Special:Userlogin", "action", "submitlogin", "type", "login"};
            if (!this.hasSessionKey() || this.loginToken == null) {
                String response = this.sendRequest(getVars, null, null, true);
                this.loginToken = this.getFormVariable(response, "wpLoginToken");
                if (IJ.debugMode) {
                    this.debugShow(response);
                }
                if (!this.hasSessionKey()) {
                    System.err.println("Failed to get session key!");
                    return false;
                }
            }
            String[] postVars = new String[]{"wpName", user, "wpPassword", password, "wpDomain", this.domain, "wpLoginAttempt", "Log in", "wpLoginToken", this.loginToken};
            String response = this.sendRequest(getVars, postVars);
            this.loginToken = null;
            boolean bl = this.loggedIn = response.indexOf("Login error") < 0;
            if (IJ.debugMode) {
                this.debugShow(response);
            }
            return this.loggedIn;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean logOut() {
        if (!this.loggedIn) {
            return true;
        }
        try {
            String[] getVars = new String[]{"title", "Special:Userlogout"};
            String response = this.sendRequest(getVars, null);
            String expect = "You are now logged out.";
            this.loggedIn = response.indexOf(expect) < 0;
            return !this.loggedIn;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected String getFormVariable(String html, String name) {
        Pattern pattern = Pattern.compile(".*<input type=.hidden. value=\"([^\"]*)\" name=\"" + name + "\" />.*", 32);
        Matcher matcher = pattern.matcher(html);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        pattern = Pattern.compile(".*<input name=\"" + name + "\" type=.hidden. value=\"([^\"]*)\" />.*", 32);
        matcher = pattern.matcher(html);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        pattern = Pattern.compile(".*<input type=.hidden. name=\"" + name + "\" value=\"([^\"]*)\" />.*", 32);
        matcher = pattern.matcher(html);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public boolean uploadPage(String title, String contents, String comment) {
        String result = this.uploadOrPreviewPage(title, contents, comment, false);
        if (IJ.debugMode) {
            System.err.println("result: " + result);
        }
        return result != null;
    }

    public String uploadOrPreviewPage(String title, String contents, String comment, boolean previewOnly) {
        try {
            String[] getVars = new String[]{"title", title, "action", "edit"};
            String response = this.sendRequest(getVars, null);
            String time = this.getFormVariable(response, "wpEdittime");
            String token = this.getFormVariable(response, "wpEditToken");
            String summary = this.getFormVariable(response, "wpAutoSummary");
            if (time == null || token == null || summary == null) {
                System.err.println("time: " + time + ", token: " + token + ", summary: " + summary);
                if (IJ.debugMode) {
                    this.debugShow(response);
                }
                return null;
            }
            getVars = new String[]{"title", title, "action", "submit"};
            String[] postVars = new String[]{"wpSave", "Save page", "wpTextbox1", contents, "wpSummary", comment, "wpEdittime", time, "wpEditToken", token, "wpAutoSummary", summary, "wpRecreate", "1"};
            if (previewOnly) {
                postVars[0] = "wpPreview";
                postVars[1] = "Show preview";
            }
            return this.sendRequest(getVars, postVars);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean uploadFile(String fileName, String summary, File file) {
        try {
            byte[] buffer = new byte[(int)file.length()];
            FileInputStream in = new FileInputStream(file);
            in.read(buffer);
            in.close();
            return this.uploadFile(fileName, summary, buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean uploadFile(String fileName, String summary, byte[] contents) {
        String[] getVars = new String[]{"title", "Special:Upload"};
        String[] postVars = new String[]{"wpIgnoreWarning", "1", "wpSourceType", "file", "wpDestFile", fileName, "wpUploadDescription", summary, "wpUpload", "Upload file"};
        Object[] fileVars = new Object[]{"wpUploadFile", fileName, contents};
        try {
            boolean success;
            String response = this.sendRequest(getVars, postVars, fileVars, false);
            boolean bl = success = response.indexOf("<h2>Successful upload</h2>") > 0 || response.indexOf("No higher resolution available.") > 0 || response.indexOf("Full resolution") > 0;
            if (!success) {
                System.err.println("Failed: " + response);
            }
            return success;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding:" + e);
        }
    }

    public String sendRequest(String[] getVars, String[] postVars) throws IOException {
        return this.sendRequest(getVars, postVars, null, false);
    }

    String sendRequest(String[] getVars, String[] postVars, Object[] fileVars, boolean getSessionKey) throws IOException {
        int len;
        PrintStream ps;
        URL url;
        HttpURLConnection conn;
        String uri = this.wikiBaseURI;
        if (getVars != null) {
            int i = 0;
            while (i + 1 < getVars.length) {
                uri = uri + (i == 0 ? (char)'?' : '&') + this.urlEncode(getVars[i]) + '=' + this.urlEncode(getVars[i + 1]);
                i += 2;
            }
        }
        if ((conn = (HttpURLConnection)(url = new URL(uri)).openConnection()) instanceof HttpsURLConnection) {
            HttpsURLConnection secure = (HttpsURLConnection)conn;
            secure.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        conn.setDoInput(true);
        conn.setUseCaches(false);
        if (!getSessionKey) {
            String cookie = "";
            for (String key : this.cookies.keySet()) {
                String value;
                if (key.endsWith("LoggedOut") || "deleted".equals(value = this.cookies.get(key))) continue;
                if (cookie.length() > 0) {
                    cookie = cookie + "; ";
                }
                cookie = cookie + key + "=" + value;
            }
            conn.setRequestProperty("Cookie", cookie);
        }
        if (fileVars != null) {
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.connect();
            ps = new PrintStream(conn.getOutputStream());
            int i = 0;
            while (fileVars != null && i + 2 < fileVars.length) {
                ps.print("--" + this.boundary + "\r\n");
                this.postFile(ps, (String)fileVars[i], (String)fileVars[i + 1], (byte[])fileVars[i + 2]);
                i += 3;
            }
            i = 0;
            while (postVars != null && i + 1 < postVars.length) {
                ps.print("--" + this.boundary + "\r\nContent-Disposition: form-data; name=\"" + postVars[i] + "\"\r\n\r\n" + postVars[i + 1] + "\r\n");
                i += 2;
            }
            ps.println("--" + this.boundary + "--");
            ps.close();
        } else if (postVars != null) {
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            ps = new PrintStream(conn.getOutputStream());
            int i = 0;
            while (postVars != null && i + 1 < postVars.length) {
                if (postVars[i + 1] != null) {
                    ps.print((i == 0 ? "" : "&") + this.urlEncode(postVars[i]) + "=" + this.urlEncode(postVars[i + 1]));
                }
                i += 2;
            }
            ps.close();
        }
        int httpCode = conn.getResponseCode();
        if (httpCode != 200 && httpCode != 302) {
            throw new IOException("HTTP code: " + httpCode);
        }
        InputStream in = conn.getInputStream();
        this.response = "";
        byte[] buffer = new byte[65536];
        while ((len = in.read(buffer)) >= 0) {
            this.response = this.response + new String(buffer, 0, len);
        }
        in.close();
        this.getCookies(conn.getHeaderFields().get("Set-Cookie"));
        if (getSessionKey) {
            this.domain = null;
            int off = this.response.indexOf("<select name=\"wpDomain\"");
            if (off > 0) {
                int i1 = this.response.indexOf("<option>", off) + 8;
                int i2 = this.response.indexOf("</option>", i1);
                if (i1 > 8 && i2 > 0) {
                    this.domain = this.response.substring(i1, i2);
                }
            }
        }
        return this.response;
    }

    void postFile(PrintStream ps, String variableName, String fileName, byte[] contents) {
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        ps.print("Content-Disposition: form-data; name=\"" + variableName + "\"; filename=\"" + fileName + "\"\r\nContent-Type: " + contentType + "\r\n\r\n");
        ps.write(contents, 0, contents.length);
        ps.print("\r\n");
    }

    void getCookies(List<String> headers) {
        if (headers == null) {
            return;
        }
        for (String s : headers) {
            Matcher matcher = this.cookiePattern.matcher(s);
            if (matcher.matches()) {
                this.sessionKey = matcher.group(1);
                String value = matcher.group(2);
                this.cookies.put(this.sessionKey, value);
                continue;
            }
            int equal = s.indexOf(61);
            int semicolon = s.indexOf(59);
            if (equal <= 0 || semicolon <= equal) continue;
            String key = s.substring(0, equal);
            String value = s.substring(equal + 1, semicolon);
            if ("deleted".equals(value)) {
                this.cookies.remove(key);
                continue;
            }
            this.cookies.put(key, value);
        }
    }

    protected void debugShow(String html) {
        try {
            File tmp = File.createTempFile("preview", ".html");
            tmp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tmp);
            out.write(html.getBytes());
            out.close();
            new BrowserLauncher().run(tmp.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

