/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.hdf5;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ij.IJ;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import sc.fiji.hdf5.DataSetInfo;
import sc.fiji.hdf5.HDF5ImageJ;
import sc.fiji.hdf5.TableColumnAdjuster;

public class HDF5_Reader_Vibez
extends JFrame
implements PlugIn,
ActionListener {
    private ArrayList<DataSetInfo> dataSets_;
    private JTable pathTable_;
    private String fullFileName_;
    private JRadioButton[] loadAsRadioButtons_;
    private int loadAsMode_;
    private SpinnerNumberModel nChannelsSpinner_;
    private JTextField dsetLayoutTextField_;

    public void run(String arg) {
        boolean tryAgain;
        String directory = "";
        String name = "";
        String openMSG = "Open HDF5...";
        do {
            tryAgain = false;
            OpenDialog od = directory.equals("") ? new OpenDialog(openMSG, "") : new OpenDialog(openMSG, directory, "");
            directory = od.getDirectory();
            name = od.getFileName();
            if (name == null) {
                return;
            }
            if (name == "") {
                return;
            }
            File testFile = new File(directory + name);
            if (!testFile.exists() || !testFile.canRead()) {
                return;
            }
            if (!testFile.isDirectory()) continue;
            directory = directory + name;
            tryAgain = true;
        } while (tryAgain);
        this.fullFileName_ = directory + name;
        IJ.showStatus((String)("Loading HDF5 File: " + this.fullFileName_));
        IHDF5Reader reader = HDF5Factory.openForReading((String)this.fullFileName_);
        this.dataSets_ = new ArrayList();
        this.recursiveGetInfo(reader, reader.object().getLinkInformation("/"));
        reader.close();
        Collections.sort(this.dataSets_, DataSetInfo.createComparator());
        IJ.log((String)"ALL DATASETS:");
        for (DataSetInfo info : this.dataSets_) {
            IJ.log((String)(info.path + " (" + info.dimText + " " + info.typeText + ")"));
        }
        Vector tableData = new Vector();
        for (int row = 0; row < this.dataSets_.size(); ++row) {
            Vector<String> line = new Vector<String>();
            line.addElement("<html>" + this.dataSets_.get((int)row).path.replace("/", "<font color='red'><strong>/</strong></font>") + "</html>");
            line.addElement("<html>" + this.dataSets_.get((int)row).dimText.replace("x", "<font color='red'>&times;</font>") + "</html>");
            line.addElement(this.dataSets_.get((int)row).typeText);
            line.addElement("<html>" + this.dataSets_.get((int)row).element_size_um_text.replace("x", "<font color='red'>&times;</font>") + "</html>");
            tableData.addElement(line);
        }
        String[] columnTitles = new String[]{"path", "size", "type"};
        Vector<String> columnNames = new Vector<String>();
        columnNames.addElement("data set path");
        columnNames.addElement("size");
        columnNames.addElement("type");
        columnNames.addElement("element size [um]");
        DefaultTableModel tableModel = new DefaultTableModel(tableData, columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.pathTable_ = new JTable(tableModel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        int currentRow = 0;
        cs.anchor = 23;
        cs.fill = 2;
        cs.ipady = 10;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        cs.gridy = currentRow++;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 2;
        JLabel titleText = new JLabel("<html><h2>Select data sets</h2></html>");
        this.add((Component)titleText, cs);
        cs.fill = 1;
        cs.ipady = 100;
        cs.weightx = 1.0;
        cs.weighty = 1.0;
        cs.gridx = 0;
        cs.gridy = currentRow;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 2;
        JScrollPane scrollPaneT = new JScrollPane(this.pathTable_);
        scrollPaneT.setMinimumSize(new Dimension(1, 100));
        this.add((Component)scrollPaneT, cs);
        this.pathTable_.setAutoResizeMode(0);
        TableColumnAdjuster tca = new TableColumnAdjuster(this.pathTable_);
        tca.adjustColumns();
        this.loadAsRadioButtons_ = new JRadioButton[5];
        this.loadAsRadioButtons_[0] = new JRadioButton("individual stacks");
        this.loadAsRadioButtons_[1] = new JRadioButton("individual hyperstacks (custom layout)");
        this.loadAsRadioButtons_[2] = new JRadioButton("hyperstack (multichannel)");
        this.loadAsRadioButtons_[3] = new JRadioButton("hyperstack (time series)");
        this.loadAsRadioButtons_[4] = new JRadioButton("hyperstack (multichannel time series)");
        int loadAsMode = (int)Prefs.get((String)"hdf5readervibez.loadasmode", (double)0.0);
        this.loadAsRadioButtons_[loadAsMode].setSelected(true);
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < 5; ++i) {
            group.add(this.loadAsRadioButtons_[i]);
        }
        cs.fill = 2;
        cs.ipady = 0;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        cs.gridy = ++currentRow;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 2;
        JLabel subtitleText = new JLabel("Load as ...");
        this.add((Component)subtitleText, cs);
        for (int i = 0; i < 2; ++i) {
            cs.gridy = ++currentRow;
            this.add((Component)this.loadAsRadioButtons_[i], cs);
        }
        JLabel layoutText = new JLabel("       - data set layout:");
        cs.weightx = 1.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        ++currentRow;
        cs.gridy = currentRow++;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 1;
        cs.fill = 0;
        this.add((Component)layoutText, cs);
        cs.fill = 2;
        String dsetLayout = Prefs.get((String)"hdf5readervibez.dsetLayout", (String)"zyx");
        this.dsetLayoutTextField_ = new JTextField(dsetLayout, 6);
        cs.gridx = 1;
        this.add((Component)this.dsetLayoutTextField_, cs);
        cs.fill = 2;
        cs.ipady = 0;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        cs.gridy = currentRow++;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 2;
        JLabel subtitleText2 = new JLabel("Combine to ...");
        cs.gridy = currentRow;
        this.add((Component)subtitleText2, cs);
        for (int i = 2; i < 5; ++i) {
            cs.gridy = ++currentRow;
            this.add((Component)this.loadAsRadioButtons_[i], cs);
        }
        JLabel spinnerText = new JLabel("       - Number of channels:");
        cs.weightx = 1.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        ++currentRow;
        cs.gridy = currentRow++;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 1;
        cs.fill = 0;
        this.add((Component)spinnerText, cs);
        this.nChannelsSpinner_ = new SpinnerNumberModel(1, 1, 10, 1);
        JSpinner spinner = new JSpinner(this.nChannelsSpinner_);
        cs.gridx = 1;
        this.add((Component)spinner, cs);
        int nChannels = (int)Prefs.get((String)"hdf5readervibez.nchannels", (double)1.0);
        spinner.setValue(nChannels);
        JButton b1 = new JButton("Load");
        b1.setActionCommand("load");
        b1.addActionListener(this);
        cs.ipady = 0;
        cs.weightx = 1.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        cs.fill = 0;
        this.add((Component)b1, cs);
        JButton b2 = new JButton("Cancel");
        b2.setActionCommand("cancel");
        b2.addActionListener(this);
        cs.gridx = 1;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        this.add((Component)b2, cs);
        this.pack();
        Dimension si = this.getSize();
        si.height = 400;
        si.width = this.pathTable_.getWidth() + 40;
        this.setSize(si);
        this.setVisible(true);
    }

    private void recursiveGetInfo(IHDF5Reader reader, HDF5LinkInformation link) {
        HDF5ImageJ.recursiveGetInfo(reader, link, this.dataSets_);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("load")) {
            this.loadHDF5();
        } else if (event.getActionCommand().equals("cancel")) {
            this.dispose();
        }
    }

    public void loadHDF5() {
        int[] selection = this.pathTable_.getSelectedRows();
        if (selection.length == 0) {
            IJ.error((String)"load HDF5", (String)"You must select at least one data set");
            return;
        }
        int loadAsMode = 0;
        for (int i = 0; i < this.loadAsRadioButtons_.length; ++i) {
            if (!this.loadAsRadioButtons_[i].isSelected()) continue;
            loadAsMode = i;
        }
        Prefs.set((String)"hdf5readervibez.loadasmode", (int)loadAsMode);
        if (loadAsMode == 0) {
            for (int i : selection) {
                IJ.log((String)("i = " + i + this.dataSets_.get((int)i).path));
                String[] dsetNames = new String[]{this.dataSets_.get((int)i).path};
                String type = this.dataSets_.get((int)i).typeText;
                HDF5ImageJ.loadDataSetsToHyperStack(this.fullFileName_, dsetNames, 1, 1);
            }
        } else if (loadAsMode == 1) {
            for (int i : selection) {
                IJ.log((String)("i = " + i + this.dataSets_.get((int)i).path));
                String dsetLayout = this.dsetLayoutTextField_.getText();
                Prefs.set((String)"hdf5readervibez.dsetLayout", (String)dsetLayout);
                HDF5ImageJ.loadCustomLayoutDataSetToHyperStack(this.fullFileName_, this.dataSets_.get((int)i).path, dsetLayout);
            }
        } else {
            String[] dsetNames = new String[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                dsetNames[i] = this.dataSets_.get((int)selection[i]).path;
            }
            int nChannels = 1;
            if (loadAsMode == 2) {
                nChannels = selection.length;
            }
            if (loadAsMode == 3) {
                nChannels = 1;
            }
            if (loadAsMode == 4) {
                nChannels = this.nChannelsSpinner_.getNumber().intValue();
            }
            if (nChannels > dsetNames.length) {
                nChannels = dsetNames.length;
            }
            Prefs.set((String)"hdf5readervibez.nchannels", (int)nChannels);
            int nFrames = dsetNames.length / nChannels;
            Prefs.set((String)"hdf5readervibez.nframes", (int)nFrames);
            String commaSeparatedDsetNames = "";
            for (int i = 0; i < dsetNames.length; ++i) {
                if (i > 0) {
                    commaSeparatedDsetNames = commaSeparatedDsetNames + ",";
                }
                commaSeparatedDsetNames = commaSeparatedDsetNames + dsetNames[i];
            }
            Prefs.set((String)"hdf5readervibez.dsetnames", (String)commaSeparatedDsetNames);
            String type = this.dataSets_.get((int)selection[0]).typeText;
            HDF5ImageJ.loadDataSetsToHyperStack(this.fullFileName_, dsetNames, nFrames, nChannels);
        }
        this.dispose();
    }
}

