/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import java.util.concurrent.ExecutorService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.readwrite.SamplerConverter;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.display.imagej.ImageJVirtualStack;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.Util;

public class ImageJVirtualStackUnsignedShort
extends ImageJVirtualStack<UnsignedShortType> {
    public static <T extends RealType<?>> ImageJVirtualStackUnsignedShort wrap(RandomAccessibleInterval<T> source) {
        ImageJVirtualStackUnsignedShort result = new ImageJVirtualStackUnsignedShort(ImageJVirtualStackUnsignedShort.toUnsignedShort(source));
        result.initMinMax(Util.getTypeFromInterval(source));
        return result;
    }

    private static <T extends RealType<?>> RandomAccessibleInterval<UnsignedShortType> toUnsignedShort(RandomAccessibleInterval<T> source) {
        if (Util.getTypeFromInterval(source) instanceof UnsignedShortType) {
            return source;
        }
        return Converters.convert(source, (SamplerConverter)new ShortConverter((RealType)Util.getTypeFromInterval(source)));
    }

    public <S> ImageJVirtualStackUnsignedShort(RandomAccessibleInterval<S> source, Converter<? super S, UnsignedShortType> converter) {
        this(source, converter, null);
    }

    public <S> ImageJVirtualStackUnsignedShort(RandomAccessibleInterval<S> source, Converter<? super S, UnsignedShortType> converter, ExecutorService service) {
        super(source, converter, new UnsignedShortType(), 16, service);
        this.initMinMax(Util.getTypeFromInterval(source));
    }

    private ImageJVirtualStackUnsignedShort(RandomAccessibleInterval<UnsignedShortType> source) {
        super(source, 16);
    }

    private void initMinMax(Object s) {
        int maxDisplay = 65535;
        if (BitType.class.isInstance(s)) {
            maxDisplay = 1;
        } else if (Unsigned12BitType.class.isInstance(s)) {
            maxDisplay = 4095;
        }
        this.setMinAndMax(0.0, maxDisplay);
    }

    private static class ShortConverter
    implements SamplerConverter<RealType<?>, UnsignedShortType> {
        private final double min;
        private final double max;

        ShortConverter(RealType<?> type) {
            this.min = type.getMinValue();
            this.max = type.getMaxValue();
        }

        public UnsignedShortType convert(final Sampler<? extends RealType<?>> sampler) {
            return new UnsignedShortType(new ShortAccess(){

                public short getValue(int index) {
                    double val = ((RealType)sampler.get()).getRealDouble() + 0.5;
                    if (val < 0.0) {
                        val = 0.0;
                    } else if (val > 65535.0) {
                        val = 65535.0;
                    }
                    return (short)val;
                }

                public void setValue(int index, short value) {
                    double val = value;
                    if (val < min) {
                        val = min;
                    } else if (val > max) {
                        val = max;
                    }
                    ((RealType)sampler.get()).setReal(val);
                }
            });
        }
    }
}

