/*
 * Decompiled with CFR 0.152.
 */
package bdv.spimdata.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.EntityUtils;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;

public class ChangeAttributeId {
    public static Map<String, Map<Integer, Integer>> assignNewAttributeIds(AbstractSpimData<?> spimData, Map<String, Set<Integer>> idsInUse) {
        List setups = spimData.getSequenceDescription().getViewSetupsOrdered();
        HashSet<Entity> occurringAttributes = new HashSet<Entity>();
        HashMap attributeNameToChangeSet = new HashMap();
        HashMap<String, Map<Integer, Integer>> attributeNameToIdMap = new HashMap<String, Map<Integer, Integer>>();
        for (BasicViewSetup basicViewSetup : setups) {
            for (Map.Entry entry : basicViewSetup.getAttributes().entrySet()) {
                int oldId;
                String attributeName = (String)entry.getKey();
                Entity attribute = (Entity)entry.getValue();
                if (!occurringAttributes.add(attribute)) continue;
                Set<Integer> used = idsInUse.get(attributeName);
                if (used == null) {
                    used = new HashSet<Integer>();
                    idsInUse.put(attributeName, used);
                }
                int newId = oldId = attribute.getId();
                while (used.contains(newId)) {
                    ++newId;
                }
                if (newId != oldId) {
                    HashMap<Integer, Integer> idMap;
                    HashSet<Entity> changeSet = (HashSet<Entity>)attributeNameToChangeSet.get(attributeName);
                    if (changeSet == null) {
                        changeSet = new HashSet<Entity>();
                        attributeNameToChangeSet.put(attributeName, changeSet);
                    }
                    if ((idMap = (HashMap<Integer, Integer>)attributeNameToIdMap.get(attributeName)) == null) {
                        idMap = new HashMap<Integer, Integer>();
                        attributeNameToIdMap.put(attributeName, idMap);
                    }
                    changeSet.add(attribute);
                    idMap.put(oldId, newId);
                }
                used.add(newId);
            }
        }
        for (Map.Entry entry : attributeNameToChangeSet.entrySet()) {
            String attributeName = (String)entry.getKey();
            Set attributesToChange = (Set)entry.getValue();
            Map oldIdToNewIdMap = (Map)attributeNameToIdMap.get(attributeName);
            EntityUtils.changeIds((Collection)attributesToChange, (Map)oldIdToNewIdMap);
        }
        return attributeNameToIdMap;
    }

    public static void changeAttributeId(AbstractSpimData<?> spimData, String attributeName, int oldAttributeId, int newAttributeId) {
        List setups = spimData.getSequenceDescription().getViewSetupsOrdered();
        HashSet<Entity> attributes = new HashSet<Entity>();
        for (BasicViewSetup setup : setups) {
            Entity attribute = (Entity)setup.getAttributes().get(attributeName);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        EntityUtils.changeIds(attributes, (int[])new int[]{oldAttributeId, newAttributeId});
    }
}

