/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import net.imglib2.RealInterval;

public class IntervalCorners {
    public static int numCorners(RealInterval interval) {
        return 1 << interval.numDimensions();
    }

    public static double[] corner(RealInterval interval, int index) {
        int n = interval.numDimensions();
        double[] corner = new double[n];
        int d = 0;
        int mask = 1;
        while (d < n) {
            corner[d] = (index & mask) == 0 ? interval.realMin(d) : interval.realMax(d);
            ++d;
            mask <<= 1;
        }
        return corner;
    }

    public static void corner(RealInterval interval, int index, double[] corner) {
        assert (corner.length == interval.numDimensions());
        int d = 0;
        int mask = 1;
        while (d < corner.length) {
            corner[d] = (index & mask) == 0 ? interval.realMin(d) : interval.realMax(d);
            ++d;
            mask <<= 1;
        }
    }

    public static double[][] corners(RealInterval interval) {
        int n = interval.numDimensions();
        int numCorners = 1 << n;
        double[][] corners = new double[numCorners][n];
        for (int index = 0; index < numCorners; ++index) {
            int d = 0;
            int mask = 1;
            while (d < n) {
                corners[index][d] = (index & mask) == 0 ? interval.realMin(d) : interval.realMax(d);
                ++d;
                mask <<= 1;
            }
        }
        return corners;
    }

    private IntervalCorners() {
    }
}

