/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.app;

import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="| It's a secret to everyone |", headless=true, attrs={@Attr(name="no-legacy")})
public class EasterEgg
implements Command {
    private static final String CHARS = "#O*o+-,. ";
    @Parameter
    public Dataset dataset;
    @Parameter(type=ItemIO.OUTPUT)
    public String ascii;

    public void run() {
        double max;
        double min = this.dataset.getChannelMinimum(0);
        if (min == (max = this.dataset.getChannelMaximum(0))) {
            return;
        }
        ImgPlus imgPlus = this.dataset.getImgPlus();
        int colCount = (int)imgPlus.dimension(0);
        int rowCount = (int)imgPlus.dimension(1);
        RandomAccess access = imgPlus.randomAccess();
        StringBuilder sb = new StringBuilder();
        for (int r = 0; r < rowCount; ++r) {
            access.setPosition(r, 1);
            for (int c = 0; c < colCount; ++c) {
                access.setPosition(c, 0);
                double value = ((RealType)access.get()).getRealDouble();
                sb.append(this.getChar(value, min, max));
            }
            sb.append("\n");
        }
        this.ascii = sb.toString();
    }

    private char getChar(double value, double min, double max) {
        double norm;
        int len = CHARS.length();
        int index = (int)((double)len * (norm = (value - min) / (max - min)));
        if (index < 0) {
            return CHARS.charAt(0);
        }
        if (index >= len) {
            return CHARS.charAt(len - 1);
        }
        return CHARS.charAt(index);
    }
}

