/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyDialogs;
import QuickPALM.MyFunctions;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.ResultsTable;
import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

class ReconstructionViewer {
    ImagePlus imp;
    ImageProcessor ip;
    MyDialogs settings;
    ResultsTable table;
    MyFunctions functions;
    GaussianBlur gblur = new GaussianBlur();
    int position = 0;
    int max = 0;
    int min = 9999999;
    double maxZ = 10.0;
    double minZ = -10.0;
    double[] s;
    double[] x;
    double[] y;
    double[] z;
    double[] f;
    int nframes = 0;

    ReconstructionViewer(String title, int width, int height, MyDialogs dg, MyFunctions f) {
        this.settings = dg;
        this.table = f.ptable;
        this.functions = f;
        int new_width = (int)((double)width * this.settings.magn + 1.0);
        int new_height = (int)((double)height * this.settings.magn + 1.0);
        if (this.settings.view) {
            this.ip = new ColorProcessor(new_width, new_height);
            this.imp = new ImagePlus(title, this.ip);
            IJ.run((ImagePlus)this.imp, (String)"Set Scale...", (String)("distance=1 known=" + this.settings.pixelsize / this.settings.magn + " pixel=1 unit=nm"));
            this.imp.show();
        }
    }

    ReconstructionViewer(String title, MyDialogs dg, MyFunctions f_) {
        this.settings = dg;
        this.table = f_.ptable;
        this.functions = f_;
        double pixelsize = this.table.getValue("X (nm)", 0) / this.table.getValue("X (px)", 0);
        this.settings.magn = pixelsize / this.settings.viewer_tpixelsize;
        int new_width = (int)((double)this.settings.viewer_owidth * this.settings.magn + 1.0);
        int new_height = (int)((double)this.settings.viewer_oheight * this.settings.magn + 1.0);
        this.ip = this.settings.view_mode == this.settings.view_modes[3] ? new ByteProcessor(new_width, new_height) : (this.settings.view_mode == this.settings.view_modes[1] || this.settings.view_mode == this.settings.view_modes[2] ? new ShortProcessor(new_width, new_height) : new ColorProcessor(new_width, new_height));
        this.imp = new ImagePlus(title, this.ip);
        IJ.run((ImagePlus)this.imp, (String)"Set Scale...", (String)("distance=1 known=" + this.settings.viewer_tpixelsize + " pixel=1 unit=nm"));
        this.functions.ptable_lock.lock();
        this.s = this.table.getColumnAsDoubles(0);
        this.x = this.table.getColumnAsDoubles(1);
        this.y = this.table.getColumnAsDoubles(2);
        this.z = this.table.getColumnAsDoubles(5);
        this.f = this.table.getColumnAsDoubles(13);
        this.functions.ptable_lock.unlock();
        for (int n = 0; n < this.f.length; ++n) {
            if (this.f[n] > (double)this.nframes) {
                this.nframes = (int)this.f[n];
            }
            if (this.s[n] > (double)this.max) {
                this.max = (int)Math.round(this.s[n]);
            }
            if (this.s[n] < (double)this.min) {
                this.min = (int)Math.round(this.s[n]);
            }
            if (this.z[n] > this.maxZ) {
                this.maxZ = (int)Math.round(this.z[n]);
            }
            if (this.z[n] < this.minZ) {
                this.minZ = (int)Math.round(this.z[n]);
            }
            if (!(this.f[n] > (double)this.nframes)) continue;
            this.nframes = (int)this.f[n];
        }
        if (dg.viewer_mergeabove != 0.0) {
            this.maxZ = dg.viewer_mergeabove;
        }
        if (dg.viewer_mergebellow != 0.0) {
            this.minZ = dg.viewer_mergebellow;
        }
        if (this.settings.view_mode == this.settings.view_modes[0]) {
            this.calculateColorBar();
        }
    }

    void draw(int fstart, int fstop, double zstart, double zstop) {
        int type = this.imp.getBitDepth();
        int[] old_rgb = new int[3];
        int[] new_rgb = new int[3];
        for (int n = 0; n < this.f.length; ++n) {
            double new_v;
            double old_v;
            if (!(this.f[n] >= (double)fstart) || !(this.f[n] <= (double)fstop) || !(this.z[n] >= zstart) || !(this.z[n] <= zstop)) continue;
            int xmag = (int)Math.round(this.x[n] * this.settings.magn);
            int ymag = (int)Math.round(this.y[n] * this.settings.magn);
            xmag = xmag >= this.ip.getWidth() ? this.ip.getWidth() - 1 : xmag;
            xmag = xmag < 0 ? 0 : xmag;
            ymag = ymag >= this.ip.getHeight() ? this.ip.getHeight() - 1 : ymag;
            int n2 = ymag = ymag < 0 ? 0 : ymag;
            if (this.settings.view_mode == this.settings.view_modes[0]) {
                old_rgb = this.ip.getPixel(xmag, ymag, old_rgb);
                new_rgb = this.calculateColor(this.s[n], this.z[n]);
                new_rgb[0] = new_rgb[0] + old_rgb[0];
                new_rgb[1] = new_rgb[1] + old_rgb[1];
                new_rgb[2] = new_rgb[2] + old_rgb[2];
                new_rgb[0] = new_rgb[0] > 255 ? 255 : new_rgb[0];
                new_rgb[1] = new_rgb[1] > 255 ? 255 : new_rgb[1];
                new_rgb[2] = new_rgb[2] > 255 ? 255 : new_rgb[2];
                this.ip.putPixel(xmag, ymag, new_rgb);
                continue;
            }
            if (this.settings.view_mode == this.settings.view_modes[1]) {
                old_v = this.ip.get(xmag, ymag);
                new_v = old_v + 1.0;
                this.ip.set(xmag, ymag, (int)new_v);
                continue;
            }
            if (this.settings.view_mode == this.settings.view_modes[2]) {
                old_v = this.ip.get(xmag, ymag);
                new_v = this.s[n] + old_v;
                this.ip.set(xmag, ymag, (int)new_v);
                continue;
            }
            int satv = 255;
            old_v = this.ip.get(xmag, ymag);
            new_v = (this.s[n] - (double)this.min) / (double)(this.max - this.min) * (double)satv;
            new_v = (new_v = (double)Math.round(new_v + old_v)) > (double)satv ? (double)satv : new_v;
            this.ip.set(xmag, ymag, (int)new_v);
        }
        if (this.settings.viewer_doConvolve) {
            this.gblur.blur(this.ip, this.settings.viewer_fwhm / 2.354 / this.settings.viewer_tpixelsize);
        }
        this.imp.updateAndDraw();
    }

    ImagePlus calculateColorBar() {
        int border = 20;
        ColorProcessor ipbar = new ColorProcessor(80, 510 + border * 2);
        ImagePlus impbar = new ImagePlus("Depth coding", (ImageProcessor)ipbar);
        int[] c = new int[3];
        for (int n = 0; n <= 510; ++n) {
            c[0] = n >= 255 ? n - 255 : 0;
            c[1] = n <= 255 ? n : 510 - n;
            c[2] = n <= 255 ? 255 - n : 0;
            for (int m = 0; m < 10; ++m) {
                ipbar.putPixel(m, n + border, c);
            }
        }
        impbar.updateAndDraw();
        impbar.show();
        IJ.runMacro((String)"setFont(\"SansSerif\", 18, \" antialiased\");");
        IJ.run((String)"Colors...", (String)"foreground=white background=black selection=yellow");
        IJ.runMacro((String)("drawString(\"< " + Math.round(this.minZ) + "\", " + 12 + ", " + (border + 6) + ");"));
        IJ.runMacro((String)("drawString(\"  " + Math.round(this.minZ + (this.maxZ - this.minZ) * 1.0 / 6.0) + "\", " + 12 + ", " + (85 + border + 6) + ");"));
        IJ.runMacro((String)("drawString(\"  " + Math.round(this.minZ + (this.maxZ - this.minZ) * 2.0 / 6.0) + "\", " + 12 + ", " + (170 + border + 6) + ");"));
        IJ.runMacro((String)("drawString(\"  " + Math.round(this.minZ + (this.maxZ - this.minZ) * 3.0 / 6.0) + "\", " + 12 + ", " + (255 + border + 6) + ");"));
        IJ.runMacro((String)("drawString(\"  " + Math.round(this.minZ + (this.maxZ - this.minZ) * 4.0 / 6.0) + "\", " + 12 + ", " + (340 + border + 6) + ");"));
        IJ.runMacro((String)("drawString(\"  " + Math.round(this.minZ + (this.maxZ - this.minZ) * 5.0 / 6.0) + "\", " + 12 + ", " + (425 + border + 6) + ");"));
        IJ.runMacro((String)("drawString(\"> " + Math.round(this.minZ + (this.maxZ - this.minZ) * 6.0 / 6.0) + "\", " + 12 + ", " + (510 + border + 6) + ");"));
        return impbar;
    }

    int[] calculateColor(double s, double z) {
        double vs = (s - (double)this.min) / (double)(this.max - this.min) * (1.0 + this.settings.saturation);
        double vz = (z - this.minZ) / (this.maxZ - this.minZ);
        int[] c = new int[3];
        if (vz > 1.0) {
            vz = 1.0;
        } else if (vz < 0.0) {
            vz = 0.0;
        }
        double vz_ = 255.0 * vz * 2.0;
        c[0] = (int)Math.round((vz >= 0.5 ? vz_ - 255.0 : 0.0) * vs);
        c[1] = (int)Math.round((vz <= 0.5 ? vz_ : 510.0 - vz_) * vs);
        c[2] = (int)Math.round((vz <= 0.5 ? 255.0 - vz_ : 0.0) * vs);
        c[0] = c[0] > 255 ? 255 : c[0];
        c[1] = c[1] > 255 ? 255 : c[1];
        c[2] = c[2] > 255 ? 255 : c[2];
        return c;
    }

    void update() {
        if (!this.settings.view) {
            return;
        }
        int new_p = this.table.getCounter();
        if (new_p == 0 || new_p == this.position) {
            return;
        }
        this.update(this.position, new_p - 1);
        this.position = new_p;
    }

    void update(int start, int stop) {
        if (!this.settings.view) {
            return;
        }
        int nresults = this.table.getCounter();
        start = start < 0 ? 0 : start;
        stop = stop > nresults ? nresults - 1 : stop;
        this.s = new double[stop - start + 1];
        this.x = new double[stop - start + 1];
        this.y = new double[stop - start + 1];
        this.z = new double[stop - start + 1];
        this.functions.ptable_lock.lock();
        for (int n = start; n <= stop; ++n) {
            int index = n - start;
            this.s[index] = this.table.getValueAsDouble(0, n);
            this.x[index] = this.table.getValueAsDouble(1, n);
            this.y[index] = this.table.getValueAsDouble(2, n);
            this.z[index] = this.table.getValueAsDouble(5, n);
        }
        this.functions.ptable_lock.unlock();
        boolean newMax = false;
        boolean newMin = false;
        boolean newMaxZ = false;
        boolean newMinZ = false;
        for (int n = 0; n <= stop - start; ++n) {
            if (this.s[n] > (double)this.max) {
                newMax = true;
                this.max = (int)Math.round(this.s[n]);
            }
            if (this.s[n] < (double)this.min) {
                newMin = true;
                this.min = (int)Math.round(this.s[n]);
            }
            if (this.z[n] > this.maxZ) {
                newMaxZ = true;
                this.maxZ = this.z[n];
            }
            if (!(this.z[n] < this.minZ)) continue;
            newMinZ = true;
            this.minZ = this.z[n];
        }
        if (newMax || newMinZ || newMaxZ || newMin) {
            this.clear();
            this.update(0, stop);
            return;
        }
        int[] old_rgb = new int[3];
        int[] new_rgb = new int[3];
        for (int n = 0; n <= stop - start; ++n) {
            int xmag = (int)Math.round(this.x[n] * this.settings.magn);
            int ymag = (int)Math.round(this.y[n] * this.settings.magn);
            this.ip.getPixel(xmag, ymag, old_rgb);
            new_rgb = this.calculateColor(this.s[n], this.z[n]);
            if (old_rgb[0] + old_rgb[1] + old_rgb[2] >= new_rgb[0] + new_rgb[1] + new_rgb[2]) continue;
            this.ip.putPixel(xmag, ymag, new_rgb);
        }
        this.imp.updateAndDraw();
    }

    void updateShort(int fstart, int fstop) {
        if (!this.settings.view) {
            return;
        }
        this.clear();
        this.functions.ptable_lock.lock();
        this.s = this.table.getColumnAsDoubles(0);
        this.x = this.table.getColumnAsDoubles(1);
        this.y = this.table.getColumnAsDoubles(2);
        this.z = this.table.getColumnAsDoubles(5);
        this.f = this.table.getColumnAsDoubles(13);
        this.functions.ptable_lock.unlock();
        int[] old_rgb = new int[3];
        int[] new_rgb = new int[3];
        for (int n = 0; n < this.f.length; ++n) {
            if (!(this.f[n] >= (double)fstart) || !(this.f[n] <= (double)fstop)) continue;
            int xmag = (int)Math.round(this.x[n] * this.settings.magn);
            int ymag = (int)Math.round(this.y[n] * this.settings.magn);
            this.ip.getPixel(xmag, ymag, old_rgb);
            new_rgb = this.calculateColor(this.s[n], this.z[n]);
            if (old_rgb[0] + old_rgb[1] + old_rgb[2] >= new_rgb[0] + new_rgb[1] + new_rgb[2]) continue;
            this.ip.putPixel(xmag, ymag, new_rgb);
        }
        this.imp.updateAndDraw();
    }

    void clear() {
        if (!this.settings.view) {
            return;
        }
        for (int i = 0; i < this.ip.getWidth(); ++i) {
            for (int j = 0; j < this.ip.getHeight(); ++j) {
                this.ip.set(i, j, 0);
            }
        }
        this.position = 0;
    }
}

